/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;

public record IcebergPartitionFunction(Transform transform, List<Integer> dataPath, Type type, OptionalInt size) {
    public IcebergPartitionFunction(Transform transform, List<Integer> dataPath, Type type) {
        this(transform, dataPath, type, OptionalInt.empty());
    }

    public IcebergPartitionFunction {
        Objects.requireNonNull(transform, "transform is null");
        Objects.requireNonNull(dataPath, "dataPath is null");
        Preconditions.checkArgument((!dataPath.isEmpty() ? 1 : 0) != 0, (Object)"dataPath is empty");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(size, "size is null");
        Preconditions.checkArgument((size.orElse(0) >= 0 ? 1 : 0) != 0, (Object)"size must be greater than or equal to zero");
        Preconditions.checkArgument((size.isEmpty() || transform == Transform.BUCKET || transform == Transform.TRUNCATE ? 1 : 0) != 0, (Object)"size is only valid for BUCKET and TRUNCATE transforms");
    }

    public IcebergPartitionFunction withTopLevelColumnIndex(int newColumnIndex) {
        return new IcebergPartitionFunction(this.transform, (List<Integer>)ImmutableList.builder().add((Object)newColumnIndex).addAll(this.dataPath().subList(1, this.dataPath().size())).build(), this.type, this.size);
    }

    public static IcebergPartitionFunction create(String transform, List<Integer> dataPath, Type type) {
        return switch (transform) {
            case "identity" -> new IcebergPartitionFunction(Transform.IDENTITY, dataPath, type);
            case "year" -> new IcebergPartitionFunction(Transform.YEAR, dataPath, type);
            case "month" -> new IcebergPartitionFunction(Transform.MONTH, dataPath, type);
            case "day" -> new IcebergPartitionFunction(Transform.DAY, dataPath, type);
            case "hour" -> new IcebergPartitionFunction(Transform.HOUR, dataPath, type);
            case "void" -> new IcebergPartitionFunction(Transform.VOID, dataPath, type);
            default -> {
                Matcher matcher = PartitionFields.ICEBERG_BUCKET_PATTERN.matcher(transform);
                if (matcher.matches()) {
                    yield new IcebergPartitionFunction(Transform.BUCKET, dataPath, type, OptionalInt.of(Integer.parseInt(matcher.group(1))));
                }
                matcher = PartitionFields.ICEBERG_TRUNCATE_PATTERN.matcher(transform);
                if (matcher.matches()) {
                    yield new IcebergPartitionFunction(Transform.TRUNCATE, dataPath, type, OptionalInt.of(Integer.parseInt(matcher.group(1))));
                }
                throw new UnsupportedOperationException("Unsupported partition transform: " + transform);
            }
        };
    }

    public static enum Transform {
        IDENTITY,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        VOID,
        BUCKET,
        TRUNCATE;

    }
}

