/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.AllowAllSecurityModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.hive.security.UsingSystemSecurity;
import io.trino.plugin.iceberg.IcebergSecurityConfig;

public class IcebergSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.install(switch (((IcebergSecurityConfig)this.buildConfigObject(IcebergSecurityConfig.class)).getSecuritySystem()) {
            default -> throw new MatchException(null, null);
            case IcebergSecurityConfig.IcebergSecurity.ALLOW_ALL -> ConfigurationAwareModule.combine((Module[])new Module[]{new AllowAllSecurityModule(), IcebergSecurityModule.usingSystemSecurity(false)});
            case IcebergSecurityConfig.IcebergSecurity.READ_ONLY -> ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), IcebergSecurityModule.usingSystemSecurity(false)});
            case IcebergSecurityConfig.IcebergSecurity.FILE -> ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), IcebergSecurityModule.usingSystemSecurity(false)});
            case IcebergSecurityConfig.IcebergSecurity.SYSTEM -> IcebergSecurityModule.usingSystemSecurity(true);
        });
    }

    private static Module usingSystemSecurity(boolean system) {
        return binder -> binder.bind(Boolean.TYPE).annotatedWith(UsingSystemSecurity.class).toInstance((Object)system);
    }
}

