/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.orc.OrcWriteValidation;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public final class IcebergSessionProperties
implements SessionPropertiesProvider {
    public static final String SPLIT_SIZE = "experimental_split_size";
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String USE_FILE_SIZE_FROM_METADATA = "use_file_size_from_metadata";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_NESTED_LAZY_ENABLED = "orc_nested_lazy_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_WRITER_VALIDATE_PERCENTAGE = "orc_writer_validate_percentage";
    private static final String ORC_WRITER_VALIDATE_MODE = "orc_writer_validate_mode";
    private static final String ORC_WRITER_MIN_STRIPE_SIZE = "orc_writer_min_stripe_size";
    private static final String ORC_WRITER_MAX_STRIPE_SIZE = "orc_writer_max_stripe_size";
    private static final String ORC_WRITER_MAX_STRIPE_ROWS = "orc_writer_max_stripe_rows";
    private static final String ORC_WRITER_MAX_ROW_GROUP_ROWS = "orc_writer_max_row_group_rows";
    private static final String ORC_WRITER_MAX_DICTIONARY_MEMORY = "orc_writer_max_dictionary_memory";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_USE_BLOOM_FILTER = "parquet_use_bloom_filter";
    private static final String PARQUET_MAX_READ_BLOCK_ROW_COUNT = "parquet_max_read_block_row_count";
    private static final String PARQUET_SMALL_FILE_THRESHOLD = "parquet_small_file_threshold";
    private static final String PARQUET_IGNORE_STATISTICS = "parquet_ignore_statistics";
    private static final String PARQUET_VECTORIZED_DECODING_ENABLED = "parquet_vectorized_decoding_enabled";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String PARQUET_WRITER_PAGE_VALUE_COUNT = "parquet_writer_page_value_count";
    private static final String PARQUET_WRITER_BATCH_SIZE = "parquet_writer_batch_size";
    public static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    public static final String EXTENDED_STATISTICS_ENABLED = "extended_statistics_enabled";
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    private static final String TARGET_MAX_FILE_SIZE = "target_max_file_size";
    private static final String IDLE_WRITER_MIN_FILE_SIZE = "idle_writer_min_file_size";
    public static final String COLLECT_EXTENDED_STATISTICS_ON_WRITE = "collect_extended_statistics_on_write";
    private static final String HIVE_CATALOG_NAME = "hive_catalog_name";
    private static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    public static final String EXPIRE_SNAPSHOTS_MIN_RETENTION = "expire_snapshots_min_retention";
    public static final String REMOVE_ORPHAN_FILES_MIN_RETENTION = "remove_orphan_files_min_retention";
    private static final String MERGE_MANIFESTS_ON_WRITE = "merge_manifests_on_write";
    private static final String SORTED_WRITING_ENABLED = "sorted_writing_enabled";
    private static final String QUERY_PARTITION_FILTER_REQUIRED = "query_partition_filter_required";
    private static final String QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS = "query_partition_filter_required_schemas";
    private static final String INCREMENTAL_REFRESH_ENABLED = "incremental_refresh_enabled";
    public static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    public static final String FILE_BASED_CONFLICT_DETECTION_ENABLED = "file_based_conflict_detection_enabled";
    private static final String MAX_PARTITIONS_PER_WRITER = "max_partitions_per_writer";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public IcebergSessionProperties(IcebergConfig icebergConfig, OrcReaderConfig orcReaderConfig, OrcWriterConfig orcWriterConfig, ParquetReaderConfig parquetReaderConfig, ParquetWriterConfig parquetWriterConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadataUtil.dataSizeProperty((String)SPLIT_SIZE, (String)"Target split size", null, (boolean)true)).add((Object)PropertyMetadata.enumProperty((String)COMPRESSION_CODEC, (String)"Compression codec to use when writing files", HiveCompressionOption.class, (Enum)icebergConfig.getCompressionCodec(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)USE_FILE_SIZE_FROM_METADATA, (String)"Use file size stored in Iceberg metadata", (Boolean)icebergConfig.isUseFileSizeFromMetadata(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)orcReaderConfig.isBloomFiltersEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_MERGE_DISTANCE, (String)"ORC: Maximum size of gap between two reads to merge into a single read", (DataSize)orcReaderConfig.getMaxMergeDistance(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_BUFFER_SIZE, (String)"ORC: Maximum size of a single read", (DataSize)orcReaderConfig.getMaxBufferSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_STREAM_BUFFER_SIZE, (String)"ORC: Size of buffer for streaming reads", (DataSize)orcReaderConfig.getStreamBufferSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_TINY_STRIPE_THRESHOLD, (String)"ORC: Threshold below which an ORC stripe or file will read in its entirety", (DataSize)orcReaderConfig.getTinyStripeThreshold(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_READ_BLOCK_SIZE, (String)"ORC: Soft max size of Trino blocks produced by ORC reader", (DataSize)orcReaderConfig.getMaxBlockSize(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)orcReaderConfig.isLazyReadSmallRanges(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_NESTED_LAZY_ENABLED, (String)"Experimental: ORC: Lazily read nested data", (Boolean)orcReaderConfig.isNestedLazy(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_STRING_STATISTICS_LIMIT, (String)"ORC: Maximum size of string statistics; drop if exceeding", (DataSize)orcWriterConfig.getStringStatisticsLimit(), (boolean)false)).add((Object)PropertyMetadata.doubleProperty((String)ORC_WRITER_VALIDATE_PERCENTAGE, (String)"ORC: Percentage of written files to validate by re-reading them", (Double)orcWriterConfig.getValidationPercentage(), doubleValue -> {
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
        }, (boolean)false)).add((Object)PropertyMetadata.enumProperty((String)ORC_WRITER_VALIDATE_MODE, (String)"ORC: Level of detail in ORC validation", OrcWriteValidation.OrcWriteValidationMode.class, (Enum)orcWriterConfig.getValidationMode(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MIN_STRIPE_SIZE, (String)"ORC: Min stripe size", (DataSize)orcWriterConfig.getStripeMinSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MAX_STRIPE_SIZE, (String)"ORC: Max stripe size", (DataSize)orcWriterConfig.getStripeMaxSize(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)ORC_WRITER_MAX_STRIPE_ROWS, (String)"ORC: Max stripe row count", (Integer)orcWriterConfig.getStripeMaxRowCount(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)ORC_WRITER_MAX_ROW_GROUP_ROWS, (String)"ORC: Max number of rows in a row group", (Integer)orcWriterConfig.getRowGroupMaxRowCount(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MAX_DICTIONARY_MEMORY, (String)"ORC: Max dictionary memory", (DataSize)orcWriterConfig.getDictionaryMaxMemory(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)parquetReaderConfig.getMaxReadBlockSize(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)PARQUET_USE_BLOOM_FILTER, (String)"Use Parquet Bloom filters", (Boolean)parquetReaderConfig.isUseBloomFilter(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)PARQUET_MAX_READ_BLOCK_ROW_COUNT, (String)"Parquet: Maximum number of rows read in a batch", (Integer)parquetReaderConfig.getMaxReadBlockRowCount(), value -> {
            if (value < 128 || value > 65536) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 128 and 65536: %s", PARQUET_MAX_READ_BLOCK_ROW_COUNT, value));
            }
        }, (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_SMALL_FILE_THRESHOLD, (String)"Parquet: Size below which a parquet file will be read entirely", (DataSize)parquetReaderConfig.getSmallFileThreshold(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_SMALL_FILE_THRESHOLD, (DataSize)value, (DataSize)DataSize.valueOf((String)"15MB")), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)PARQUET_IGNORE_STATISTICS, (String)"Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics", (Boolean)parquetReaderConfig.isIgnoreStatistics(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)PARQUET_VECTORIZED_DECODING_ENABLED, (String)"Enable using Java Vector API for faster decoding of parquet files", (Boolean)parquetReaderConfig.isVectorizedDecodingEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetWriterConfig.getBlockSize(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_BLOCK_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"2GB")), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetWriterConfig.getPageSize(), value -> {
            PropertyMetadataUtil.validateMinDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8kB"));
            PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8MB"));
        }, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)PARQUET_WRITER_PAGE_VALUE_COUNT, (String)"Parquet: Writer page row count", (Integer)parquetWriterConfig.getPageValueCount(), value -> {
            if (value < 1000 || value > 200000) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between %s and %s: %s", PARQUET_WRITER_PAGE_VALUE_COUNT, 1000, 200000, value));
            }
        }, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)PARQUET_WRITER_BATCH_SIZE, (String)"Parquet: Maximum number of rows passed to the writer in each batch", (Integer)parquetWriterConfig.getBatchSize(), (boolean)false)).add((Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters during split generation", (Duration)icebergConfig.getDynamicFilteringWaitTimeout(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)STATISTICS_ENABLED, (String)"Expose table statistics", (Boolean)icebergConfig.isTableStatisticsEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)EXTENDED_STATISTICS_ENABLED, (String)"Enable collection (ANALYZE) and use of extended statistics.", (Boolean)icebergConfig.isExtendedStatisticsEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Read only required fields from a row type", (Boolean)icebergConfig.isProjectionPushdownEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)TARGET_MAX_FILE_SIZE, (String)"Target maximum size of written files; the actual size may be larger", (DataSize)icebergConfig.getTargetMaxFileSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)IDLE_WRITER_MIN_FILE_SIZE, (String)"Minimum data written by a single partition writer before it can be consider as 'idle' and could be closed by the engine", (DataSize)icebergConfig.getIdleWriterMinFileSize(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)COLLECT_EXTENDED_STATISTICS_ON_WRITE, (String)"Collect extended statistics during writes", (Boolean)icebergConfig.isCollectExtendedStatisticsOnWrite(), (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)HIVE_CATALOG_NAME, (String)"Catalog to redirect to when a Hive table is referenced", (String)icebergConfig.getHiveCatalogName().orElse(null), (boolean)true)).add((Object)PropertyMetadata.doubleProperty((String)MINIMUM_ASSIGNED_SPLIT_WEIGHT, (String)"Minimum assigned split weight", (Double)icebergConfig.getMinimumAssignedSplitWeight(), (boolean)false)).add((Object)PropertyMetadataUtil.durationProperty((String)EXPIRE_SNAPSHOTS_MIN_RETENTION, (String)"Minimal retention period for expire_snapshot procedure", (Duration)icebergConfig.getExpireSnapshotsMinRetention(), (boolean)false)).add((Object)PropertyMetadataUtil.durationProperty((String)REMOVE_ORPHAN_FILES_MIN_RETENTION, (String)"Minimal retention period for remove_orphan_files procedure", (Duration)icebergConfig.getRemoveOrphanFilesMinRetention(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)MERGE_MANIFESTS_ON_WRITE, (String)"Compact manifest files when performing write operations", (Boolean)true, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)SORTED_WRITING_ENABLED, (String)"Enable sorted writing to tables with a specified sort order", (Boolean)icebergConfig.isSortedWritingEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)QUERY_PARTITION_FILTER_REQUIRED, (String)"Require filter on partition column", (Boolean)icebergConfig.isQueryPartitionFilterRequired(), (boolean)false)).add((Object)new PropertyMetadata(QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS, "List of schemas for which filter on partition column is enforced.", (Type)new ArrayType((Type)VarcharType.VARCHAR), Set.class, icebergConfig.getQueryPartitionFilterRequiredSchemas(), false, object -> (Set)((Collection)object).stream().map(String.class::cast).peek(property -> {
            if (Strings.isNullOrEmpty((String)property)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Invalid null or empty value in %s property", QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS));
            }
        }).map(schema -> schema.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()), value -> value)).add((Object)PropertyMetadata.booleanProperty((String)INCREMENTAL_REFRESH_ENABLED, (String)"Enable Incremental refresh for MVs backed by Iceberg tables, when possible.", (Boolean)icebergConfig.isIncrementalRefreshEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: use physical bucketing information to optimize queries", (Boolean)icebergConfig.isBucketExecutionEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)FILE_BASED_CONFLICT_DETECTION_ENABLED, (String)"Enable file-based conflict detection: take partition information from the actual written files as a source for the conflict detection system", (Boolean)icebergConfig.isFileBasedConflictDetectionEnabled(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)MAX_PARTITIONS_PER_WRITER, (String)"Maximum number of partitions per writer", (Integer)icebergConfig.getMaxPartitionsPerWriter(), value -> {
            if (value < 1 || value > icebergConfig.getMaxPartitionsPerWriter()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 1 and %s", MAX_PARTITIONS_PER_WRITER, icebergConfig.getMaxPartitionsPerWriter()));
            }
        }, (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcNestedLazy(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_NESTED_LAZY_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcWriterValidate(ConnectorSession session) {
        double percentage = (Double)session.getProperty(ORC_WRITER_VALIDATE_PERCENTAGE, Double.class);
        if (percentage == 0.0) {
            return false;
        }
        Preconditions.checkArgument((percentage > 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidateMode(ConnectorSession session) {
        return (OrcWriteValidation.OrcWriteValidationMode)session.getProperty(ORC_WRITER_VALIDATE_MODE, OrcWriteValidation.OrcWriteValidationMode.class);
    }

    public static DataSize getOrcWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static int getOrcWriterMaxRowGroupRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_WRITER_MAX_ROW_GROUP_ROWS, Integer.class);
    }

    public static DataSize getOrcWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static Optional<DataSize> getSplitSize(ConnectorSession session) {
        return Optional.ofNullable((DataSize)session.getProperty(SPLIT_SIZE, DataSize.class));
    }

    public static HiveCompressionOption getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionOption)session.getProperty(COMPRESSION_CODEC, HiveCompressionOption.class);
    }

    public static boolean isUseFileSizeFromMetadata(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_FILE_SIZE_FROM_METADATA, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static int getParquetMaxReadBlockRowCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_MAX_READ_BLOCK_ROW_COUNT, Integer.class);
    }

    public static DataSize getParquetSmallFileThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_SMALL_FILE_THRESHOLD, DataSize.class);
    }

    public static boolean isParquetIgnoreStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_IGNORE_STATISTICS, Boolean.class);
    }

    public static boolean isParquetVectorizedDecodingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_VECTORIZED_DECODING_ENABLED, Boolean.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static int getParquetWriterPageValueCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_WRITER_PAGE_VALUE_COUNT, Integer.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static int getParquetWriterBatchSize(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_WRITER_BATCH_SIZE, Integer.class);
    }

    public static boolean useParquetBloomFilter(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_BLOOM_FILTER, Boolean.class);
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static boolean isExtendedStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(EXTENDED_STATISTICS_ENABLED, Boolean.class);
    }

    public static boolean isCollectExtendedStatisticsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(COLLECT_EXTENDED_STATISTICS_ON_WRITE, Boolean.class);
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static long getTargetMaxFileSize(ConnectorSession session) {
        return ((DataSize)session.getProperty(TARGET_MAX_FILE_SIZE, DataSize.class)).toBytes();
    }

    public static long getIdleWriterMinFileSize(ConnectorSession session) {
        return ((DataSize)session.getProperty(IDLE_WRITER_MIN_FILE_SIZE, DataSize.class)).toBytes();
    }

    public static Optional<String> getHiveCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(HIVE_CATALOG_NAME, String.class));
    }

    public static Duration getExpireSnapshotMinRetention(ConnectorSession session) {
        return (Duration)session.getProperty(EXPIRE_SNAPSHOTS_MIN_RETENTION, Duration.class);
    }

    public static Duration getRemoveOrphanFilesMinRetention(ConnectorSession session) {
        return (Duration)session.getProperty(REMOVE_ORPHAN_FILES_MIN_RETENTION, Duration.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }

    public static boolean isMergeManifestsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(MERGE_MANIFESTS_ON_WRITE, Boolean.class);
    }

    public static boolean isSortedWritingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITING_ENABLED, Boolean.class);
    }

    public static boolean isQueryPartitionFilterRequired(ConnectorSession session) {
        return (Boolean)session.getProperty(QUERY_PARTITION_FILTER_REQUIRED, Boolean.class);
    }

    public static Set<String> getQueryPartitionFilterRequiredSchemas(ConnectorSession session) {
        Set queryPartitionFilterRequiredSchemas = (Set)session.getProperty(QUERY_PARTITION_FILTER_REQUIRED_SCHEMAS, Set.class);
        Objects.requireNonNull(queryPartitionFilterRequiredSchemas, "queryPartitionFilterRequiredSchemas is null");
        return queryPartitionFilterRequiredSchemas;
    }

    public static boolean isIncrementalRefreshEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(INCREMENTAL_REFRESH_ENABLED, Boolean.class);
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isFileBasedConflictDetectionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(FILE_BASED_CONFLICT_DETECTION_ENABLED, Boolean.class);
    }

    public static int maxPartitionsPerWriter(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_PARTITIONS_PER_WRITER, Integer.class);
    }
}

