/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotCall;
import io.airlift.units.DataSize;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergTablePartitioning;
import io.trino.plugin.iceberg.TableType;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public class IcebergTableHandle
implements ConnectorTableHandle {
    private final CatalogHandle catalog;
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;
    private final String tableSchemaJson;
    private final Optional<String> partitionSpecJson;
    private final int formatVersion;
    private final String tableLocation;
    private final Map<String, String> storageProperties;
    private final TupleDomain<IcebergColumnHandle> unenforcedPredicate;
    private final TupleDomain<IcebergColumnHandle> enforcedPredicate;
    private final Set<IcebergColumnHandle> constraintColumns;
    private final OptionalLong limit;
    private final Set<IcebergColumnHandle> projectedColumns;
    private final Optional<String> nameMappingJson;
    private final Optional<IcebergTablePartitioning> tablePartitioning;
    private final boolean recordScannedFiles;
    private final Optional<DataSize> maxScannedFileSize;
    private final Optional<Boolean> forAnalyze;

    @JsonCreator
    @DoNotCall
    public static IcebergTableHandle fromJsonForDeserializationOnly(@JsonProperty(value="catalog") CatalogHandle catalog, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="tableSchemaJson") String tableSchemaJson, @JsonProperty(value="partitionSpecJson") Optional<String> partitionSpecJson, @JsonProperty(value="formatVersion") int formatVersion, @JsonProperty(value="unenforcedPredicate") TupleDomain<IcebergColumnHandle> unenforcedPredicate, @JsonProperty(value="enforcedPredicate") TupleDomain<IcebergColumnHandle> enforcedPredicate, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="projectedColumns") Set<IcebergColumnHandle> projectedColumns, @JsonProperty(value="nameMappingJson") Optional<String> nameMappingJson, @JsonProperty(value="tableLocation") String tableLocation, @JsonProperty(value="storageProperties") Map<String, String> storageProperties) {
        return new IcebergTableHandle(catalog, schemaName, tableName, tableType, snapshotId, tableSchemaJson, partitionSpecJson, formatVersion, unenforcedPredicate, enforcedPredicate, limit, projectedColumns, nameMappingJson, tableLocation, storageProperties, Optional.empty(), false, Optional.empty(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.empty());
    }

    public IcebergTableHandle(CatalogHandle catalog, String schemaName, String tableName, TableType tableType, Optional<Long> snapshotId, String tableSchemaJson, Optional<String> partitionSpecJson, int formatVersion, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> enforcedPredicate, OptionalLong limit, Set<IcebergColumnHandle> projectedColumns, Optional<String> nameMappingJson, String tableLocation, Map<String, String> storageProperties, Optional<IcebergTablePartitioning> tablePartitioning, boolean recordScannedFiles, Optional<DataSize> maxScannedFileSize, Set<IcebergColumnHandle> constraintColumns, Optional<Boolean> forAnalyze) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.tableSchemaJson = Objects.requireNonNull(tableSchemaJson, "schemaJson is null");
        this.partitionSpecJson = Objects.requireNonNull(partitionSpecJson, "partitionSpecJson is null");
        this.formatVersion = formatVersion;
        this.unenforcedPredicate = Objects.requireNonNull(unenforcedPredicate, "unenforcedPredicate is null");
        this.enforcedPredicate = Objects.requireNonNull(enforcedPredicate, "enforcedPredicate is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        this.nameMappingJson = Objects.requireNonNull(nameMappingJson, "nameMappingJson is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.storageProperties = ImmutableMap.copyOf(Objects.requireNonNull(storageProperties, "storageProperties is null"));
        this.tablePartitioning = Objects.requireNonNull(tablePartitioning, "tablePartitioning is null");
        this.recordScannedFiles = recordScannedFiles;
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
        this.constraintColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(constraintColumns, "constraintColumns is null"));
        this.forAnalyze = Objects.requireNonNull(forAnalyze, "forAnalyze is null");
    }

    @JsonProperty
    public CatalogHandle getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public String getTableSchemaJson() {
        return this.tableSchemaJson;
    }

    @JsonProperty
    public Optional<String> getPartitionSpecJson() {
        return this.partitionSpecJson;
    }

    @JsonProperty
    public int getFormatVersion() {
        return this.formatVersion;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getUnenforcedPredicate() {
        return this.unenforcedPredicate;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getEnforcedPredicate() {
        return this.enforcedPredicate;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public Set<IcebergColumnHandle> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public Optional<String> getNameMappingJson() {
        return this.nameMappingJson;
    }

    @JsonProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    @JsonProperty
    public Map<String, String> getStorageProperties() {
        return this.storageProperties;
    }

    @JsonIgnore
    public Optional<IcebergTablePartitioning> getTablePartitioning() {
        return this.tablePartitioning;
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public Optional<DataSize> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    @JsonIgnore
    public Set<IcebergColumnHandle> getConstraintColumns() {
        return this.constraintColumns;
    }

    @JsonIgnore
    public Optional<Boolean> getForAnalyze() {
        return this.forAnalyze;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public SchemaTableName getSchemaTableNameWithType() {
        return new SchemaTableName(this.schemaName, this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ROOT));
    }

    public IcebergTableHandle withProjectedColumns(Set<IcebergColumnHandle> projectedColumns) {
        return new IcebergTableHandle(this.catalog, this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.limit, projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.tablePartitioning, this.recordScannedFiles, this.maxScannedFileSize, this.constraintColumns, this.forAnalyze);
    }

    public IcebergTableHandle forAnalyze() {
        return new IcebergTableHandle(this.catalog, this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.limit, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.tablePartitioning, this.recordScannedFiles, this.maxScannedFileSize, this.constraintColumns, Optional.of(true));
    }

    public IcebergTableHandle forOptimize(boolean recordScannedFiles, DataSize maxScannedFileSize) {
        return new IcebergTableHandle(this.catalog, this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.limit, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.tablePartitioning, recordScannedFiles, Optional.of(maxScannedFileSize), this.constraintColumns, this.forAnalyze);
    }

    public IcebergTableHandle withTablePartitioning(Optional<IcebergTablePartitioning> requiredTablePartitioning) {
        return new IcebergTableHandle(this.catalog, this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.limit, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, requiredTablePartitioning, this.recordScannedFiles, this.maxScannedFileSize, this.constraintColumns, this.forAnalyze);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)o;
        return this.recordScannedFiles == that.recordScannedFiles && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.tableSchemaJson, that.tableSchemaJson) && Objects.equals(this.partitionSpecJson, that.partitionSpecJson) && this.formatVersion == that.formatVersion && Objects.equals(this.unenforcedPredicate, that.unenforcedPredicate) && Objects.equals(this.enforcedPredicate, that.enforcedPredicate) && Objects.equals(this.limit, that.limit) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.nameMappingJson, that.nameMappingJson) && Objects.equals(this.tableLocation, that.tableLocation) && Objects.equals(this.storageProperties, that.storageProperties) && Objects.equals(this.maxScannedFileSize, that.maxScannedFileSize) && Objects.equals(this.constraintColumns, that.constraintColumns) && Objects.equals(this.forAnalyze, that.forAnalyze);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalog, this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.limit, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.recordScannedFiles, this.maxScannedFileSize, this.constraintColumns, this.forAnalyze});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getSchemaTableNameWithType().toString());
        this.snapshotId.ifPresent(snapshotId -> builder.append("@").append(snapshotId));
        if (this.enforcedPredicate.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.enforcedPredicate.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.enforcedPredicate.getDomains().orElseThrow()).keySet().stream().map(IcebergColumnHandle::getQualifiedName).collect(Collectors.joining(", ", "[", "]")));
        }
        this.limit.ifPresent(limit -> builder.append(" LIMIT ").append(limit));
        return builder.toString();
    }
}

