/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.TableProperties;

public class IcebergTableProperties {
    public static final String FILE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONING_PROPERTY = "partitioning";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    public static final String LOCATION_PROPERTY = "location";
    public static final String FORMAT_VERSION_PROPERTY = "format_version";
    public static final String MAX_COMMIT_RETRY = "max_commit_retry";
    public static final String ORC_BLOOM_FILTER_COLUMNS_PROPERTY = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP_PROPERTY = "orc_bloom_filter_fpp";
    public static final String PARQUET_BLOOM_FILTER_COLUMNS_PROPERTY = "parquet_bloom_filter_columns";
    public static final String OBJECT_STORE_LAYOUT_ENABLED_PROPERTY = "object_store_layout_enabled";
    public static final String DATA_LOCATION_PROPERTY = "data_location";
    public static final String EXTRA_PROPERTIES_PROPERTY = "extra_properties";
    public static final Set<String> SUPPORTED_PROPERTIES = ImmutableSet.builder().add((Object)"format").add((Object)"partitioning").add((Object)"sorted_by").add((Object)"location").add((Object)"format_version").add((Object)"max_commit_retry").add((Object)"orc_bloom_filter_columns").add((Object)"orc_bloom_filter_fpp").add((Object)"object_store_layout_enabled").add((Object)"data_location").add((Object)"extra_properties").add((Object)"parquet_bloom_filter_columns").build();
    public static final Set<String> PROTECTED_ICEBERG_NATIVE_PROPERTIES = ImmutableSet.builder().addAll((Iterable)TableProperties.RESERVED_PROPERTIES).add((Object)"write.orc.bloom.filter.columns").add((Object)"write.orc.bloom.filter.fpp").add((Object)"write.format.default").add((Object)"format-version").build();
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public IcebergTableProperties(IcebergConfig icebergConfig, OrcWriterConfig orcWriterConfig, TypeManager typeManager) {
        this.tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)FILE_FORMAT_PROPERTY, (String)"File format for the table", IcebergFileFormat.class, (Enum)icebergConfig.getFileFormat(), (boolean)false)).add((Object)new PropertyMetadata(PARTITIONING_PROPERTY, "Partition transforms", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value)).add((Object)new PropertyMetadata(SORTED_BY_PROPERTY, "Sorted columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value)).add((Object)PropertyMetadata.stringProperty((String)LOCATION_PROPERTY, (String)"File system location URI for the table", null, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)FORMAT_VERSION_PROPERTY, (String)"Iceberg table format version", (Integer)icebergConfig.getFormatVersion(), IcebergTableProperties::validateFormatVersion, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)MAX_COMMIT_RETRY, (String)"Number of times to retry a commit before failing", (Integer)icebergConfig.getMaxCommitRetry(), value -> {
            if (value < 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "max_commit_retry must be greater than or equal to 0");
            }
        }, (boolean)false)).add((Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS_PROPERTY, "ORC Bloom filter index columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP_PROPERTY, (String)"ORC Bloom filter false positive probability", (Double)orcWriterConfig.getDefaultBloomFilterFpp(), IcebergTableProperties::validateOrcBloomFilterFpp, (boolean)false)).add((Object)new PropertyMetadata(PARQUET_BLOOM_FILTER_COLUMNS_PROPERTY, "Parquet Bloom filter index columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)new PropertyMetadata(EXTRA_PROPERTIES_PROPERTY, "Extra table properties", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, typeManager.getTypeOperators()), Map.class, null, true, value -> {
            Map extraProperties = (Map)value;
            if (extraProperties.containsValue(null)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Extra table property value cannot be null '%s'", extraProperties));
            }
            if (extraProperties.containsKey(null)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Extra table property key cannot be null '%s'", extraProperties));
            }
            return (Map)extraProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ENGLISH), Map.Entry::getValue));
        }, value -> value)).add((Object)PropertyMetadata.booleanProperty((String)OBJECT_STORE_LAYOUT_ENABLED_PROPERTY, (String)"Set to true to enable Iceberg object store file layout", (Boolean)icebergConfig.isObjectStoreLayoutEnabled(), (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)DATA_LOCATION_PROPERTY, (String)"File system location URI for the table's data files", null, (boolean)false)).build();
        Preconditions.checkState((boolean)SUPPORTED_PROPERTIES.containsAll((Collection)this.tableProperties.stream().map(PropertyMetadata::getName).collect(ImmutableList.toImmutableList())), (String)"%s does not contain all supported properties", SUPPORTED_PROPERTIES);
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static IcebergFileFormat getFileFormat(Map<String, Object> tableProperties) {
        return (IcebergFileFormat)((Object)tableProperties.get(FILE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitioning(Map<String, Object> tableProperties) {
        List partitioning = (List)tableProperties.get(PARTITIONING_PROPERTY);
        return partitioning == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitioning);
    }

    public static List<String> getSortOrder(Map<String, Object> tableProperties) {
        List sortedBy = (List)tableProperties.get(SORTED_BY_PROPERTY);
        return sortedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)sortedBy);
    }

    public static Optional<String> getTableLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(LOCATION_PROPERTY));
    }

    public static int getFormatVersion(Map<String, Object> tableProperties) {
        return (Integer)tableProperties.get(FORMAT_VERSION_PROPERTY);
    }

    private static void validateFormatVersion(int version) {
        if (version < 1 || version > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("format_version must be between %d and %d", 1, 2));
        }
    }

    public static int getMaxCommitRetry(Map<String, Object> tableProperties) {
        return (Integer)tableProperties.getOrDefault(MAX_COMMIT_RETRY, 4);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        List orcBloomFilterColumns = (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS_PROPERTY);
        return orcBloomFilterColumns == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)orcBloomFilterColumns);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP_PROPERTY);
    }

    private static void validateOrcBloomFilterFpp(double fpp) {
        if (fpp < 0.0 || fpp > 1.0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Bloom filter fpp value must be between 0.0 and 1.0");
        }
    }

    public static List<String> getParquetBloomFilterColumns(Map<String, Object> tableProperties) {
        List parquetBloomFilterColumns = (List)tableProperties.get(PARQUET_BLOOM_FILTER_COLUMNS_PROPERTY);
        return parquetBloomFilterColumns == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)parquetBloomFilterColumns);
    }

    public static boolean getObjectStoreLayoutEnabled(Map<String, Object> tableProperties) {
        return (Boolean)tableProperties.getOrDefault(OBJECT_STORE_LAYOUT_ENABLED_PROPERTY, false);
    }

    public static Optional<String> getDataLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(DATA_LOCATION_PROPERTY));
    }

    public static Optional<Map<String, String>> getExtraProperties(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Map)tableProperties.get(EXTRA_PROPERTIES_PROPERTY));
    }
}

