/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.BaseSystemTable;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Table;

public class MetadataLogEntriesTable
extends BaseSystemTable {
    private static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    private static final String FILE_COLUMN_NAME = "file";
    private static final String LATEST_SNAPSHOT_ID_COLUMN_NAME = "latest_snapshot_id";
    private static final String LATEST_SCHEMA_ID_COLUMN_NAME = "latest_schema_id";
    private static final String LATEST_SEQUENCE_NUMBER_COLUMN_NAME = "latest_sequence_number";

    public MetadataLogEntriesTable(SchemaTableName tableName, Table icebergTable, ExecutorService executor) {
        super(Objects.requireNonNull(icebergTable, "icebergTable is null"), MetadataLogEntriesTable.createConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null")), MetadataTableType.METADATA_LOG_ENTRIES, executor);
    }

    private static ConnectorTableMetadata createConnectorTableMetadata(SchemaTableName tableName) {
        return new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata(TIMESTAMP_COLUMN_NAME, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata(FILE_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(LATEST_SNAPSHOT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(LATEST_SCHEMA_ID_COLUMN_NAME, (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata(LATEST_SEQUENCE_NUMBER_COLUMN_NAME, (Type)BigintType.BIGINT)).build());
    }

    @Override
    protected void addRow(PageListBuilder pagesBuilder, BaseSystemTable.Row row, TimeZoneKey timeZoneKey) {
        pagesBuilder.beginRow();
        pagesBuilder.appendTimestampTzMillis(row.get(TIMESTAMP_COLUMN_NAME, Long.class) / 1000L, timeZoneKey);
        pagesBuilder.appendVarchar(row.get(FILE_COLUMN_NAME, String.class));
        pagesBuilder.appendBigint(row.get(LATEST_SNAPSHOT_ID_COLUMN_NAME, Long.class));
        pagesBuilder.appendInteger(row.get(LATEST_SCHEMA_ID_COLUMN_NAME, Integer.class));
        pagesBuilder.appendBigint(row.get(LATEST_SEQUENCE_NUMBER_COLUMN_NAME, Long.class));
        pagesBuilder.endRow();
    }
}

