/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.SortFieldUtils;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.SortOrder;

public class PropertiesTable
implements SystemTable {
    private static final Set<String> RESERVED_PROPERTIES = ImmutableSet.builder().add((Object)"provider").add((Object)"format").add((Object)"current-snapshot-id").add((Object)"location").add((Object)"format-version").build();
    private final ConnectorTableMetadata tableMetadata;
    private final BaseTable icebergTable;

    public PropertiesTable(SchemaTableName tableName, BaseTable icebergTable) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("key", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value", (Type)VarcharType.VARCHAR)).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(PropertiesTable.buildPages(this.tableMetadata, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, BaseTable icebergTable) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        String currentSnapshotId = icebergTable.currentSnapshot() != null ? String.valueOf(icebergTable.currentSnapshot().snapshotId()) : "none";
        String fileFormat = icebergTable.properties().getOrDefault("write.format.default", "parquet");
        properties.put((Object)"format", (Object)("iceberg/" + fileFormat));
        properties.put((Object)"provider", (Object)"iceberg");
        properties.put((Object)"current-snapshot-id", (Object)currentSnapshotId);
        properties.put((Object)"location", (Object)icebergTable.location());
        properties.put((Object)"format-version", (Object)String.valueOf(icebergTable.operations().current().formatVersion()));
        SortOrder sortOrder = icebergTable.sortOrder();
        if (!sortOrder.isUnsorted() && sortOrder.fields().stream().allMatch(sortField -> sortField.transform().isIdentity())) {
            List<String> sortColumnNames = SortFieldUtils.toSortFields(sortOrder);
            properties.put((Object)"sort-order", (Object)String.join((CharSequence)", ", sortColumnNames));
        }
        icebergTable.properties().entrySet().stream().filter(entry -> !RESERVED_PROPERTIES.contains(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)properties).put(arg_0));
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        properties.buildOrThrow().entrySet().forEach(prop -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar((String)prop.getKey());
            pagesBuilder.appendVarchar((String)prop.getValue());
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }
}

