/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderBuilder;
import org.apache.iceberg.types.Types;

public final class SortFieldUtils {
    private static final Pattern PATTERN = Pattern.compile("\\s*(?<identifier>([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\"))(?i:\\s+(?<ordering>ASC|DESC))?(?i:\\s+NULLS\\s+(?<nullOrder>FIRST|LAST))?\\s*");

    private SortFieldUtils() {
    }

    public static SortOrder parseSortFields(Schema schema, List<String> fields) {
        SortOrder sortOrder;
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        SortFieldUtils.parseSortFields(builder, fields);
        try {
            sortOrder = builder.build();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Invalid sorted_by definition", (Throwable)e);
        }
        Set baseColumnFieldIds = (Set)schema.columns().stream().map(Types.NestedField::fieldId).collect(ImmutableSet.toImmutableSet());
        for (SortField field : sortOrder.fields()) {
            if (baseColumnFieldIds.contains(field.sourceId())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, "Column not found: " + schema.findColumnName(field.sourceId()));
        }
        return sortOrder;
    }

    public static void parseSortFields(SortOrderBuilder<?> sortOrderBuilder, List<String> fields) {
        fields.forEach(field -> SortFieldUtils.parseSortField(sortOrderBuilder, field));
    }

    private static void parseSortField(SortOrderBuilder<?> builder, String field) {
        Matcher matcher = PATTERN.matcher(field);
        if (!matcher.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Unable to parse sort field: [%s]".formatted(field));
        }
        String columnName = PartitionFields.fromIdentifierToColumn(matcher.group("identifier"));
        boolean ascending = switch (((String)MoreObjects.firstNonNull((Object)matcher.group("ordering"), (Object)"ASC")).toUpperCase(Locale.ENGLISH)) {
            case "ASC" -> true;
            case "DESC" -> false;
            default -> throw new IllegalStateException("Unexpected ordering value");
        };
        String nullOrderDefault = ascending ? "FIRST" : "LAST";
        NullOrder nullOrder = switch (((String)MoreObjects.firstNonNull((Object)matcher.group("nullOrder"), (Object)nullOrderDefault)).toUpperCase(Locale.ENGLISH)) {
            case "FIRST" -> NullOrder.NULLS_FIRST;
            case "LAST" -> NullOrder.NULLS_LAST;
            default -> throw new IllegalStateException("Unexpected null ordering value");
        };
        if (ascending) {
            builder.asc(columnName, nullOrder);
        } else {
            builder.desc(columnName, nullOrder);
        }
    }

    public static List<String> toSortFields(SortOrder spec) {
        return (List)spec.fields().stream().map(field -> SortFieldUtils.toSortField(spec, field)).collect(ImmutableList.toImmutableList());
    }

    private static String toSortField(SortOrder spec, SortField field) {
        Verify.verify((boolean)field.transform().isIdentity(), (String)"Iceberg sort transforms are not supported", (Object[])new Object[0]);
        String name = PartitionFields.quotedName(spec.schema().findColumnName(field.sourceId()));
        return String.format("%s %s %s", name, field.direction(), field.nullOrder());
    }
}

