/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.spi.connector.SortOrder;
import java.util.Objects;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;

public record TrinoSortField(int sourceColumnId, SortOrder sortOrder) {
    public TrinoSortField {
        Objects.requireNonNull(sortOrder, "sortOrder is null");
    }

    public static TrinoSortField fromIceberg(SortField sortField) {
        SortOrder sortOrder = switch (sortField.direction()) {
            default -> throw new MatchException(null, null);
            case SortDirection.ASC -> {
                switch (sortField.nullOrder()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NULLS_FIRST: {
                        yield SortOrder.ASC_NULLS_FIRST;
                    }
                    case NULLS_LAST: 
                }
                yield SortOrder.ASC_NULLS_LAST;
            }
            case SortDirection.DESC -> {
                switch (sortField.nullOrder()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NULLS_FIRST: {
                        yield SortOrder.DESC_NULLS_FIRST;
                    }
                    case NULLS_LAST: 
                }
                yield SortOrder.DESC_NULLS_LAST;
            }
        };
        return new TrinoSortField(sortField.sourceId(), sortOrder);
    }
}

