/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class TypeConverter {
    private TypeConverter() {
    }

    public static io.trino.spi.type.Type toTrinoType(Type type, TypeManager typeManager) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: 
            case FIXED: {
                return VarbinaryType.VARBINARY;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale());
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case TIME: {
                return TimeType.TIME_MICROS;
            }
            case TIMESTAMP: {
                return ((Types.TimestampType)type).shouldAdjustToUTC() ? TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS : TimestampType.TIMESTAMP_MICROS;
            }
            case TIMESTAMP_NANO: {
                break;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case UUID: {
                return UuidType.UUID;
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)type;
                return new ArrayType(TypeConverter.toTrinoType(listType.elementType(), typeManager));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                TypeSignature keyType = TypeConverter.toTrinoType(mapType.keyType(), typeManager).getTypeSignature();
                TypeSignature valueType = TypeConverter.toTrinoType(mapType.valueType(), typeManager).getTypeSignature();
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
            }
            case STRUCT: {
                List fields = ((Types.StructType)type).fields();
                return RowType.from((List)((List)fields.stream().map(field -> new RowType.Field(Optional.of(field.name()), TypeConverter.toTrinoType(field.type(), typeManager))).collect(ImmutableList.toImmutableList())));
            }
            case VARIANT: {
                break;
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert from Iceberg type '%s' (%s) to Trino type", type, type.typeId()));
    }

    public static Type toIcebergTypeForNewColumn(io.trino.spi.type.Type type, AtomicInteger nextFieldId) {
        return TypeConverter.toIcebergTypeInternal(type, Optional.empty(), Optional.of(nextFieldId));
    }

    public static Type toIcebergType(io.trino.spi.type.Type type, ColumnIdentity columnIdentity) {
        return TypeConverter.toIcebergTypeInternal(type, Optional.of(columnIdentity), Optional.empty());
    }

    private static Type toIcebergTypeInternal(io.trino.spi.type.Type type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        if (type instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (type instanceof IntegerType) {
            return Types.IntegerType.get();
        }
        if (type instanceof BigintType) {
            return Types.LongType.get();
        }
        if (type instanceof RealType) {
            return Types.FloatType.get();
        }
        if (type instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return TypeConverter.fromDecimal(decimalType);
        }
        if (type instanceof VarcharType) {
            return Types.StringType.get();
        }
        if (type instanceof VarbinaryType) {
            return Types.BinaryType.get();
        }
        if (type instanceof DateType) {
            return Types.DateType.get();
        }
        if (type.equals((Object)TimeType.TIME_MICROS)) {
            return Types.TimeType.get();
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
            return Types.TimestampType.withoutZone();
        }
        if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            return Types.TimestampType.withZone();
        }
        if (type.equals((Object)UuidType.UUID)) {
            return Types.UUIDType.get();
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return TypeConverter.fromRow(rowType, columnIdentity, nextFieldId);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return TypeConverter.fromArray(arrayType, columnIdentity, nextFieldId);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return TypeConverter.fromMap(mapType, columnIdentity, nextFieldId);
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Time precision (%s) not supported for Iceberg. Use \"time(6)\" instead.", timeType.getPrecision()));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Timestamp precision (%s) not supported for Iceberg. Use \"timestamp(6)\" instead.", timestampType.getPrecision()));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Timestamp precision (%s) not supported for Iceberg. Use \"timestamp(6) with time zone\" instead.", timestampWithTimeZoneType.getPrecision()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported for Iceberg: " + type.getDisplayName());
    }

    private static Type fromDecimal(DecimalType type) {
        return Types.DecimalType.of((int)type.getPrecision(), (int)type.getScale());
    }

    private static Type fromRow(RowType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        int i = 0;
        while (i < type.getFields().size()) {
            int fieldIndex = i++;
            Optional<ColumnIdentity> childColumnIdentity = columnIdentity.map(column -> column.getChildren().get(fieldIndex));
            int id = childColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
            RowType.Field field = (RowType.Field)type.getFields().get(fieldIndex);
            String name = (String)field.getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + type.getDisplayName()));
            if (!fieldNames.add(name.toLowerCase(Locale.ENGLISH))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, "Field name '%s' specified more than once".formatted(name.toLowerCase(Locale.ENGLISH)));
            }
            fields.add(Types.NestedField.optional((int)id, (String)name, (Type)TypeConverter.toIcebergTypeInternal(field.getType(), childColumnIdentity, nextFieldId)));
        }
        return Types.StructType.of(fields);
    }

    private static Type fromArray(ArrayType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        Optional<ColumnIdentity> childColumnIdentity = columnIdentity.map(identity -> (ColumnIdentity)Iterables.getOnlyElement(identity.getChildren()));
        int id = childColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        return Types.ListType.ofOptional((int)id, (Type)TypeConverter.toIcebergTypeInternal(type.getElementType(), childColumnIdentity, nextFieldId));
    }

    private static Type fromMap(MapType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        Optional<ColumnIdentity> keyColumnIdentity = columnIdentity.map(column -> column.getChildren().get(0));
        Optional<ColumnIdentity> valueColumnIdentity = columnIdentity.map(column -> column.getChildren().get(1));
        int keyId = keyColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        int valueId = valueColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)TypeConverter.toIcebergTypeInternal(type.getKeyType(), keyColumnIdentity, nextFieldId), (Type)TypeConverter.toIcebergTypeInternal(type.getValueType(), valueColumnIdentity, nextFieldId));
    }

    private static void checkExactlyOne(Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        if (columnIdentity.isPresent() && nextFieldId.isEmpty() || columnIdentity.isEmpty() && nextFieldId.isPresent()) {
            return;
        }
        throw new IllegalArgumentException("Either a column identity or nextFieldId is expected");
    }
}

