/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.trino.annotation.NotThreadSafe;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.Column;
import io.trino.metastore.HiveType;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergExceptions;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.util.HiveSchemaUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import jakarta.annotation.Nullable;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Function;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.LocationUtil;

@NotThreadSafe
public abstract class AbstractIcebergTableOperations
implements IcebergTableOperations {
    public static final StorageFormat ICEBERG_METASTORE_STORAGE_FORMAT = StorageFormat.create((String)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (String)"org.apache.hadoop.mapred.FileInputFormat", (String)"org.apache.hadoop.mapred.FileOutputFormat");
    protected final ConnectorSession session;
    protected final String database;
    protected final String tableName;
    protected final Optional<String> owner;
    protected final Optional<String> location;
    protected final FileIO fileIo;
    protected TableMetadata currentMetadata;
    protected String currentMetadataLocation;
    protected boolean shouldRefresh = true;
    protected OptionalInt version = OptionalInt.empty();

    protected AbstractIcebergTableOperations(FileIO fileIo, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        this.fileIo = Objects.requireNonNull(fileIo, "fileIo is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.tableName = Objects.requireNonNull(table, "table is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    @Override
    public void initializeFromMetadata(TableMetadata tableMetadata) {
        Preconditions.checkState((this.currentMetadata == null ? 1 : 0) != 0, (Object)"already initialized");
        this.currentMetadata = tableMetadata;
        this.currentMetadataLocation = tableMetadata.metadataFileLocation();
        this.shouldRefresh = false;
        this.version = OptionalInt.of(IcebergUtil.parseVersion(Location.of((String)this.currentMetadataLocation).fileName()));
    }

    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh(false);
        }
        return this.currentMetadata;
    }

    public TableMetadata refresh() {
        return this.refresh(true);
    }

    public TableMetadata refresh(boolean invalidateCaches) {
        if (this.location.isPresent()) {
            this.refreshFromMetadataLocation(null);
            return this.currentMetadata;
        }
        this.refreshFromMetadataLocation(IcebergUtil.fixBrokenMetadataLocation(this.getRefreshedLocation(invalidateCaches)));
        return this.currentMetadata;
    }

    public void commit(@Nullable TableMetadata base, TableMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        if (!Objects.equals(base, this.current())) {
            throw new CommitFailedException("Cannot commit: stale table metadata for %s", new Object[]{this.getSchemaTableName()});
        }
        if (Objects.equals(base, metadata)) {
            return;
        }
        if (IcebergTableName.isMaterializedViewStorage(this.tableName)) {
            this.commitMaterializedViewRefresh(base, metadata);
            return;
        }
        if (base == null) {
            if ("iceberg".equals(metadata.properties().get("provider"))) {
                this.version = OptionalInt.of(0);
                this.currentMetadataLocation = (String)metadata.properties().get("metadata_location");
                this.commitToExistingTable(base, metadata);
            } else {
                this.commitNewTable(metadata);
            }
        } else {
            this.commitToExistingTable(base, metadata);
            CatalogUtil.deleteRemovedMetadataFiles((FileIO)this.fileIo, (TableMetadata)base, (TableMetadata)metadata);
        }
        this.shouldRefresh = true;
    }

    protected abstract String getRefreshedLocation(boolean var1);

    protected abstract void commitNewTable(TableMetadata var1);

    protected abstract void commitToExistingTable(TableMetadata var1, TableMetadata var2);

    protected abstract void commitMaterializedViewRefresh(TableMetadata var1, TableMetadata var2);

    public FileIO io() {
        return this.fileIo;
    }

    public String metadataFileLocation(String filename) {
        String location;
        TableMetadata metadata = this.current();
        if (metadata != null) {
            String writeLocation = (String)metadata.properties().get("write.metadata.path");
            if (writeLocation != null) {
                return String.format("%s/%s", LocationUtil.stripTrailingSlash((String)writeLocation), filename);
            }
            location = metadata.location();
        } else {
            location = this.location.orElseThrow(() -> new IllegalStateException("Location not set"));
        }
        return String.format("%s/%s/%s", LocationUtil.stripTrailingSlash((String)location), "metadata", filename);
    }

    public LocationProvider locationProvider() {
        TableMetadata metadata = this.current();
        return IcebergUtil.getLocationProvider(this.getSchemaTableName(), metadata.location(), metadata.properties());
    }

    protected SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.database, this.tableName);
    }

    protected String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = AbstractIcebergTableOperations.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.fileIo.newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)newMetadataLocation);
        return newTableMetadataFilePath;
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        this.refreshFromMetadataLocation(newLocation, metadataLocation -> TableMetadataParser.read((FileIO)this.fileIo, (InputFile)this.fileIo.newInputFile(metadataLocation)));
    }

    protected void refreshFromMetadataLocation(String newLocation, Function<String, TableMetadata> metadataLoader) {
        TableMetadata newMetadata;
        if (Objects.equals(this.currentMetadataLocation, newLocation)) {
            this.shouldRefresh = false;
            return;
        }
        if (newLocation == null) {
            this.shouldRefresh = false;
            return;
        }
        try {
            newMetadata = (TableMetadata)Failsafe.with((Policy)RetryPolicy.builder().withMaxRetries(3).withBackoff(100L, 5000L, ChronoUnit.MILLIS, 4.0).withMaxDuration(Duration.ofMinutes(3L)).abortOn(throwable -> TrinoFileSystem.isUnrecoverableException((Throwable)throwable) || IcebergExceptions.isFatalException(throwable)).build(), (Policy[])new RetryPolicy[0]).get(() -> (TableMetadata)metadataLoader.apply(newLocation));
        }
        catch (UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Error accessing metadata file for table %s".formatted(this.getSchemaTableName().toString()), (Throwable)e);
        }
        catch (Throwable failure) {
            throw IcebergExceptions.translateMetadataException(failure, this.getSchemaTableName().toString());
        }
        String newUUID = newMetadata.uuid();
        if (this.currentMetadata != null) {
            Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
        }
        this.currentMetadata = newMetadata;
        this.currentMetadataLocation = newLocation;
        this.version = OptionalInt.of(IcebergUtil.parseVersion(Location.of((String)newLocation).fileName()));
        this.shouldRefresh = false;
    }

    protected static String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codec = meta.property("write.metadata.compression-codec", "none");
        return AbstractIcebergTableOperations.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), TableMetadataParser.getFileExtension((String)codec)));
    }

    protected static String metadataFileLocation(TableMetadata metadata, String filename) {
        String location = (String)metadata.properties().get("write.metadata.path");
        if (location != null) {
            return String.format("%s/%s", LocationUtil.stripTrailingSlash((String)location), filename);
        }
        return String.format("%s/%s/%s", LocationUtil.stripTrailingSlash((String)metadata.location()), "metadata", filename);
    }

    public static List<Column> toHiveColumns(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new Column(column.name(), HiveType.fromTypeInfo((TypeInfo)HiveSchemaUtil.convert(column.type())), Optional.empty(), Map.of())).collect(ImmutableList.toImmutableList());
    }
}

