/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.file.IcebergFileMetastoreCatalogModule;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogModule;
import io.trino.plugin.iceberg.catalog.hms.IcebergHiveMetastoreCatalogModule;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogModule;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogModule;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogModule;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogModule;

public class IcebergCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindCatalogModule(CatalogType.HIVE_METASTORE, (Module)new IcebergHiveMetastoreCatalogModule());
        this.bindCatalogModule(CatalogType.TESTING_FILE_METASTORE, (Module)new IcebergFileMetastoreCatalogModule());
        this.bindCatalogModule(CatalogType.GLUE, (Module)new IcebergGlueCatalogModule());
        this.bindCatalogModule(CatalogType.REST, (Module)new IcebergRestCatalogModule());
        this.bindCatalogModule(CatalogType.JDBC, (Module)new IcebergJdbcCatalogModule());
        this.bindCatalogModule(CatalogType.NESSIE, (Module)new IcebergNessieCatalogModule());
        this.bindCatalogModule(CatalogType.SNOWFLAKE, (Module)new IcebergSnowflakeCatalogModule());
    }

    private void bindCatalogModule(CatalogType catalogType, Module module) {
        this.install(ConditionalModule.conditionalModule(IcebergConfig.class, config -> config.getCatalogType() == catalogType, (Module)module));
    }
}

