/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.collect.ImmutableList;
import io.trino.metastore.TableInfo;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.TrinoPrincipal;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;

public interface TrinoCatalog {
    public boolean namespaceExists(ConnectorSession var1, String var2);

    public List<String> listNamespaces(ConnectorSession var1);

    public void dropNamespace(ConnectorSession var1, String var2);

    default public Optional<String> getNamespaceSeparator() {
        return Optional.empty();
    }

    public Map<String, Object> loadNamespaceMetadata(ConnectorSession var1, String var2);

    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession var1, String var2);

    public void createNamespace(ConnectorSession var1, String var2, Map<String, Object> var3, TrinoPrincipal var4);

    public void setNamespacePrincipal(ConnectorSession var1, String var2, TrinoPrincipal var3);

    public void renameNamespace(ConnectorSession var1, String var2, String var3);

    public List<TableInfo> listTables(ConnectorSession var1, Optional<String> var2);

    public List<SchemaTableName> listIcebergTables(ConnectorSession var1, Optional<String> var2);

    default public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listTables(session, namespace).stream().filter(info -> info.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_VIEW).map(TableInfo::tableName).collect(ImmutableList.toImmutableList());
    }

    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession var1, Optional<String> var2, UnaryOperator<Set<SchemaTableName>> var3, Predicate<SchemaTableName> var4);

    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession var1, Optional<String> var2, UnaryOperator<Set<SchemaTableName>> var3, Predicate<SchemaTableName> var4);

    default public Transaction newTransaction(Table icebergTable) {
        return icebergTable.newTransaction();
    }

    public Transaction newCreateTableTransaction(ConnectorSession var1, SchemaTableName var2, Schema var3, PartitionSpec var4, SortOrder var5, Optional<String> var6, Map<String, String> var7);

    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession var1, SchemaTableName var2, Schema var3, PartitionSpec var4, SortOrder var5, String var6, Map<String, String> var7);

    public void registerTable(ConnectorSession var1, SchemaTableName var2, TableMetadata var3);

    public void unregisterTable(ConnectorSession var1, SchemaTableName var2);

    public void dropTable(ConnectorSession var1, SchemaTableName var2);

    public void dropCorruptedTable(ConnectorSession var1, SchemaTableName var2);

    public void renameTable(ConnectorSession var1, SchemaTableName var2, SchemaTableName var3);

    public BaseTable loadTable(ConnectorSession var1, SchemaTableName var2);

    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession var1, List<SchemaTableName> var2);

    public void updateTableComment(ConnectorSession var1, SchemaTableName var2, Optional<String> var3);

    public void updateViewComment(ConnectorSession var1, SchemaTableName var2, Optional<String> var3);

    public void updateViewColumnComment(ConnectorSession var1, SchemaTableName var2, String var3, Optional<String> var4);

    @Nullable
    public String defaultTableLocation(ConnectorSession var1, SchemaTableName var2);

    public void setTablePrincipal(ConnectorSession var1, SchemaTableName var2, TrinoPrincipal var3);

    public void createView(ConnectorSession var1, SchemaTableName var2, ConnectorViewDefinition var3, boolean var4);

    public void renameView(ConnectorSession var1, SchemaTableName var2, SchemaTableName var3);

    public void setViewPrincipal(ConnectorSession var1, SchemaTableName var2, TrinoPrincipal var3);

    public void dropView(ConnectorSession var1, SchemaTableName var2);

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession var1, Optional<String> var2);

    public Optional<ConnectorViewDefinition> getView(ConnectorSession var1, SchemaTableName var2);

    public void createMaterializedView(ConnectorSession var1, SchemaTableName var2, ConnectorMaterializedViewDefinition var3, Map<String, Object> var4, boolean var5, boolean var6);

    public void updateMaterializedViewColumnComment(ConnectorSession var1, SchemaTableName var2, String var3, Optional<String> var4);

    public void dropMaterializedView(ConnectorSession var1, SchemaTableName var2);

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession var1, SchemaTableName var2);

    public Map<String, Object> getMaterializedViewProperties(ConnectorSession var1, SchemaTableName var2, ConnectorMaterializedViewDefinition var3);

    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession var1, SchemaTableName var2);

    public void renameMaterializedView(ConnectorSession var1, SchemaTableName var2, SchemaTableName var3);

    public void updateColumnComment(ConnectorSession var1, SchemaTableName var2, ColumnIdentity var3, Optional<String> var4);

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession var1, SchemaTableName var2, String var3);
}

