/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.catalog.glue.TrinoGlueCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.io.FileIO;
import software.amazon.awssdk.services.glue.GlueClient;

public class GlueIcebergTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final TypeManager typeManager;
    private final boolean cacheTableMetadata;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final GlueClient glueClient;
    private final GlueMetastoreStats stats;

    @Inject
    public GlueIcebergTableOperationsProvider(TypeManager typeManager, IcebergGlueCatalogConfig catalogConfig, TrinoFileSystemFactory fileSystemFactory, GlueMetastoreStats stats, GlueClient glueClient) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cacheTableMetadata = catalogConfig.isCacheTableMetadata();
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new GlueIcebergTableOperations(this.typeManager, this.cacheTableMetadata, this.glueClient, this.stats, ((TrinoGlueCatalog)catalog)::getTable, (FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session), IcebergSessionProperties.isUseFileSizeFromMetadata(session)), session, database, table, owner, location);
    }
}

