/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.log.Logger;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.SchemaAlreadyExistsException;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.util.ExecutorUtil;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.TrinoViewUtil;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.GlueConverter;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoMetricsReporter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsReporter;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.TableInput;

public class TrinoGlueCatalog
extends AbstractTrinoCatalog {
    private static final Logger LOG = Logger.get(TrinoGlueCatalog.class);
    private static final int PER_QUERY_CACHES_SIZE = 1000;
    private final String trinoVersion;
    private final boolean cacheTableMetadata;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final Optional<String> defaultSchemaLocation;
    private final GlueClient glueClient;
    private final GlueMetastoreStats stats;
    private final boolean hideMaterializedViewStorageTable;
    private final boolean isUsingSystemSecurity;
    private final Executor metadataFetchingExecutor;
    private final Cache<SchemaTableName, software.amazon.awssdk.services.glue.model.Table> glueTableCache = EvictableCacheBuilder.newBuilder().maximumSize((long)Math.max(1000, 1000)).build();
    private final Cache<SchemaTableName, TableMetadata> tableMetadataCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<SchemaTableName, ConnectorViewDefinition> viewCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<SchemaTableName, MaterializedViewData> materializedViewCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();

    public TrinoGlueCatalog(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, boolean cacheTableMetadata, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, GlueClient glueClient, GlueMetastoreStats stats, boolean isUsingSystemSecurity, Optional<String> defaultSchemaLocation, boolean useUniqueTableLocation, boolean hideMaterializedViewStorageTable, Executor metadataFetchingExecutor) {
        super(catalogName, typeManager, tableOperationsProvider, fileSystemFactory, useUniqueTableLocation);
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.cacheTableMetadata = cacheTableMetadata;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.defaultSchemaLocation = Objects.requireNonNull(defaultSchemaLocation, "defaultSchemaLocation is null");
        this.hideMaterializedViewStorageTable = hideMaterializedViewStorageTable;
        this.metadataFetchingExecutor = Objects.requireNonNull(metadataFetchingExecutor, "metadataFetchingExecutor is null");
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        if (!namespace.equals(namespace.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        return (Boolean)this.stats.getGetDatabase().call(() -> {
            try {
                this.glueClient.getDatabase(x -> x.name(namespace));
                return true;
            }
            catch (EntityNotFoundException e) {
                return false;
            }
            catch (SdkException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
            }
        });
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        try {
            return (List)this.stats.getGetDatabases().call(() -> (ImmutableList)this.glueClient.getDatabasesPaginator(builder -> {}).stream().map(GetDatabasesResponse::databaseList).flatMap(Collection::stream).map(Database::name).collect(ImmutableList.toImmutableList()));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.glueTableCache.invalidateAll();
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(x -> x.name(namespace)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            Database database = (Database)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(x -> x.name(namespace)).database());
            ImmutableMap.Builder metadata = ImmutableMap.builder();
            if (database.locationUri() != null) {
                metadata.put((Object)"location", (Object)database.locationUri());
            }
            if (database.parameters() != null) {
                metadata.putAll(database.parameters());
            }
            return metadata.buildOrThrow();
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((owner.getType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Owner type must be USER");
        Preconditions.checkArgument((boolean)owner.getName().equals(session.getUser().toLowerCase(Locale.ENGLISH)), (Object)"Explicit schema owner is not supported");
        try {
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(x -> x.databaseInput(TrinoGlueCatalog.createDatabaseInput(namespace, properties))));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(namespace, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private static DatabaseInput createDatabaseInput(String namespace, Map<String, Object> properties) {
        DatabaseInput.Builder databaseInput = DatabaseInput.builder().name(namespace);
        properties.forEach((property, value) -> {
            switch (property) {
                case "location": {
                    databaseInput.locationUri((String)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized property: " + property);
                }
            }
        });
        return (DatabaseInput)databaseInput.build();
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg Glue catalogs");
    }

    @Override
    public List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace) {
        return this.listTables(session, namespace, table -> true);
    }

    @Override
    public List<SchemaTableName> listIcebergTables(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listTables(session, namespace, table -> HiveUtil.isIcebergTable((Map)table.parameters())).stream().map(TableInfo::tableName).collect(ImmutableList.toImmutableList());
    }

    private List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace, Predicate<software.amazon.awssdk.services.glue.model.Table> tablePredicate) {
        List tasks = (List)this.listNamespaces(session, namespace).stream().map(glueNamespace -> () -> (List)this.getGlueTablesWithExceptionHandling((String)glueNamespace).filter(tablePredicate).map(table -> this.mapToTableInfo((String)glueNamespace, (software.amazon.awssdk.services.glue.model.Table)table)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        try {
            return (List)ExecutorUtil.processWithAdditionalThreads((Collection)tasks, (Executor)this.metadataFetchingExecutor).stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private TableInfo mapToTableInfo(String glueNamespace, software.amazon.awssdk.services.glue.model.Table table) {
        return new TableInfo(new SchemaTableName(glueNamespace, table.name()), TableInfo.ExtendedRelationType.fromTableTypeAndComment((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)table), (String)((String)table.parameters().get("comment"))));
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        ImmutableList.Builder unfilteredResult = ImmutableList.builder();
        ImmutableList.Builder filteredResult = ImmutableList.builder();
        HashMap<SchemaTableName, software.amazon.awssdk.services.glue.model.Table> unprocessed = new HashMap<SchemaTableName, software.amazon.awssdk.services.glue.model.Table>();
        this.listNamespaces(session, namespace).stream().flatMap(glueNamespace -> this.getGlueTables((String)glueNamespace).map(table -> Map.entry(new SchemaTableName(glueNamespace, table.name()), table))).forEach(entry -> {
            Map tableParameters;
            SchemaTableName name = (SchemaTableName)entry.getKey();
            software.amazon.awssdk.services.glue.model.Table table = (software.amazon.awssdk.services.glue.model.Table)entry.getValue();
            String tableType = GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)table);
            if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)(tableParameters = table.parameters()))) {
                IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData(table.viewOriginalText());
                unfilteredResult.add((Object)RelationColumnsMetadata.forMaterializedView((SchemaTableName)name, this.toSpiMaterializedViewColumns(definition.columns())));
            } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)tableParameters)) {
                ConnectorViewDefinition definition = ViewReaderUtil.PrestoViewReader.decodeViewData((String)table.viewOriginalText());
                unfilteredResult.add((Object)RelationColumnsMetadata.forView((SchemaTableName)name, (List)definition.getColumns()));
            } else if (isRedirected.test(name)) {
                unfilteredResult.add((Object)RelationColumnsMetadata.forRedirectedTable((SchemaTableName)name));
            } else if (HiveUtil.isIcebergTable((Map)tableParameters)) {
                Optional<List<ColumnMetadata>> columnMetadata = this.getCachedColumnMetadata(table);
                if (columnMetadata.isPresent()) {
                    unfilteredResult.add((Object)RelationColumnsMetadata.forTable((SchemaTableName)name, columnMetadata.get()));
                } else {
                    unprocessed.put(name, table);
                    if (unprocessed.size() >= 1000) {
                        this.getColumnsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
                        unprocessed.clear();
                    }
                }
            }
        });
        if (!unprocessed.isEmpty()) {
            this.getColumnsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
        }
        ImmutableList unfilteredResultList = unfilteredResult.build();
        Set availableNames = (Set)relationFilter.apply((Set)unfilteredResultList.stream().map(RelationColumnsMetadata::name).collect(ImmutableSet.toImmutableSet()));
        return Optional.of(Stream.concat(unfilteredResultList.stream().filter(commentMetadata -> availableNames.contains(commentMetadata.name())), filteredResult.build().stream()).iterator());
    }

    private void getColumnsFromIcebergMetadata(ConnectorSession session, Map<SchemaTableName, software.amazon.awssdk.services.glue.model.Table> glueTables, UnaryOperator<Set<SchemaTableName>> relationFilter, Consumer<RelationColumnsMetadata> resultsCollector) {
        for (SchemaTableName tableName : (Set)relationFilter.apply(glueTables.keySet())) {
            List<ColumnMetadata> columns;
            software.amazon.awssdk.services.glue.model.Table table = glueTables.get(tableName);
            CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> table);
            try {
                columns = IcebergUtil.getColumnMetadatas(this.loadTable(session, tableName).schema(), this.typeManager);
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
                return;
            }
            resultsCollector.accept(RelationColumnsMetadata.forTable((SchemaTableName)tableName, columns));
        }
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        if (!this.cacheTableMetadata) {
            return Optional.empty();
        }
        ImmutableList.Builder unfilteredResult = ImmutableList.builder();
        ImmutableList.Builder filteredResult = ImmutableList.builder();
        HashMap<SchemaTableName, software.amazon.awssdk.services.glue.model.Table> unprocessed = new HashMap<SchemaTableName, software.amazon.awssdk.services.glue.model.Table>();
        this.listNamespaces(session, namespace).stream().flatMap(glueNamespace -> this.getGlueTables((String)glueNamespace).map(table -> Map.entry(new SchemaTableName(glueNamespace, table.name()), table))).forEach(entry -> {
            Map tableParameters;
            SchemaTableName name = (SchemaTableName)entry.getKey();
            software.amazon.awssdk.services.glue.model.Table table = (software.amazon.awssdk.services.glue.model.Table)entry.getValue();
            String tableType = GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)table);
            if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)(tableParameters = table.parameters()))) {
                Optional<String> comment = IcebergMaterializedViewDefinition.decodeMaterializedViewData(table.viewOriginalText()).comment();
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, comment));
            } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)tableParameters)) {
                Optional comment = ViewReaderUtil.PrestoViewReader.decodeViewData((String)table.viewOriginalText()).getComment();
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, (Optional)comment));
            } else if (isRedirected.test(name)) {
                unfilteredResult.add((Object)RelationCommentMetadata.forRedirectedTable((SchemaTableName)name));
            } else if (!HiveUtil.isIcebergTable((Map)tableParameters)) {
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, Optional.empty()));
            } else {
                String metadataLocation = (String)tableParameters.get("metadata_location");
                String metadataValidForMetadata = (String)tableParameters.get("trino_table_metadata_info_valid_for");
                boolean tableCommentWasCached = tableParameters.getOrDefault("trino_table_comment_cache_prevented", "false").equals("false");
                if (metadataValidForMetadata != null && metadataValidForMetadata.equals(metadataLocation) && tableCommentWasCached) {
                    Optional<String> comment = Optional.ofNullable((String)tableParameters.get("comment"));
                    unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, comment));
                } else {
                    unprocessed.put(name, table);
                    if (unprocessed.size() >= 1000) {
                        this.getCommentsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
                        unprocessed.clear();
                    }
                }
            }
        });
        if (!unprocessed.isEmpty()) {
            this.getCommentsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
        }
        ImmutableList unfilteredResultList = unfilteredResult.build();
        Set availableNames = (Set)relationFilter.apply((Set)unfilteredResultList.stream().map(RelationCommentMetadata::name).collect(ImmutableSet.toImmutableSet()));
        return Optional.of(Stream.concat(unfilteredResultList.stream().filter(commentMetadata -> availableNames.contains(commentMetadata.name())), filteredResult.build().stream()).iterator());
    }

    private void getCommentsFromIcebergMetadata(ConnectorSession session, Map<SchemaTableName, software.amazon.awssdk.services.glue.model.Table> glueTables, UnaryOperator<Set<SchemaTableName>> relationFilter, Consumer<RelationCommentMetadata> resultsCollector) {
        for (SchemaTableName tableName : (Set)relationFilter.apply(glueTables.keySet())) {
            Optional<String> comment;
            software.amazon.awssdk.services.glue.model.Table table = glueTables.get(tableName);
            CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> table);
            try {
                comment = IcebergUtil.getTableComment((Table)this.loadTable(session, tableName));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
                return;
            }
            resultsCollector.accept(RelationCommentMetadata.forRelation((SchemaTableName)tableName, comment));
        }
    }

    @Override
    public BaseTable loadTable(ConnectorSession session, SchemaTableName table) {
        TableMetadata metadata;
        if (this.viewCache.asMap().containsKey(table) || this.materializedViewCache.asMap().containsKey(table)) {
            throw new TableNotFoundException(table);
        }
        try {
            metadata = (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)table, () -> {
                IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
                return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER).operations().current();
            });
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, table, metadata);
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        if (!this.cacheTableMetadata) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder metadatas = ImmutableMap.builder();
        for (SchemaTableName tableName : tables) {
            Optional<List<ColumnMetadata>> columnMetadata;
            try {
                columnMetadata = this.getCachedColumnMetadata(tableName);
            }
            catch (TableNotFoundException ignore) {
                continue;
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to access get metadata of table %s during bulk retrieval of table columns", new Object[]{tableName});
                continue;
            }
            columnMetadata.ifPresent(columns -> metadatas.put((Object)tableName, columns));
        }
        return metadatas.buildOrThrow();
    }

    private Optional<List<ColumnMetadata>> getCachedColumnMetadata(SchemaTableName tableName) {
        if (!this.cacheTableMetadata || this.viewCache.asMap().containsKey(tableName) || this.materializedViewCache.asMap().containsKey(tableName)) {
            return Optional.empty();
        }
        software.amazon.awssdk.services.glue.model.Table glueTable = this.getTable(tableName, false);
        return this.getCachedColumnMetadata(glueTable);
    }

    private Optional<List<ColumnMetadata>> getCachedColumnMetadata(software.amazon.awssdk.services.glue.model.Table glueTable) {
        if (!this.cacheTableMetadata) {
            return Optional.empty();
        }
        Map tableParameters = glueTable.parameters();
        String metadataLocation = (String)tableParameters.get("metadata_location");
        String metadataValidForMetadata = (String)tableParameters.get("trino_table_metadata_info_valid_for");
        Optional<StorageDescriptor> storageDescriptor = Optional.ofNullable(glueTable.storageDescriptor());
        if (metadataLocation == null || !metadataLocation.equals(metadataValidForMetadata) || storageDescriptor.isEmpty() || !storageDescriptor.get().hasColumns()) {
            return Optional.empty();
        }
        List glueColumns = storageDescriptor.get().columns();
        if (glueColumns.stream().noneMatch(column -> column.parameters().containsKey("trino_type_id"))) {
            return Optional.empty();
        }
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)glueColumns.size());
        for (Column glueColumn : glueColumns) {
            Map columnParameters = glueColumn.parameters();
            String trinoTypeId = columnParameters.getOrDefault("trino_type_id", glueColumn.type());
            boolean notNull = Boolean.parseBoolean(columnParameters.getOrDefault("trino_not_null", "false"));
            Type type = this.typeManager.getType(TypeId.of((String)trinoTypeId));
            columns.add((Object)ColumnMetadata.builder().setName(glueColumn.name()).setType(type).setComment(Optional.ofNullable(glueColumn.comment())).setNullable(!notNull).build());
        }
        return Optional.of(columns.build());
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = this.loadTable(session, schemaTableName);
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        try {
            CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e, "Failed to delete table data referenced by metadata");
        }
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.location());
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        software.amazon.awssdk.services.glue.model.Table table = this.dropTableFromMetastore(session, schemaTableName);
        String metadataLocation = (String)table.parameters().get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table %s is missing [%s] property", schemaTableName, "metadata_location"));
        }
        String tableLocation = metadataLocation.replaceFirst("/metadata/[^/]*$", "");
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, tableLocation);
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, Optional<String> location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateOrReplaceTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName schemaTableName, TableMetadata tableMetadata) throws TrinoException {
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, schemaTableName.getTableName(), Optional.of(session.getUser()), tableMetadata, tableMetadata.location(), tableMetadata.metadataFileLocation(), (Map<String, String>)ImmutableMap.of(), this.cacheTableMetadata);
        this.createTable(schemaTableName.getSchemaName(), tableInput);
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName schemaTableName) {
        this.dropTableFromMetastore(session, schemaTableName);
        this.invalidateTableCache(schemaTableName);
    }

    private software.amazon.awssdk.services.glue.model.Table dropTableFromMetastore(ConnectorSession session, SchemaTableName schemaTableName) {
        software.amazon.awssdk.services.glue.model.Table table = this.getTableAndCacheMetadata(session, schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!HiveUtil.isIcebergTable((Map)table.parameters())) {
            throw new UnknownTableTypeException(schemaTableName);
        }
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        return table;
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        boolean newTableCreated = false;
        try {
            software.amazon.awssdk.services.glue.model.Table table = this.getTableAndCacheMetadata(session, from).orElseThrow(() -> new TableNotFoundException(from));
            HashMap<String, String> tableParameters = new HashMap<String, String>(table.parameters());
            FileIO io = this.loadTable(session, from).io();
            String metadataLocation = (String)tableParameters.remove("metadata_location");
            if (metadataLocation == null) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table %s is missing [%s] property", from, "metadata_location"));
            }
            TableMetadata metadata = TableMetadataParser.read((FileIO)io, (InputFile)io.newInputFile(metadataLocation));
            TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, to.getTableName(), Optional.ofNullable(table.owner()), metadata, Optional.ofNullable(table.storageDescriptor()).map(StorageDescriptor::location).orElse(null), metadataLocation, tableParameters, this.cacheTableMetadata);
            this.createTable(to.getSchemaName(), tableInput);
            newTableCreated = true;
            this.deleteTable(from.getSchemaName(), from.getTableName());
            this.invalidateTableCache(from);
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(to.getSchemaName(), to.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private Optional<software.amazon.awssdk.services.glue.model.Table> getTableAndCacheMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        software.amazon.awssdk.services.glue.model.Table table;
        try {
            table = this.getTable(schemaTableName, false);
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        String tableType = GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)table);
        Map parameters = table.parameters();
        if (HiveUtil.isIcebergTable((Map)parameters) && !this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
            if (this.viewCache.asMap().containsKey(schemaTableName) || this.materializedViewCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Table cannot also be a view/materialized view");
            }
            String metadataLocation = (String)parameters.get("metadata_location");
            try {
                CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)schemaTableName, () -> TableMetadataParser.read((FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session), IcebergSessionProperties.isUseFileSizeFromMetadata(session)), (String)metadataLocation));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache table metadata from table at %s", new Object[]{metadataLocation});
            }
        } else if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)parameters)) {
            if (this.viewCache.asMap().containsKey(schemaTableName) || this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Materialized View cannot also be a table or view");
            }
            try {
                CacheUtils.uncheckedCacheGet(this.materializedViewCache, (Object)schemaTableName, () -> {
                    ConnectorMaterializedViewDefinition materializedView = this.createMaterializedViewDefinition(schemaTableName, table);
                    return new MaterializedViewData(materializedView, Optional.ofNullable((String)parameters.get("metadata_location")));
                });
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache materialized view from %s", new Object[]{schemaTableName});
            }
        } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)parameters) && !this.viewCache.asMap().containsKey(schemaTableName)) {
            if (this.materializedViewCache.asMap().containsKey(schemaTableName) || this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. View cannot also be a materialized view or table");
            }
            try {
                TrinoViewUtil.getView(Optional.ofNullable(table.viewOriginalText()), (String)tableType, (Map)parameters, Optional.ofNullable(table.owner())).ifPresent(viewDefinition -> CacheUtils.uncheckedCacheGet(this.viewCache, (Object)schemaTableName, () -> viewDefinition));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache view from %s", new Object[]{schemaTableName});
            }
        }
        return Optional.of(table);
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        String databaseLocation = (String)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(x -> x.name(schemaTableName.getSchemaName())).database().locationUri());
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        if (databaseLocation == null) {
            if (this.defaultSchemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Schema '%s' location cannot be determined. Either set the 'location' property when creating the schema, or set the 'hive.metastore.glue.default-warehouse-dir' catalog property.", schemaTableName.getSchemaName()));
            }
            String schemaDirectoryName = schemaTableName.getSchemaName() + ".db";
            databaseLocation = Locations.appendPath((String)this.defaultSchemaLocation.get(), (String)schemaDirectoryName);
        }
        return Locations.appendPath((String)databaseLocation, (String)tableName);
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(schemaViewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        Failsafe.with((Policy)((RetryPolicyBuilder)RetryPolicy.builder().withMaxRetries(3).withDelay(Duration.ofMillis(100L)).handleIf(throwable -> replace && !(throwable instanceof ViewAlreadyExistsException))).abortOn(TrinoFileSystem::isUnrecoverableException).build(), (Policy[])new RetryPolicy[0]).run(() -> this.doCreateView(session, schemaViewName, viewTableInput, replace));
    }

    private void doCreateView(ConnectorSession session, SchemaTableName schemaViewName, TableInput viewTableInput, boolean replace) {
        Optional<software.amazon.awssdk.services.glue.model.Table> existing = this.getTableAndCacheMetadata(session, schemaViewName);
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isTrinoView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)existing.get()), (Map)existing.get().parameters())) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.updateTable(schemaViewName.getSchemaName(), viewTableInput);
            return;
        }
        try {
            this.createTable(schemaViewName.getSchemaName(), viewTableInput);
        }
        catch (AlreadyExistsException e) {
            throw new ViewAlreadyExistsException(schemaViewName);
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            software.amazon.awssdk.services.glue.model.Table existingView = this.getTableAndCacheMetadata(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.viewCache.invalidate((Object)source);
            TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(target.getTableName(), existingView.viewOriginalText(), existingView.owner(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
            this.createTable(target.getSchemaName(), viewTableInput);
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (Exception e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (Exception cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.viewCache.invalidate((Object)schemaViewName);
            this.deleteTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition cachedView = (ConnectorViewDefinition)this.viewCache.getIfPresent((Object)viewName);
        if (cachedView != null) {
            return Optional.of(cachedView);
        }
        if (this.tableMetadataCache.asMap().containsKey(viewName) || this.materializedViewCache.asMap().containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<software.amazon.awssdk.services.glue.model.Table> table = this.getTableAndCacheMetadata(session, viewName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        software.amazon.awssdk.services.glue.model.Table viewDefinition = table.get();
        return TrinoViewUtil.getView(Optional.ofNullable(viewDefinition.viewOriginalText()), (String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)viewDefinition), (Map)viewDefinition.parameters(), Optional.ofNullable(viewDefinition.owner()));
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.updateView(session, viewName, newDefinition);
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getComment(), definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.updateView(session, viewName, newDefinition);
    }

    private void updateView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition newDefinition) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(viewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)newDefinition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        try {
            this.updateTable(viewName.getSchemaName(), viewTableInput);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        Optional<software.amazon.awssdk.services.glue.model.Table> existing = this.getTableAndCacheMetadata(session, viewName);
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)existing.get()), (Map)existing.get().parameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + String.valueOf(viewName));
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + String.valueOf(viewName));
            }
        }
        if (this.hideMaterializedViewStorageTable) {
            Location storageMetadataLocation = this.createMaterializedViewStorage(session, viewName, definition, materializedViewProperties);
            TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), this.isUsingSystemSecurity ? null : session.getUser(), this.createMaterializedViewProperties(session, storageMetadataLocation));
            try {
                if (existing.isPresent()) {
                    this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
                } else {
                    this.createTable(viewName.getSchemaName(), materializedViewTableInput);
                }
            }
            catch (RuntimeException e) {
                block12: {
                    try {
                        this.dropMaterializedViewStorage(session, this.fileSystemFactory.create(session), storageMetadataLocation.toString());
                    }
                    catch (Exception suppressed) {
                        LOG.warn((Throwable)suppressed, "Failed to clean up metadata '%s' for materialized view '%s'", new Object[]{storageMetadataLocation, viewName});
                        if (e == suppressed) break block12;
                        e.addSuppressed(suppressed);
                    }
                }
                throw e;
            }
            existing.ifPresent(existingView -> this.dropMaterializedViewStorage(session, (software.amazon.awssdk.services.glue.model.Table)existingView));
        } else {
            this.createMaterializedViewWithStorageTable(session, viewName, definition, materializedViewProperties, existing);
        }
    }

    private void createMaterializedViewWithStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, Optional<software.amazon.awssdk.services.glue.model.Table> existing) {
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition, materializedViewProperties);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), this.isUsingSystemSecurity ? null : session.getUser(), this.createMaterializedViewProperties(session, storageTable));
        if (existing.isPresent()) {
            block6: {
                try {
                    this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
                }
                catch (RuntimeException e) {
                    try {
                        this.dropTable(session, storageTable);
                    }
                    catch (RuntimeException suppressed) {
                        LOG.warn((Throwable)suppressed, "Failed to drop new storage table '%s' for materialized view '%s'", new Object[]{storageTable, viewName});
                        if (e == suppressed) break block6;
                        e.addSuppressed(suppressed);
                    }
                }
            }
            this.dropMaterializedViewStorage(session, existing.get());
        } else {
            this.createTable(viewName.getSchemaName(), materializedViewTableInput);
        }
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorMaterializedViewDefinition definition = this.doGetMaterializedView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorMaterializedViewDefinition newDefinition = new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), definition.getStorageTable(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorMaterializedViewDefinition.Column(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getGracePeriod(), definition.getComment(), definition.getOwner(), definition.getPath());
        this.updateMaterializedView(viewName, newDefinition);
    }

    private void updateMaterializedView(SchemaTableName viewName, ConnectorMaterializedViewDefinition newDefinition) {
        software.amazon.awssdk.services.glue.model.Table table = this.getTable(viewName, false);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(newDefinition)), table.owner(), table.parameters());
        try {
            this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        software.amazon.awssdk.services.glue.model.Table view = this.getTableAndCacheMetadata(session, viewName).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)view), (Map)view.parameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + view.databaseName() + "." + view.name());
        }
        this.materializedViewCache.invalidate((Object)viewName);
        this.dropMaterializedViewStorage(session, view);
        this.deleteTable(view.databaseName(), view.name());
    }

    private void dropMaterializedViewStorage(ConnectorSession session, software.amazon.awssdk.services.glue.model.Table view) {
        Map parameters = view.parameters();
        String storageTableName = (String)parameters.get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)parameters.get("storage_schema")).orElse(view.databaseName());
            try {
                this.dropTable(session, new SchemaTableName(storageSchema, storageTableName));
            }
            catch (TrinoException e) {
                LOG.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, view.name()});
            }
        } else {
            String storageMetadataLocation = (String)parameters.get("metadata_location");
            Preconditions.checkState((storageMetadataLocation != null ? 1 : 0) != 0, (Object)("Storage location missing in definition of materialized view " + view.name()));
            try {
                this.dropMaterializedViewStorage(session, this.fileSystemFactory.create(session), storageMetadataLocation);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e, "Failed to delete storage table metadata '%s' for materialized view '%s'", new Object[]{storageMetadataLocation, view.name()});
            }
        }
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        MaterializedViewData materializedViewData = (MaterializedViewData)this.materializedViewCache.getIfPresent((Object)viewName);
        if (materializedViewData != null) {
            return Optional.of(materializedViewData.connectorMaterializedViewDefinition);
        }
        if (this.tableMetadataCache.asMap().containsKey(viewName) || this.viewCache.asMap().containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<software.amazon.awssdk.services.glue.model.Table> maybeTable = this.getTableAndCacheMetadata(session, viewName);
        if (maybeTable.isEmpty()) {
            return Optional.empty();
        }
        software.amazon.awssdk.services.glue.model.Table table = maybeTable.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)table), (Map)table.parameters())) {
            return Optional.empty();
        }
        return Optional.of(this.createMaterializedViewDefinition(viewName, table));
    }

    private ConnectorMaterializedViewDefinition createMaterializedViewDefinition(SchemaTableName viewName, software.amazon.awssdk.services.glue.model.Table table) {
        SchemaTableName storageTableName;
        String storageMetadataLocation;
        Map materializedViewParameters = table.parameters();
        String storageTable = (String)materializedViewParameters.get("storage_table");
        if (storageTable == null == ((storageMetadataLocation = (String)materializedViewParameters.get("metadata_location")) == null)) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view should have exactly one of the %s properties set: %s".formatted(ImmutableList.of((Object)"storage_table", (Object)"metadata_location"), materializedViewParameters));
        }
        if (storageTable != null) {
            String storageSchema = Optional.ofNullable((String)materializedViewParameters.get("storage_schema")).orElse(viewName.getSchemaName());
            storageTableName = new SchemaTableName(storageSchema, storageTable);
            if (table.viewOriginalText() == null) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view did not have original text " + String.valueOf(viewName));
            }
        } else {
            storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        }
        return this.getMaterializedViewDefinition(Optional.ofNullable(table.owner()), table.viewOriginalText(), storageTableName);
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        String storageMetadataLocation;
        MaterializedViewData materializedViewData = (MaterializedViewData)this.materializedViewCache.getIfPresent((Object)viewName);
        if (materializedViewData == null) {
            Optional<software.amazon.awssdk.services.glue.model.Table> maybeTable = this.getTableAndCacheMetadata(session, viewName);
            if (maybeTable.isEmpty()) {
                return Optional.empty();
            }
            software.amazon.awssdk.services.glue.model.Table materializedView = maybeTable.get();
            Verify.verify((boolean)ViewReaderUtil.isTrinoMaterializedView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)materializedView), (Map)materializedView.parameters()), (String)"getMaterializedViewStorageTable received a table, not a materialized view", (Object[])new Object[0]);
            storageMetadataLocation = (String)materializedView.parameters().get("metadata_location");
            Preconditions.checkState((storageMetadataLocation != null ? 1 : 0) != 0, (Object)("Storage location missing in definition of materialized view " + materializedView.name()));
        } else {
            storageMetadataLocation = materializedViewData.storageMetadataLocation.orElseThrow(() -> new IllegalStateException("Storage location not defined for materialized view " + String.valueOf(viewName)));
        }
        SchemaTableName storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, storageTableName.getSchemaName(), storageTableName.getTableName(), Optional.empty(), Optional.empty());
        try {
            TableMetadata metadata = this.getMaterializedViewTableMetadata(session, storageTableName, storageMetadataLocation);
            operations.initializeFromMetadata(metadata);
            return Optional.of(new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(storageTableName), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof NotFoundException) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private TableMetadata getMaterializedViewTableMetadata(ConnectorSession session, SchemaTableName storageTableName, String storageMetadataLocation) {
        Objects.requireNonNull(storageTableName, "storageTableName is null");
        Objects.requireNonNull(storageMetadataLocation, "storageMetadataLocation is null");
        return (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)storageTableName, () -> {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            return TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystem, IcebergSessionProperties.isUseFileSizeFromMetadata(session)), (String)storageMetadataLocation);
        });
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            software.amazon.awssdk.services.glue.model.Table glueTable = this.getTableAndCacheMetadata(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.materializedViewCache.invalidate((Object)source);
            Map tableParameters = glueTable.parameters();
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueConverter.getTableType((software.amazon.awssdk.services.glue.model.Table)glueTable), (Map)tableParameters)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + String.valueOf(source));
            }
            TableInput tableInput = GlueIcebergUtil.getMaterializedViewTableInput(target.getTableName(), glueTable.viewOriginalText(), glueTable.owner(), tableParameters);
            this.createTable(target.getSchemaName(), tableInput);
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(hiveCatalogName, "hiveCatalogName is null");
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional<software.amazon.awssdk.services.glue.model.Table> table = this.getTableAndCacheMetadata(session, new SchemaTableName(tableNameBase.getSchemaName(), tableNameBase.getTableName()));
        if (table.isEmpty() || io.trino.plugin.hive.TableType.VIRTUAL_VIEW.name().equals(GlueConverter.getTableTypeNullable((software.amazon.awssdk.services.glue.model.Table)table.get()))) {
            return Optional.empty();
        }
        if (!HiveUtil.isIcebergTable((Map)table.get().parameters())) {
            return Optional.of(new CatalogSchemaTableName(hiveCatalogName, tableName));
        }
        return Optional.empty();
    }

    @Override
    protected void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableMetadataCache.invalidate((Object)schemaTableName);
    }

    software.amazon.awssdk.services.glue.model.Table getTable(SchemaTableName tableName, boolean invalidateCaches) {
        if (invalidateCaches) {
            this.glueTableCache.invalidate((Object)tableName);
        }
        try {
            return (software.amazon.awssdk.services.glue.model.Table)CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> {
                try {
                    return (software.amazon.awssdk.services.glue.model.Table)this.stats.getGetTable().call(() -> this.glueClient.getTable(x -> x.databaseName(tableName.getSchemaName()).name(tableName.getTableName())).table());
                }
                catch (EntityNotFoundException e) {
                    throw new TableNotFoundException(tableName, (Throwable)e);
                }
                catch (SdkException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
                }
            });
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Get table request failed: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)((Object)e))), e.getCause());
        }
    }

    private Stream<software.amazon.awssdk.services.glue.model.Table> getGlueTablesWithExceptionHandling(final String glueNamespace) {
        return Streams.stream((Iterator)new AbstractIterator<software.amazon.awssdk.services.glue.model.Table>(this){
            private Iterator<software.amazon.awssdk.services.glue.model.Table> delegate;
            final /* synthetic */ TrinoGlueCatalog this$0;
            {
                this.this$0 = this$0;
            }

            protected software.amazon.awssdk.services.glue.model.Table computeNext() {
                boolean firstCall = this.delegate == null;
                try {
                    if (this.delegate == null) {
                        this.delegate = this.this$0.getGlueTables(glueNamespace).iterator();
                    }
                    if (!this.delegate.hasNext()) {
                        return (software.amazon.awssdk.services.glue.model.Table)this.endOfData();
                    }
                    return this.delegate.next();
                }
                catch (EntityNotFoundException e) {
                    return (software.amazon.awssdk.services.glue.model.Table)this.endOfData();
                }
                catch (AccessDeniedException e) {
                    if (!firstCall) {
                        LOG.warn((Throwable)e, "Permission denied when getting next batch of tables from namespace %s", new Object[]{glueNamespace});
                    }
                    return (software.amazon.awssdk.services.glue.model.Table)this.endOfData();
                }
                catch (SdkException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
                }
            }
        });
    }

    private Stream<software.amazon.awssdk.services.glue.model.Table> getGlueTables(String glueNamespace) {
        return (Stream)this.stats.getGetTables().call(() -> this.glueClient.getTablesPaginator(x -> x.databaseName(glueNamespace)).stream().map(GetTablesResponse::tableList).flatMap(Collection::stream));
    }

    private void createTable(String schemaName, TableInput tableInput) {
        this.glueTableCache.invalidateAll();
        this.stats.getCreateTable().call(() -> this.glueClient.createTable(x -> x.databaseName(schemaName).tableInput(tableInput)));
    }

    private void updateTable(String schemaName, TableInput tableInput) {
        this.glueTableCache.invalidateAll();
        this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(x -> x.databaseName(schemaName).tableInput(tableInput)));
    }

    private void deleteTable(String schema, String table) {
        this.glueTableCache.invalidateAll();
        this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(x -> x.databaseName(schema).name(table)));
    }

    private record MaterializedViewData(ConnectorMaterializedViewDefinition connectorMaterializedViewDefinition, Optional<String> storageMetadataLocation) {
        private MaterializedViewData {
            Objects.requireNonNull(connectorMaterializedViewDefinition, "connectorMaterializedViewDefinition is null");
            Objects.requireNonNull(storageMetadataLocation, "storageMetadataLocation is null");
        }
    }
}

