/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.security.UsingSystemSecurity;
import io.trino.plugin.iceberg.ForIcebergMetadata;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.catalog.glue.TrinoGlueCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import software.amazon.awssdk.services.glue.GlueClient;

public class TrinoGlueCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final boolean cacheTableMetadata;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final Optional<String> defaultSchemaLocation;
    private final GlueClient glueClient;
    private final boolean isUniqueTableLocation;
    private final boolean hideMaterializedViewStorageTable;
    private final GlueMetastoreStats stats;
    private final boolean isUsingSystemSecurity;
    private final Executor metadataFetchingExecutor;

    @Inject
    public TrinoGlueCatalogFactory(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, NodeVersion nodeVersion, GlueHiveMetastoreConfig glueConfig, IcebergConfig icebergConfig, IcebergGlueCatalogConfig catalogConfig, @UsingSystemSecurity boolean usingSystemSecurity, GlueMetastoreStats stats, GlueClient glueClient, @ForIcebergMetadata ExecutorService metadataExecutorService) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cacheTableMetadata = catalogConfig.isCacheTableMetadata();
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.trinoVersion = nodeVersion.toString();
        this.defaultSchemaLocation = glueConfig.getDefaultWarehouseDir();
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.isUniqueTableLocation = icebergConfig.isUniqueTableLocation();
        this.hideMaterializedViewStorageTable = icebergConfig.isHideMaterializedViewStorageTable();
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.isUsingSystemSecurity = usingSystemSecurity;
        this.metadataFetchingExecutor = icebergConfig.getMetadataParallelism() == 1 ? MoreExecutors.directExecutor() : new BoundedExecutor((Executor)metadataExecutorService, icebergConfig.getMetadataParallelism());
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        return new TrinoGlueCatalog(this.catalogName, this.fileSystemFactory, this.typeManager, this.cacheTableMetadata, this.tableOperationsProvider, this.trinoVersion, this.glueClient, this.stats, this.isUsingSystemSecurity, this.defaultSchemaLocation, this.isUniqueTableLocation, this.hideMaterializedViewStorageTable, this.metadataFetchingExecutor);
    }
}

