/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Verify;
import io.trino.annotation.NotThreadSafe;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.CreateTableException;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public abstract class AbstractMetastoreTableOperations
extends AbstractIcebergTableOperations {
    protected final CachingHiveMetastore metastore;

    protected AbstractMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        boolean isMaterializedViewStorageTable;
        if (invalidateCaches) {
            this.metastore.invalidateTable(this.database, this.tableName);
        }
        Table table = (isMaterializedViewStorageTable = IcebergTableName.isMaterializedViewStorage(this.tableName)) ? this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName)) : this.getTable();
        if (!isMaterializedViewStorageTable && (ViewReaderUtil.isTrinoView((Table)table) || ViewReaderUtil.isTrinoMaterializedView((Table)table))) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!isMaterializedViewStorageTable && !HiveUtil.isIcebergTable((Table)table)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)table.getParameters().get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        return metadataLocation;
    }

    @Override
    protected final void commitNewTable(TableMetadata metadata) {
        Verify.verify((boolean)this.version.isEmpty(), (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        String newMetadataLocation = this.writeNewMetadata(metadata, 0);
        Table table = Table.builder().setDatabaseName(this.database).setTableName(this.tableName).setOwner(this.owner).setTableType(TableType.EXTERNAL_TABLE.name()).withStorage(storage -> storage.setStorageFormat(ICEBERG_METASTORE_STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg".toUpperCase(Locale.ENGLISH)).apply(builder -> this.updateMetastoreTable((Table.Builder)builder, metadata, newMetadataLocation, Optional.empty())).build();
        PrincipalPrivileges privileges = this.owner.map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
        try {
            this.metastore.createTable(table, privileges);
        }
        catch (Exception e) {
            this.fileIo.deleteFile(newMetadataLocation);
            throw new CreateTableException(e, this.getSchemaTableName());
        }
    }

    protected Table.Builder updateMetastoreTable(Table.Builder builder, TableMetadata metadata, String metadataLocation, Optional<String> previousMetadataLocation) {
        builder.setDataColumns(AbstractMetastoreTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).setParameter("metadata_location", metadataLocation).setParameter("previous_metadata_location", previousMetadataLocation).setParameter("comment", Optional.ofNullable((String)metadata.properties().get("comment")));
        if (metadata.currentSnapshot() != null) {
            builder.setParameter("current-snapshot-id", String.valueOf(metadata.currentSnapshot().snapshotId())).setParameter("current-snapshot-timestamp-ms", String.valueOf(metadata.currentSnapshot().timestampMillis()));
        }
        return builder;
    }

    protected Table getTable() {
        return this.getTable(this.database, this.tableName);
    }

    protected Table getTable(String database, String tableName) {
        return (Table)this.metastore.getTable(database, tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }
}

