/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.annotation.NotThreadSafe;
import io.trino.hive.thrift.metastore.Table;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.hms.AbstractMetastoreTableOperations;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public class HiveMetastoreTableOperations
extends AbstractMetastoreTableOperations {
    private static final Logger log = Logger.get(HiveMetastoreTableOperations.class);
    private final ThriftMetastore thriftMetastore;
    private final boolean lockingEnabled;

    public HiveMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ThriftMetastore thriftMetastore, boolean lockingEnabled, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, metastore, session, database, table, owner, location);
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
        this.lockingEnabled = lockingEnabled;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        io.trino.metastore.Table currentTable = this.getTable();
        this.commitTableUpdate(currentTable, metadata, (table, newMetadataLocation) -> io.trino.metastore.Table.builder((io.trino.metastore.Table)table).apply(builder -> this.updateMetastoreTable((Table.Builder)builder, metadata, (String)newMetadataLocation, Optional.of(this.currentMetadataLocation))).build());
    }

    @Override
    protected final void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        io.trino.metastore.Table materializedView = this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName));
        this.commitTableUpdate(materializedView, metadata, (table, newMetadataLocation) -> io.trino.metastore.Table.builder((io.trino.metastore.Table)table).apply(builder -> builder.setParameter("metadata_location", newMetadataLocation).setParameter("previous_metadata_location", this.currentMetadataLocation).setParameter("current-snapshot-id", String.valueOf(metadata.currentSnapshot().snapshotId())).setParameter("current-snapshot-timestamp-ms", String.valueOf(metadata.currentSnapshot().timestampMillis()))).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTableUpdate(io.trino.metastore.Table table, TableMetadata metadata, BiFunction<io.trino.metastore.Table, String, io.trino.metastore.Table> tableUpdateFunction) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        boolean lockingEnabled = Boolean.parseBoolean(table.getParameters().getOrDefault("engine.hive.lock-enabled", Boolean.toString(this.lockingEnabled)));
        HiveLock hiveLock = lockingEnabled ? new ThriftMetastoreLock(table) : new NoLock();
        hiveLock.acquire();
        try {
            io.trino.metastore.Table currentTable = ThriftMetastoreUtil.fromMetastoreApiTable((Table)((Table)this.thriftMetastore.getTable(this.database, table.getTableName()).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()))));
            Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
            String metadataLocation = IcebergUtil.fixBrokenMetadataLocation((String)currentTable.getParameters().get("metadata_location"));
            if (!this.currentMetadataLocation.equals(metadataLocation)) {
                throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
            }
            io.trino.metastore.Table updatedTable = tableUpdateFunction.apply(table, newMetadataLocation);
            PrincipalPrivileges privileges = table.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
            try {
                this.metastore.replaceTable(table.getDatabaseName(), table.getTableName(), updatedTable, privileges, HiveMetastoreTableOperations.environmentContext(metadataLocation));
            }
            catch (RuntimeException e) {
                throw new CommitStateUnknownException((Throwable)e);
            }
        }
        finally {
            hiveLock.release();
        }
        this.shouldRefresh = true;
    }

    private static Map<String, String> environmentContext(String metadataLocation) {
        if (metadataLocation == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.builder().put((Object)"expected_parameter_key", (Object)"metadata_location").put((Object)"expected_parameter_value", (Object)metadataLocation).buildOrThrow();
    }

    private class ThriftMetastoreLock
    implements HiveLock {
        private long lockId;
        private final io.trino.metastore.Table table;

        public ThriftMetastoreLock(io.trino.metastore.Table table) {
            this.table = Objects.requireNonNull(table, "table is null");
        }

        @Override
        public void acquire() {
            this.lockId = HiveMetastoreTableOperations.this.thriftMetastore.acquireTableExclusiveLock(new AcidTransactionOwner(HiveMetastoreTableOperations.this.session.getUser()), HiveMetastoreTableOperations.this.session.getQueryId(), this.table.getDatabaseName(), this.table.getTableName());
        }

        @Override
        public void release() {
            try {
                HiveMetastoreTableOperations.this.thriftMetastore.releaseTableLock(this.lockId);
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Failed to release lock %s when committing to table %s", new Object[]{this.lockId, this.table.getTableName()});
            }
        }
    }

    private static class NoLock
    implements HiveLock {
        private NoLock() {
        }

        @Override
        public void acquire() {
        }

        @Override
        public void release() {
        }
    }

    private static interface HiveLock {
        public void acquire();

        public void release();
    }
}

