/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.hms.HiveMetastoreTableOperations;
import io.trino.plugin.iceberg.catalog.hms.IcebergHiveCatalogConfig;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.io.FileIO;

public class HiveMetastoreTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ThriftMetastoreFactory thriftMetastoreFactory;
    private final boolean lockingEnabled;

    @Inject
    public HiveMetastoreTableOperationsProvider(TrinoFileSystemFactory fileSystemFactory, ThriftMetastoreFactory thriftMetastoreFactory, IcebergHiveCatalogConfig metastoreConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.thriftMetastoreFactory = Objects.requireNonNull(thriftMetastoreFactory, "thriftMetastoreFactory is null");
        this.lockingEnabled = metastoreConfig.getLockingEnabled();
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new HiveMetastoreTableOperations((FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session), IcebergSessionProperties.isUseFileSizeFromMetadata(session)), ((TrinoHiveCatalog)catalog).getMetastore(), this.thriftMetastoreFactory.createMetastore(Optional.of(session.getIdentity())), this.lockingEnabled, session, database, table, owner, location);
    }
}

