/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.TableInfo;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.view.ReplaceViewVersion;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.UpdateViewProperties;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;

public class TrinoJdbcCatalog
extends AbstractTrinoCatalog {
    private static final Logger LOG = Logger.get(TrinoJdbcCatalog.class);
    private static final int PER_QUERY_CACHE_SIZE = 1000;
    private final JdbcCatalog jdbcCatalog;
    private final IcebergJdbcClient jdbcClient;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final String defaultWarehouseDir;
    private final Cache<SchemaTableName, TableMetadata> tableMetadataCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();

    public TrinoJdbcCatalog(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, JdbcCatalog jdbcCatalog, IcebergJdbcClient jdbcClient, TrinoFileSystemFactory fileSystemFactory, boolean useUniqueTableLocation, String defaultWarehouseDir) {
        super(catalogName, typeManager, tableOperationsProvider, fileSystemFactory, useUniqueTableLocation);
        this.jdbcCatalog = Objects.requireNonNull(jdbcCatalog, "jdbcCatalog is null");
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.defaultWarehouseDir = Objects.requireNonNull(defaultWarehouseDir, "defaultWarehouseDir is null");
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        return this.jdbcCatalog.namespaceExists(Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return (List)this.jdbcCatalog.listNamespaces().stream().map(namespace -> namespace.level(0).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        return (Map)this.jdbcCatalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{namespace})).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        try {
            this.jdbcCatalog.createNamespace(Namespace.of((String[])new String[]{namespace}), Maps.transformValues(properties, String.class::cast));
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create a namespace " + namespace, (Throwable)e);
        }
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        this.jdbcCatalog.dropNamespace(Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace) {
        List<String> namespaces = this.listNamespaces(session, namespace);
        HashMap tablesListBuilder = new HashMap();
        for (String schemaName : namespaces) {
            try {
                TrinoJdbcCatalog.listTableIdentifiers(schemaName, () -> this.jdbcCatalog.listTables(Namespace.of((String[])new String[]{schemaName}))).stream().map(tableId -> SchemaTableName.schemaTableName((String)schemaName, (String)tableId.name())).forEach(schemaTableName -> tablesListBuilder.put(schemaTableName, new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.TABLE)));
                TrinoJdbcCatalog.listTableIdentifiers(schemaName, () -> this.jdbcCatalog.listViews(Namespace.of((String[])new String[]{schemaName}))).stream().map(tableId -> SchemaTableName.schemaTableName((String)schemaName, (String)tableId.name())).forEach(schemaTableName -> tablesListBuilder.put(schemaTableName, new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.OTHER_VIEW)));
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {}
        }
        return ImmutableList.copyOf(tablesListBuilder.values());
    }

    @Override
    public List<SchemaTableName> listIcebergTables(ConnectorSession session, Optional<String> namespace) {
        List<String> namespaces = this.listNamespaces(session, namespace);
        HashSet tablesListBuilder = new HashSet();
        for (String schemaName : namespaces) {
            try {
                TrinoJdbcCatalog.listTableIdentifiers(schemaName, () -> this.jdbcCatalog.listTables(Namespace.of((String[])new String[]{schemaName}))).stream().map(tableId -> SchemaTableName.schemaTableName((String)schemaName, (String)tableId.name())).forEach(tablesListBuilder::add);
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {}
        }
        return ImmutableList.copyOf(tablesListBuilder);
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        List<String> namespaces = this.listNamespaces(session, namespace);
        ImmutableList.Builder viewNames = ImmutableList.builder();
        for (String ns : namespaces) {
            TrinoJdbcCatalog.listTableIdentifiers(ns, () -> this.jdbcCatalog.listViews(Namespace.of((String[])new String[]{ns}))).stream().map(id -> SchemaTableName.schemaTableName((String)id.namespace().toString(), (String)id.name())).forEach(arg_0 -> ((ImmutableList.Builder)viewNames).add(arg_0));
        }
        return viewNames.build();
    }

    private static List<TableIdentifier> listTableIdentifiers(String namespace, Supplier<List<TableIdentifier>> tableIdentifiersProvider) {
        try {
            return tableIdentifiersProvider.get();
        }
        catch (NoSuchNamespaceException noSuchNamespaceException) {
        }
        catch (UncheckedInterruptedException | UncheckedSQLException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list tables from namespace: " + namespace, e);
        }
        return ImmutableList.of();
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent() && this.namespaceExists(session, namespace.get())) {
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, Optional<String> location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateOrReplaceTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName tableName, TableMetadata tableMetadata) {
        this.jdbcClient.createTable(tableName.getSchemaName(), tableName.getTableName(), tableMetadata.metadataFileLocation());
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName tableName) {
        if (!this.jdbcCatalog.dropTable(TrinoJdbcCatalog.toIdentifier(tableName), false)) {
            throw new TableNotFoundException(tableName);
        }
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = this.loadTable(session, schemaTableName);
        this.jdbcCatalog.dropTable(TrinoJdbcCatalog.toIdentifier(schemaTableName), false);
        try {
            CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e, "Failed to delete table data referenced by metadata");
        }
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.location());
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Optional<String> metadataLocation = this.jdbcClient.getMetadataLocation(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (!this.jdbcCatalog.dropTable(TrinoJdbcCatalog.toIdentifier(schemaTableName), false)) {
            throw new TableNotFoundException(schemaTableName);
        }
        if (metadataLocation.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Could not find metadata_location for table %s", schemaTableName));
        }
        String tableLocation = metadataLocation.get().replaceFirst("/metadata/[^/]*$", "");
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, tableLocation);
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        try {
            this.jdbcCatalog.renameTable(TrinoJdbcCatalog.toIdentifier(from), TrinoJdbcCatalog.toIdentifier(to));
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to rename table from %s to %s".formatted(from, to), (Throwable)e);
        }
        this.invalidateTableCache(from);
    }

    @Override
    public BaseTable loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata;
        try {
            metadata = (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)schemaTableName, () -> IcebergUtil.loadIcebergTable(this, this.tableOperationsProvider, session, schemaTableName).operations().current());
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        return ImmutableMap.of();
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName schemaViewName, Optional<String> comment) {
        View view = Optional.ofNullable(this.jdbcCatalog.loadView(TrinoJdbcCatalog.toIdentifier(schemaViewName))).orElseThrow(() -> new ViewNotFoundException(schemaViewName));
        UpdateViewProperties updateViewProperties = view.updateProperties();
        comment.ifPresentOrElse(value -> updateViewProperties.set("comment", value), () -> updateViewProperties.remove("comment"));
        updateViewProperties.commit();
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        View view = Optional.ofNullable(this.jdbcCatalog.loadView(TrinoJdbcCatalog.toIdentifier(schemaViewName))).orElseThrow(() -> new ViewNotFoundException(schemaViewName));
        ViewVersion current = view.currentVersion();
        Schema updatedSchema = IcebergUtil.updateColumnComment(view.schema(), columnName, comment.orElse(null));
        ReplaceViewVersion replaceViewVersion = (ReplaceViewVersion)((ReplaceViewVersion)((ReplaceViewVersion)view.replaceVersion().withSchema(updatedSchema)).withDefaultCatalog(current.defaultCatalog())).withDefaultNamespace(current.defaultNamespace());
        for (ViewRepresentation representation : view.currentVersion().representations()) {
            if (!(representation instanceof SQLViewRepresentation)) continue;
            SQLViewRepresentation sqlViewRepresentation = (SQLViewRepresentation)representation;
            replaceViewVersion.withQuery(sqlViewRepresentation.dialect(), sqlViewRepresentation.sql());
        }
        replaceViewVersion.commit();
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Namespace namespace = Namespace.of((String[])new String[]{schemaTableName.getSchemaName()});
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        Optional<String> databaseLocation = Optional.empty();
        if (this.jdbcCatalog.namespaceExists(namespace)) {
            databaseLocation = Optional.ofNullable((String)this.jdbcCatalog.loadNamespaceMetadata(namespace).get("location"));
        }
        String schemaLocation = databaseLocation.orElseGet(() -> Locations.appendPath((String)this.defaultWarehouseDir, (String)schemaTableName.getSchemaName()));
        return Locations.appendPath((String)schemaLocation, (String)tableName);
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        definition.getOwner().ifPresent(owner -> properties.put((Object)"trino.run-as-owner", owner));
        definition.getComment().ifPresent(comment -> properties.put((Object)"comment", comment));
        Schema schema = IcebergUtil.schemaFromViewColumns(this.typeManager, definition.getColumns());
        ViewBuilder viewBuilder = this.jdbcCatalog.buildView(TrinoJdbcCatalog.toIdentifier(schemaViewName));
        viewBuilder = ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewBuilder.withSchema(schema)).withQuery("trino", definition.getOriginalSql())).withDefaultNamespace(Namespace.of((String[])new String[]{schemaViewName.getSchemaName()}))).withDefaultCatalog((String)definition.getCatalog().orElse(null))).withProperties((Map)properties.buildOrThrow()).withLocation(this.defaultTableLocation(session, schemaViewName));
        if (replace) {
            viewBuilder.createOrReplace();
        } else {
            viewBuilder.create();
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.jdbcCatalog.renameView(TrinoJdbcCatalog.toIdentifier(source), TrinoJdbcCatalog.toIdentifier(target));
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        this.jdbcCatalog.dropView(TrinoJdbcCatalog.toIdentifier(schemaViewName));
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (Namespace ns : this.jdbcCatalog.listNamespaces()) {
            for (TableIdentifier restView : this.jdbcCatalog.listViews(ns)) {
                SchemaTableName schemaTableName = SchemaTableName.schemaTableName((String)restView.namespace().toString(), (String)restView.name());
                try {
                    this.getView(session, schemaTableName).ifPresent(view -> views.put((Object)schemaTableName, view));
                }
                catch (TrinoException e) {
                    if (e.getErrorCode().equals((Object)IcebergErrorCode.ICEBERG_UNSUPPORTED_VIEW_DIALECT.toErrorCode())) {
                        LOG.debug((Throwable)e, "Skip unsupported view dialect: %s", new Object[]{schemaTableName});
                        continue;
                    }
                    throw e;
                }
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewIdentifier) {
        if (!this.jdbcCatalog.viewExists(TrinoJdbcCatalog.toIdentifier(viewIdentifier))) {
            return Optional.empty();
        }
        return Optional.of(this.jdbcCatalog.loadView(TrinoJdbcCatalog.toIdentifier(viewIdentifier))).flatMap(view -> {
            SQLViewRepresentation sqlView = view.sqlFor("trino");
            if (!sqlView.dialect().equalsIgnoreCase("trino")) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_UNSUPPORTED_VIEW_DIALECT, "Cannot read unsupported dialect '%s' for view '%s'".formatted(sqlView.dialect(), viewIdentifier));
            }
            Optional<String> comment = Optional.ofNullable((String)view.properties().get("comment"));
            List<ConnectorViewDefinition.ViewColumn> viewColumns = IcebergUtil.viewColumnsFromSchema(this.typeManager, view.schema());
            ViewVersion currentVersion = view.currentVersion();
            Optional<String> catalog = Optional.ofNullable(currentVersion.defaultCatalog());
            Optional<Object> schema = Optional.empty();
            if (catalog.isPresent() && !currentVersion.defaultNamespace().isEmpty()) {
                schema = Optional.of(currentVersion.defaultNamespace().toString());
            }
            Optional<String> owner = Optional.ofNullable((String)view.properties().get("trino.run-as-owner"));
            return Optional.of(new ConnectorViewDefinition(sqlView.sql(), catalog, schema, viewColumns, comment, owner, owner.isEmpty(), null));
        });
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        return Optional.empty();
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The Iceberg JDBC catalog does not support materialized views");
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateMaterializedViewColumnComment is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        return Optional.empty();
    }

    @Override
    public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "getMaterializedViewProperties is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        return Optional.empty();
    }

    @Override
    protected void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableMetadataCache.invalidate((Object)schemaTableName);
    }

    private static TableIdentifier toIdentifier(SchemaTableName table) {
        return TableIdentifier.of((String[])new String[]{table.getSchemaName(), table.getTableName()});
    }
}

