/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.CatalogProperties;

@DefunctConfig(value={"iceberg.rest-catalog.parent-namespace"})
public class IcebergRestCatalogConfig {
    private URI restUri;
    private Optional<String> prefix = Optional.empty();
    private Optional<String> warehouse = Optional.empty();
    private boolean nestedNamespaceEnabled;
    private Security security = Security.NONE;
    private SessionType sessionType = SessionType.NONE;
    private Duration sessionTimeout = new Duration((double)CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT, TimeUnit.MILLISECONDS);
    private boolean vendedCredentialsEnabled;
    private boolean viewEndpointsEnabled = true;
    private boolean sigV4Enabled;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    public URI getBaseUri() {
        return this.restUri;
    }

    @Config(value="iceberg.rest-catalog.uri")
    @ConfigDescription(value="The URI to the REST server")
    public IcebergRestCatalogConfig setBaseUri(String uri) {
        if (uri != null) {
            this.restUri = URI.create(uri);
        }
        return this;
    }

    public Optional<String> getPrefix() {
        return this.prefix;
    }

    @Config(value="iceberg.rest-catalog.prefix")
    @ConfigDescription(value="The prefix for the resource path to use with the REST catalog server")
    public IcebergRestCatalogConfig setPrefix(String prefix) {
        this.prefix = Optional.ofNullable(prefix);
        return this;
    }

    public Optional<String> getWarehouse() {
        return this.warehouse;
    }

    @Config(value="iceberg.rest-catalog.warehouse")
    @ConfigDescription(value="The warehouse location/identifier to use with the REST catalog server")
    public IcebergRestCatalogConfig setWarehouse(String warehouse) {
        this.warehouse = Optional.ofNullable(warehouse);
        return this;
    }

    public boolean isNestedNamespaceEnabled() {
        return this.nestedNamespaceEnabled;
    }

    @Config(value="iceberg.rest-catalog.nested-namespace-enabled")
    @ConfigDescription(value="Support querying objects under nested namespace")
    public IcebergRestCatalogConfig setNestedNamespaceEnabled(boolean nestedNamespaceEnabled) {
        this.nestedNamespaceEnabled = nestedNamespaceEnabled;
        return this;
    }

    @NotNull
    public Security getSecurity() {
        return this.security;
    }

    @Config(value="iceberg.rest-catalog.security")
    @ConfigDescription(value="Authorization protocol to use when communicating with the REST catalog server")
    public IcebergRestCatalogConfig setSecurity(Security security) {
        this.security = security;
        return this;
    }

    @NotNull
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Config(value="iceberg.rest-catalog.session")
    @ConfigDescription(value="Type of REST catalog sessionType to use when communicating with REST catalog Server")
    public IcebergRestCatalogConfig setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="iceberg.rest-catalog.session-timeout")
    @ConfigDescription(value="Duration to keep authentication session in cache")
    public IcebergRestCatalogConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public boolean isVendedCredentialsEnabled() {
        return this.vendedCredentialsEnabled;
    }

    @Config(value="iceberg.rest-catalog.vended-credentials-enabled")
    @ConfigDescription(value="Use credentials provided by the REST backend for file system access")
    public IcebergRestCatalogConfig setVendedCredentialsEnabled(boolean vendedCredentialsEnabled) {
        this.vendedCredentialsEnabled = vendedCredentialsEnabled;
        return this;
    }

    public boolean isViewEndpointsEnabled() {
        return this.viewEndpointsEnabled;
    }

    @Config(value="iceberg.rest-catalog.view-endpoints-enabled")
    @ConfigDescription(value="Enable view endpoints")
    public IcebergRestCatalogConfig setViewEndpointsEnabled(boolean viewEndpointsEnabled) {
        this.viewEndpointsEnabled = viewEndpointsEnabled;
        return this;
    }

    public boolean isSigV4Enabled() {
        return this.sigV4Enabled;
    }

    @Config(value="iceberg.rest-catalog.sigv4-enabled")
    @ConfigDescription(value="Enable AWS Signature version 4 (SigV4)")
    public IcebergRestCatalogConfig setSigV4Enabled(boolean sigV4Enabled) {
        this.sigV4Enabled = sigV4Enabled;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="iceberg.rest-catalog.case-insensitive-name-matching")
    @ConfigDescription(value="Match object names case-insensitively")
    public IcebergRestCatalogConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="iceberg.rest-catalog.case-insensitive-name-matching.cache-ttl")
    @ConfigDescription(value="Duration to keep case insensitive object mapping prior to eviction")
    public IcebergRestCatalogConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    public static enum Security {
        NONE,
        OAUTH2;

    }

    public static enum SessionType {
        NONE,
        USER;

    }
}

