/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import java.net.URI;
import java.util.Optional;

public class OAuth2SecurityConfig {
    private String credential;
    private String scope;
    private String token;
    private URI serverUri;
    private boolean tokenRefreshEnabled = true;

    public Optional<String> getCredential() {
        return Optional.ofNullable(this.credential);
    }

    @Config(value="iceberg.rest-catalog.oauth2.credential")
    @ConfigDescription(value="The credential to exchange for a token in the OAuth2 client credentials flow with the server")
    @ConfigSecuritySensitive
    public OAuth2SecurityConfig setCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Config(value="iceberg.rest-catalog.oauth2.scope")
    @ConfigDescription(value="The scope which will be used for interactions with the server")
    public OAuth2SecurityConfig setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Config(value="iceberg.rest-catalog.oauth2.token")
    @ConfigDescription(value="The Bearer token which will be used for interactions with the server")
    @ConfigSecuritySensitive
    public OAuth2SecurityConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public Optional<URI> getServerUri() {
        return Optional.ofNullable(this.serverUri);
    }

    @Config(value="iceberg.rest-catalog.oauth2.server-uri")
    @ConfigDescription(value="The endpoint to retrieve access token from OAuth2 Server")
    public OAuth2SecurityConfig setServerUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    public boolean isTokenRefreshEnabled() {
        return this.tokenRefreshEnabled;
    }

    @Config(value="iceberg.rest-catalog.oauth2.token-refresh-enabled")
    @ConfigDescription(value="Controls whether a token should be refreshed if information about its expiration time is available")
    public OAuth2SecurityConfig setTokenRefreshEnabled(boolean tokenRefreshEnabled) {
        this.tokenRefreshEnabled = tokenRefreshEnabled;
        return this;
    }

    @AssertTrue(message="OAuth2 requires a credential or token")
    public @AssertTrue(message="OAuth2 requires a credential or token") boolean credentialOrTokenPresent() {
        return this.credential != null || this.token != null;
    }

    @AssertTrue(message="Scope is applicable only when using credential")
    public @AssertTrue(message="Scope is applicable only when using credential") boolean scopePresentOnlyWithCredential() {
        return this.token == null || this.scope == null;
    }
}

