/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;

public class SigV4AwsCredentialProvider
implements AwsCredentialsProvider {
    static final String AWS_STS_ACCESS_KEY_ID = "aws_sts_access_key_id";
    static final String AWS_STS_SECRET_ACCESS_KEY = "aws_sts_secret_access_key";
    static final String AWS_STS_SIGNER_REGION = "aws_sts_signer_region";
    static final String AWS_STS_REGION = "aws_sts_region";
    static final String AWS_STS_ENDPOINT = "aws_sts_endpoint";
    static final String AWS_IAM_ROLE = "aws_iam_role";
    static final String AWS_ROLE_EXTERNAL_ID = "aws_external_id";
    static final String AWS_IAM_ROLE_SESSION_NAME = "aws_iam_role_session_name";
    private final AwsCredentialsProvider delegate;

    public SigV4AwsCredentialProvider(AwsCredentialsProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public static SigV4AwsCredentialProvider create(Map<String, String> properties) {
        if (properties.containsKey(AWS_IAM_ROLE)) {
            String accessKey = properties.get(AWS_STS_ACCESS_KEY_ID);
            String secretAccessKey = properties.get(AWS_STS_SECRET_ACCESS_KEY);
            Optional<AwsCredentialsProvider> staticCredentialsProvider = SigV4AwsCredentialProvider.createStaticCredentialsProvider(accessKey, secretAccessKey);
            return new SigV4AwsCredentialProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest(request -> request.roleArn((String)properties.get(AWS_IAM_ROLE)).roleSessionName(AWS_IAM_ROLE_SESSION_NAME).externalId((String)properties.get(AWS_ROLE_EXTERNAL_ID))).stsClient(SigV4AwsCredentialProvider.createStsClient(properties.get(AWS_STS_ENDPOINT), properties.get(AWS_STS_REGION), properties.get(AWS_STS_SIGNER_REGION), staticCredentialsProvider))).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build());
        }
        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "IAM role configs are not configured");
    }

    public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity(Consumer<ResolveIdentityRequest.Builder> consumer) {
        return this.delegate.resolveIdentity(consumer);
    }

    public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity() {
        return this.delegate.resolveIdentity();
    }

    public AwsCredentials resolveCredentials() {
        return this.delegate.resolveCredentials();
    }

    public Class<AwsCredentialsIdentity> identityType() {
        return this.delegate.identityType();
    }

    public CompletableFuture<AwsCredentialsIdentity> resolveIdentity(ResolveIdentityRequest request) {
        return this.delegate.resolveIdentity(request);
    }

    private static Optional<AwsCredentialsProvider> createStaticCredentialsProvider(String accessKey, String secretKey) {
        if (accessKey != null || secretKey != null) {
            return Optional.of(StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)));
        }
        return Optional.empty();
    }

    private static StsClient createStsClient(String stsEndpoint, String stsRegion, String region, Optional<AwsCredentialsProvider> credentialsProvider) {
        StsClientBuilder sts = StsClient.builder();
        Optional.ofNullable(stsEndpoint).map(URI::create).ifPresent(arg_0 -> ((StsClientBuilder)sts).endpointOverride(arg_0));
        Optional.ofNullable(stsRegion).or(() -> Optional.ofNullable(region)).map(Region::of).ifPresent(arg_0 -> ((StsClientBuilder)sts).region(arg_0));
        credentialsProvider.ifPresent(arg_0 -> ((StsClientBuilder)sts).credentialsProvider(arg_0));
        return (StsClient)sts.build();
    }
}

