/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.plugin.iceberg.catalog.rest.AwsProperties;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogSigV4Config;
import io.trino.plugin.iceberg.catalog.rest.SigV4AwsCredentialProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SigV4AwsProperties
implements AwsProperties {
    private static final String CLIENT_CREDENTIAL_PROVIDER_PREFIX = "client.credentials-provider.";
    private static final String CLIENT_CREDENTIAL_AWS_ACCESS_KEY_ID = "client.credentials-provider.aws_sts_access_key_id";
    private static final String CLIENT_CREDENTIAL_AWS_SECRET_ACCESS_KEY = "client.credentials-provider.aws_sts_secret_access_key";
    private static final String CLIENT_CREDENTIAL_AWS_SIGNER_REGION = "client.credentials-provider.aws_sts_signer_region";
    private static final String CLIENT_CREDENTIAL_AWS_STS_REGION = "client.credentials-provider.aws_sts_region";
    private static final String CLIENT_CREDENTIAL_AWS_STS_ENDPOINT = "client.credentials-provider.aws_sts_endpoint";
    private static final String CLIENT_CREDENTIAL_AWS_IAM_ROLE = "client.credentials-provider.aws_iam_role";
    private static final String CLIENT_CREDENTIAL_AWS_ROLE_EXTERNAL_ID = "client.credentials-provider.aws_external_id";
    private static final String CLIENT_CREDENTIAL_AWS_IAM_ROLE_SESSION_NAME = "client.credentials-provider.aws_iam_role_session_name";
    private final Map<String, String> properties;

    @Inject
    public SigV4AwsProperties(IcebergRestCatalogSigV4Config sigV4Config, S3FileSystemConfig s3Config) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"rest.auth.type", (Object)"sigv4").put((Object)"rest.signing-name", (Object)sigV4Config.getSigningName()).put((Object)"rest.signing-region", (Object)Objects.requireNonNull(s3Config.getRegion(), "s3.region is null")).put((Object)"rest-metrics-reporting-enabled", (Object)"false");
        if (s3Config.getIamRole() != null) {
            builder.put((Object)"client.credentials-provider", (Object)SigV4AwsCredentialProvider.class.getName()).put((Object)CLIENT_CREDENTIAL_AWS_IAM_ROLE, (Object)s3Config.getIamRole()).put((Object)CLIENT_CREDENTIAL_AWS_IAM_ROLE_SESSION_NAME, (Object)"trino-iceberg-rest-catalog").put((Object)CLIENT_CREDENTIAL_AWS_SIGNER_REGION, (Object)s3Config.getRegion());
            Optional.ofNullable(s3Config.getExternalId()).ifPresent(externalId -> builder.put((Object)CLIENT_CREDENTIAL_AWS_ROLE_EXTERNAL_ID, externalId));
            Optional.ofNullable(s3Config.getStsRegion()).ifPresent(stsRegion -> builder.put((Object)CLIENT_CREDENTIAL_AWS_STS_REGION, stsRegion));
            Optional.ofNullable(s3Config.getAwsAccessKey()).ifPresent(accessKey -> builder.put((Object)CLIENT_CREDENTIAL_AWS_ACCESS_KEY_ID, accessKey));
            Optional.ofNullable(s3Config.getAwsSecretKey()).ifPresent(secretAccessKey -> builder.put((Object)CLIENT_CREDENTIAL_AWS_SECRET_ACCESS_KEY, secretAccessKey));
            Optional.ofNullable(s3Config.getStsEndpoint()).ifPresent(endpoint -> builder.put((Object)CLIENT_CREDENTIAL_AWS_STS_ENDPOINT, endpoint));
        } else {
            builder.put((Object)"rest.access-key-id", (Object)Objects.requireNonNull(s3Config.getAwsAccessKey(), "s3.aws-access-key is null")).put((Object)"rest.secret-access-key", (Object)Objects.requireNonNull(s3Config.getAwsSecretKey(), "s3.aws-secret-key is null"));
        }
        this.properties = builder.buildOrThrow();
    }

    @Override
    public Map<String, String> get() {
        return this.properties;
    }
}

