/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.jsonwebtoken.impl.DefaultJwtBuilder;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Locations;
import io.trino.metastore.TableInfo;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.view.ReplaceViewVersion;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.UpdateViewProperties;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;

public class TrinoRestCatalog
implements TrinoCatalog {
    private static final Logger log = Logger.get(TrinoRestCatalog.class);
    private static final int PER_QUERY_CACHE_SIZE = 1000;
    private static final String NAMESPACE_SEPARATOR = ".";
    private final RESTSessionCatalog restSessionCatalog;
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    private final IcebergRestCatalogConfig.SessionType sessionType;
    private final Map<String, String> credentials;
    private final boolean nestedNamespaceEnabled;
    private final String trinoVersion;
    private final boolean useUniqueTableLocation;
    private final boolean caseInsensitiveNameMatching;
    private final Cache<Namespace, Namespace> remoteNamespaceMappingCache;
    private final Cache<TableIdentifier, TableIdentifier> remoteTableMappingCache;
    private final Cache<SchemaTableName, BaseTable> tableCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();

    public TrinoRestCatalog(RESTSessionCatalog restSessionCatalog, CatalogName catalogName, IcebergRestCatalogConfig.SessionType sessionType, Map<String, String> credentials, boolean nestedNamespaceEnabled, String trinoVersion, TypeManager typeManager, boolean useUniqueTableLocation, boolean caseInsensitiveNameMatching, Cache<Namespace, Namespace> remoteNamespaceMappingCache, Cache<TableIdentifier, TableIdentifier> remoteTableMappingCache) {
        this.restSessionCatalog = Objects.requireNonNull(restSessionCatalog, "restSessionCatalog is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.sessionType = Objects.requireNonNull(sessionType, "sessionType is null");
        this.credentials = ImmutableMap.copyOf(Objects.requireNonNull(credentials, "credentials is null"));
        this.nestedNamespaceEnabled = nestedNamespaceEnabled;
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        this.remoteNamespaceMappingCache = Objects.requireNonNull(remoteNamespaceMappingCache, "remoteNamespaceMappingCache is null");
        this.remoteTableMappingCache = Objects.requireNonNull(remoteTableMappingCache, "remoteTableMappingCache is null");
    }

    @Override
    public Optional<String> getNamespaceSeparator() {
        return Optional.of(NAMESPACE_SEPARATOR);
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        try {
            return this.restSessionCatalog.namespaceExists(this.convert(session), this.toRemoteNamespace(session, this.toNamespace(namespace)));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to check namespace '%s'".formatted(namespace), (Throwable)e);
        }
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        if (this.nestedNamespaceEnabled) {
            return this.collectNamespaces(session, Namespace.empty());
        }
        try {
            return (List)this.restSessionCatalog.listNamespaces(this.convert(session)).stream().map(this::toSchemaName).collect(ImmutableList.toImmutableList());
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list namespaces", (Throwable)e);
        }
    }

    private List<String> collectNamespaces(ConnectorSession session, Namespace parentNamespace) {
        try {
            return (List)this.restSessionCatalog.listNamespaces(this.convert(session), parentNamespace).stream().flatMap(childNamespace -> Stream.concat(Stream.of(childNamespace.toString()), this.collectNamespaces(session, (Namespace)childNamespace).stream())).collect(ImmutableList.toImmutableList());
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list namespaces", (Throwable)e);
        }
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.restSessionCatalog.dropNamespace(this.convert(session), this.toRemoteNamespace(session, this.toNamespace(namespace)));
        }
        catch (NoSuchNamespaceException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to drop namespace '%s'".formatted(namespace), (Throwable)e);
        }
        if (this.caseInsensitiveNameMatching) {
            this.remoteNamespaceMappingCache.invalidate((Object)this.toNamespace(namespace));
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            return ImmutableMap.copyOf((Map)this.restSessionCatalog.loadNamespaceMetadata(this.convert(session), this.toRemoteNamespace(session, this.toNamespace(namespace))));
        }
        catch (NoSuchNamespaceException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to load metadata for namespace '%s'".formatted(namespace), (Throwable)e);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        try {
            this.restSessionCatalog.createNamespace(this.convert(session), this.toNamespace(namespace), Maps.transformValues(properties, property -> {
                if (property instanceof String) {
                    String stringProperty = (String)property;
                    return stringProperty;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Non-string properties are not support for Iceberg REST catalog");
            }));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create namespace '%s'".formatted(namespace), (Throwable)e);
        }
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg REST catalog");
    }

    @Override
    public List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace) {
        SessionCatalog.SessionContext sessionContext = this.convert(session);
        List<Namespace> namespaces = this.listNamespaces(session, namespace);
        ImmutableList.Builder tables = ImmutableList.builder();
        for (Namespace restNamespace : namespaces) {
            TrinoRestCatalog.listTableIdentifiers(restNamespace, () -> {
                try {
                    return this.restSessionCatalog.listTables(sessionContext, this.toRemoteNamespace(session, restNamespace));
                }
                catch (RESTException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list tables", (Throwable)e);
                }
            }).stream().map(id -> new TableInfo(SchemaTableName.schemaTableName((String)this.toSchemaName(id.namespace()), (String)id.name()), TableInfo.ExtendedRelationType.TABLE)).forEach(arg_0 -> ((ImmutableList.Builder)tables).add(arg_0));
            TrinoRestCatalog.listTableIdentifiers(restNamespace, () -> {
                try {
                    return this.restSessionCatalog.listViews(sessionContext, this.toRemoteNamespace(session, restNamespace));
                }
                catch (RESTException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list views", (Throwable)e);
                }
            }).stream().map(id -> new TableInfo(SchemaTableName.schemaTableName((String)this.toSchemaName(id.namespace()), (String)id.name()), TableInfo.ExtendedRelationType.OTHER_VIEW)).forEach(arg_0 -> ((ImmutableList.Builder)tables).add(arg_0));
        }
        return tables.build();
    }

    @Override
    public List<SchemaTableName> listIcebergTables(ConnectorSession session, Optional<String> namespace) {
        SessionCatalog.SessionContext sessionContext = this.convert(session);
        List<Namespace> namespaces = this.listNamespaces(session, namespace);
        ImmutableList.Builder tables = ImmutableList.builder();
        for (Namespace restNamespace : namespaces) {
            TrinoRestCatalog.listTableIdentifiers(restNamespace, () -> {
                try {
                    return this.restSessionCatalog.listTables(sessionContext, this.toRemoteNamespace(session, restNamespace));
                }
                catch (RESTException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list tables", (Throwable)e);
                }
            }).stream().map(id -> SchemaTableName.schemaTableName((String)this.toSchemaName(id.namespace()), (String)id.name())).forEach(arg_0 -> ((ImmutableList.Builder)tables).add(arg_0));
        }
        return tables.build();
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        SessionCatalog.SessionContext sessionContext = this.convert(session);
        List<Namespace> namespaces = this.listNamespaces(session, namespace);
        ImmutableList.Builder viewNames = ImmutableList.builder();
        for (Namespace restNamespace : namespaces) {
            TrinoRestCatalog.listTableIdentifiers(restNamespace, () -> {
                try {
                    return this.restSessionCatalog.listViews(sessionContext, this.toRemoteNamespace(session, restNamespace));
                }
                catch (RESTException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list views", (Throwable)e);
                }
            }).stream().map(id -> SchemaTableName.schemaTableName((String)id.namespace().toString(), (String)id.name())).forEach(arg_0 -> ((ImmutableList.Builder)viewNames).add(arg_0));
        }
        return viewNames.build();
    }

    private static List<TableIdentifier> listTableIdentifiers(Namespace restNamespace, Supplier<List<TableIdentifier>> tableIdentifiersProvider) {
        try {
            return tableIdentifiersProvider.get();
        }
        catch (NoSuchNamespaceException noSuchNamespaceException) {
        }
        catch (ForbiddenException e) {
            log.debug((Throwable)e, "Failed to list tables from %s namespace because of insufficient permissions", new Object[]{restNamespace});
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to list tables from namespace: %s", restNamespace), (Throwable)e);
        }
        return ImmutableList.of();
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, Optional<String> location, Map<String, String> properties) {
        try {
            Catalog.TableBuilder tableBuilder = this.restSessionCatalog.buildTable(this.convert(session), this.toRemoteTable(session, schemaTableName, true), schema).withPartitionSpec(partitionSpec).withSortOrder(sortOrder).withProperties(properties);
            if (location.isEmpty()) {
                return tableBuilder.create().newTransaction();
            }
            return tableBuilder.withLocation(location.get()).createTransaction();
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create transaction", (Throwable)e);
        }
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        try {
            return this.restSessionCatalog.buildTable(this.convert(session), this.toRemoteTable(session, schemaTableName, true), schema).withPartitionSpec(partitionSpec).withSortOrder(sortOrder).withLocation(location).withProperties(properties).createOrReplaceTransaction();
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create transaction", (Throwable)e);
        }
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName tableName, TableMetadata tableMetadata) {
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)this.toRemoteNamespace(session, this.toNamespace(tableName.getSchemaName())), (String)tableName.getTableName());
        try {
            this.restSessionCatalog.registerTable(this.convert(session), tableIdentifier, tableMetadata.metadataFileLocation());
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to register table '%s'".formatted(tableName.getTableName()), (Throwable)e);
        }
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName tableName) {
        try {
            if (!this.restSessionCatalog.dropTable(this.convert(session), this.toRemoteTable(session, tableName, true))) {
                throw new TableNotFoundException(tableName);
            }
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to unregister table '%s'".formatted(tableName.getTableName()), (Throwable)e);
        }
        this.invalidateTableCache(tableName);
        this.invalidateTableMappingCache(tableName);
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        try {
            if (!this.restSessionCatalog.purgeTable(this.convert(session), this.toRemoteTable(session, schemaTableName, true))) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to drop table '%s'".formatted(schemaTableName));
            }
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to drop table '%s'".formatted(schemaTableName.getTableName()), (Throwable)e);
        }
        this.invalidateTableCache(schemaTableName);
        this.invalidateTableMappingCache(schemaTableName);
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop corrupted table %s from Iceberg REST catalog".formatted(schemaTableName));
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        try {
            this.restSessionCatalog.renameTable(this.convert(session), this.toRemoteTable(session, from, true), this.toRemoteTable(session, to, true));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to rename table %s to %s", from, to), (Throwable)e);
        }
        this.invalidateTableCache(from);
        this.invalidateTableMappingCache(from);
    }

    @Override
    public BaseTable loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Namespace namespace = this.toNamespace(schemaTableName.getSchemaName());
        try {
            return (BaseTable)CacheUtils.uncheckedCacheGet(this.tableCache, (Object)schemaTableName, () -> {
                BaseTable baseTable;
                try {
                    baseTable = (BaseTable)this.restSessionCatalog.loadTable(this.convert(session), this.toRemoteObject(session, schemaTableName));
                }
                catch (RESTException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to load table '%s'".formatted(schemaTableName.getTableName()), (Throwable)e);
                }
                return new BaseTable(baseTable.operations(), IcebergUtil.quotedTableName(schemaTableName), baseTable.reporter());
            });
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof NoSuchTableException) {
                throw new TableNotFoundException(schemaTableName, e.getCause());
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to load table: %s in %s namespace", schemaTableName.getTableName(), namespace), e.getCause());
        }
    }

    private TableIdentifier toRemoteObject(ConnectorSession session, SchemaTableName schemaTableName) {
        TableIdentifier remoteTable = this.toRemoteTable(session, schemaTableName, false);
        if (!remoteTable.name().equals(schemaTableName.getTableName())) {
            return remoteTable;
        }
        TableIdentifier remoteView = this.toRemoteView(session, schemaTableName, false);
        if (!remoteView.name().equals(schemaTableName.getTableName())) {
            return remoteView;
        }
        if (remoteView.name().equals(schemaTableName.getTableName()) && remoteTable.name().equals(schemaTableName.getTableName())) {
            return remoteTable;
        }
        throw new RuntimeException("Unable to find remote object");
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        return ImmutableMap.of();
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        Table icebergTable;
        try {
            icebergTable = this.restSessionCatalog.loadTable(this.convert(session), this.toRemoteTable(session, schemaTableName, true));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to load table '%s'".formatted(schemaTableName.getTableName()), (Throwable)e);
        }
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        String tableName = this.createLocationForTable(schemaTableName.getTableName());
        Map<String, Object> properties = this.loadNamespaceMetadata(session, schemaTableName.getSchemaName());
        String databaseLocation = (String)properties.get("location");
        if (databaseLocation == null) {
            return null;
        }
        return Locations.appendPath((String)databaseLocation, (String)tableName);
    }

    private String createLocationForTable(String baseTableName) {
        Object tableName = baseTableName;
        if (this.useUniqueTableLocation) {
            tableName = (String)tableName + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return tableName;
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        definition.getOwner().ifPresent(owner -> properties.put((Object)"trino.run-as-owner", owner));
        definition.getComment().ifPresent(comment -> properties.put((Object)"comment", comment));
        Schema schema = IcebergUtil.schemaFromViewColumns(this.typeManager, definition.getColumns());
        ViewBuilder viewBuilder = this.restSessionCatalog.buildView(this.convert(session), this.toRemoteView(session, schemaViewName, true));
        viewBuilder = ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)viewBuilder.withSchema(schema)).withQuery("trino", definition.getOriginalSql())).withDefaultNamespace(this.toRemoteNamespace(session, this.toNamespace(schemaViewName.getSchemaName())))).withDefaultCatalog((String)definition.getCatalog().orElse(null))).withProperties((Map)properties.buildOrThrow()).withLocation(this.defaultTableLocation(session, schemaViewName));
        try {
            if (replace) {
                viewBuilder.createOrReplace();
            } else {
                viewBuilder.create();
            }
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create view '%s'".formatted(schemaViewName.getTableName()), (Throwable)e);
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        try {
            this.restSessionCatalog.renameView(this.convert(session), this.toRemoteView(session, source, true), this.toRemoteView(session, target, true));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to rename view '%s' to '%s'".formatted(source, target), (Throwable)e);
        }
        this.invalidateTableMappingCache(source);
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        try {
            this.restSessionCatalog.dropView(this.convert(session), this.toRemoteView(session, schemaViewName, true));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to drop view '%s'".formatted(schemaViewName.getTableName()), (Throwable)e);
        }
        this.invalidateTableMappingCache(schemaViewName);
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        SessionCatalog.SessionContext sessionContext = this.convert(session);
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (Namespace restNamespace : this.listNamespaces(session, namespace)) {
            List restViews;
            try {
                restViews = this.restSessionCatalog.listViews(sessionContext, this.toRemoteNamespace(session, restNamespace));
            }
            catch (RESTException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list views", (Throwable)e);
            }
            for (TableIdentifier restView : restViews) {
                SchemaTableName schemaTableName = SchemaTableName.schemaTableName((String)restView.namespace().toString(), (String)restView.name());
                try {
                    this.getView(session, schemaTableName).ifPresent(view -> views.put((Object)schemaTableName, view));
                }
                catch (TrinoException e) {
                    if (e.getErrorCode().equals((Object)IcebergErrorCode.ICEBERG_UNSUPPORTED_VIEW_DIALECT.toErrorCode())) {
                        log.debug((Throwable)e, "Skip unsupported view dialect: %s", new Object[]{schemaTableName});
                        continue;
                    }
                    throw e;
                }
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.getIcebergView(session, viewName, false).flatMap(view -> {
            SQLViewRepresentation sqlView = view.sqlFor("trino");
            if (!sqlView.dialect().equalsIgnoreCase("trino")) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_UNSUPPORTED_VIEW_DIALECT, "Cannot read unsupported dialect '%s' for view '%s'".formatted(sqlView.dialect(), viewName));
            }
            Optional<String> comment = Optional.ofNullable((String)view.properties().get("comment"));
            List<ConnectorViewDefinition.ViewColumn> viewColumns = IcebergUtil.viewColumnsFromSchema(this.typeManager, view.schema());
            ViewVersion currentVersion = view.currentVersion();
            Optional<String> catalog = Optional.ofNullable(currentVersion.defaultCatalog());
            Optional<Object> schema = Optional.empty();
            if (catalog.isPresent() && !currentVersion.defaultNamespace().isEmpty()) {
                schema = Optional.of(currentVersion.defaultNamespace().toString());
            }
            Optional<String> owner = Optional.ofNullable((String)view.properties().get("trino.run-as-owner"));
            return Optional.of(new ConnectorViewDefinition(sqlView.sql(), catalog, schema, viewColumns, comment, owner, owner.isEmpty(), null));
        });
    }

    private Optional<View> getIcebergView(ConnectorSession session, SchemaTableName viewName, boolean getCached) {
        try {
            return Optional.of(this.restSessionCatalog.loadView(this.convert(session), this.toRemoteView(session, viewName, getCached)));
        }
        catch (NoSuchViewException e) {
            return Optional.empty();
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to load view '%s'".formatted(viewName.getTableName()), (Throwable)e);
        }
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateMaterializedViewColumnComment is not supported for Iceberg REST catalog");
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.empty();
    }

    @Override
    public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The Iceberg REST catalog does not support materialized views");
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The Iceberg REST catalog does not support materialized views");
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        this.loadTable(session, schemaTableName).updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        return Optional.empty();
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName schemaViewName, Optional<String> comment) {
        View view = this.getIcebergView(session, schemaViewName, true).orElseThrow(() -> new ViewNotFoundException(schemaViewName));
        UpdateViewProperties updateViewProperties = view.updateProperties();
        comment.ifPresentOrElse(value -> updateViewProperties.set("comment", value), () -> updateViewProperties.remove("comment"));
        updateViewProperties.commit();
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        View view = this.getIcebergView(session, schemaViewName, true).orElseThrow(() -> new ViewNotFoundException(schemaViewName));
        ViewVersion current = view.currentVersion();
        Schema updatedSchema = IcebergUtil.updateColumnComment(view.schema(), columnName, comment.orElse(null));
        ReplaceViewVersion replaceViewVersion = (ReplaceViewVersion)((ReplaceViewVersion)((ReplaceViewVersion)view.replaceVersion().withSchema(updatedSchema)).withDefaultCatalog(current.defaultCatalog())).withDefaultNamespace(current.defaultNamespace());
        for (ViewRepresentation representation : view.currentVersion().representations()) {
            if (!(representation instanceof SQLViewRepresentation)) continue;
            SQLViewRepresentation sqlViewRepresentation = (SQLViewRepresentation)representation;
            replaceViewVersion.withQuery(sqlViewRepresentation.dialect(), sqlViewRepresentation.sql());
        }
        replaceViewVersion.commit();
    }

    private SessionCatalog.SessionContext convert(ConnectorSession session) {
        return switch (this.sessionType) {
            default -> throw new MatchException(null, null);
            case IcebergRestCatalogConfig.SessionType.NONE -> new SessionCatalog.SessionContext(UUID.randomUUID().toString(), null, this.credentials, (Map)ImmutableMap.of(), (Object)session.getIdentity());
            case IcebergRestCatalogConfig.SessionType.USER -> {
                String sessionId = String.format("%s-%s", session.getUser(), session.getSource().orElse("default"));
                ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)session.getUser(), (Object)"source", (Object)session.getSource().orElse(""), (Object)"trinoCatalog", (Object)this.catalogName.toString(), (Object)"trinoVersion", (Object)this.trinoVersion);
                ImmutableMap claims = ImmutableMap.builder().putAll((Map)properties).buildOrThrow();
                String subjectJwt = new DefaultJwtBuilder().subject(session.getUser()).issuer(this.trinoVersion).issuedAt(new Date()).claims((Map)claims).json((Serializer)new JacksonSerializer()).compact();
                ImmutableMap credentials = ImmutableMap.builder().putAll(session.getIdentity().getExtraCredentials()).put((Object)"urn:ietf:params:oauth:token-type:jwt", (Object)subjectJwt).buildOrThrow();
                yield new SessionCatalog.SessionContext(sessionId, session.getUser(), (Map)credentials, (Map)properties, (Object)session.getIdentity());
            }
        };
    }

    private void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableCache.invalidate((Object)schemaTableName);
    }

    private void invalidateTableMappingCache(SchemaTableName schemaTableName) {
        if (this.caseInsensitiveNameMatching) {
            this.remoteTableMappingCache.invalidate((Object)this.toIdentifier(schemaTableName));
        }
    }

    private Namespace toNamespace(String schemaName) {
        if (!this.nestedNamespaceEnabled && schemaName.contains(NAMESPACE_SEPARATOR)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Nested namespace is not enabled for this catalog");
        }
        return Namespace.of((String[])Splitter.on((String)NAMESPACE_SEPARATOR).omitEmptyStrings().trimResults().splitToList((CharSequence)schemaName).toArray(new String[0]));
    }

    private String toSchemaName(Namespace namespace) {
        if (!this.nestedNamespaceEnabled && namespace.length() != 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Nested namespace is not enabled for this catalog");
        }
        return String.join((CharSequence)NAMESPACE_SEPARATOR, namespace.levels());
    }

    private TableIdentifier toIdentifier(SchemaTableName schemaTableName) {
        return TableIdentifier.of((Namespace)this.toNamespace(schemaTableName.getSchemaName()), (String)schemaTableName.getTableName());
    }

    private List<Namespace> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isEmpty()) {
            return (List)this.listNamespaces(session).stream().map(this::toNamespace).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of((Object)this.toNamespace(namespace.get()));
    }

    private TableIdentifier toRemoteTable(ConnectorSession session, SchemaTableName schemaTableName, boolean getCached) {
        TableIdentifier tableIdentifier = this.toIdentifier(schemaTableName);
        return this.toRemoteObject(tableIdentifier, () -> this.findRemoteTable(session, tableIdentifier), getCached);
    }

    private TableIdentifier findRemoteTable(ConnectorSession session, TableIdentifier tableIdentifier) {
        List tableIdentifiers;
        Namespace remoteNamespace = this.toRemoteNamespace(session, tableIdentifier.namespace());
        try {
            tableIdentifiers = this.restSessionCatalog.listTables(this.convert(session), remoteNamespace);
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list tables", (Throwable)e);
        }
        TableIdentifier matchingTable = null;
        for (TableIdentifier identifier : tableIdentifiers) {
            if (!identifier.name().equalsIgnoreCase(tableIdentifier.name())) continue;
            if (matchingTable != null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Duplicate table names are not supported with Iceberg REST catalog: " + Joiner.on((String)", ").join((Object)matchingTable, (Object)identifier.name(), new Object[0]));
            }
            matchingTable = identifier;
        }
        return matchingTable == null ? TableIdentifier.of((Namespace)remoteNamespace, (String)tableIdentifier.name()) : matchingTable;
    }

    private TableIdentifier toRemoteView(ConnectorSession session, SchemaTableName schemaViewName, boolean getCached) {
        TableIdentifier tableIdentifier = this.toIdentifier(schemaViewName);
        return this.toRemoteObject(tableIdentifier, () -> this.findRemoteView(session, tableIdentifier), getCached);
    }

    private TableIdentifier findRemoteView(ConnectorSession session, TableIdentifier tableIdentifier) {
        List tableIdentifiers;
        Namespace remoteNamespace = this.toRemoteNamespace(session, tableIdentifier.namespace());
        try {
            tableIdentifiers = this.restSessionCatalog.listViews(this.convert(session), remoteNamespace);
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list views", (Throwable)e);
        }
        TableIdentifier matchingView = null;
        for (TableIdentifier identifier : tableIdentifiers) {
            if (!identifier.name().equalsIgnoreCase(tableIdentifier.name())) continue;
            if (matchingView != null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Duplicate view names are not supported with Iceberg REST catalog: " + Joiner.on((String)", ").join((Object)matchingView.name(), (Object)identifier.name(), new Object[0]));
            }
            matchingView = identifier;
        }
        return matchingView == null ? TableIdentifier.of((Namespace)remoteNamespace, (String)tableIdentifier.name()) : matchingView;
    }

    private TableIdentifier toRemoteObject(TableIdentifier tableIdentifier, Supplier<TableIdentifier> remoteObjectProvider, boolean getCached) {
        if (this.caseInsensitiveNameMatching) {
            if (getCached) {
                return (TableIdentifier)CacheUtils.uncheckedCacheGet(this.remoteTableMappingCache, (Object)tableIdentifier, remoteObjectProvider);
            }
            return remoteObjectProvider.get();
        }
        return tableIdentifier;
    }

    private Namespace toRemoteNamespace(ConnectorSession session, Namespace trinoNamespace) {
        if (this.caseInsensitiveNameMatching) {
            return (Namespace)CacheUtils.uncheckedCacheGet(this.remoteNamespaceMappingCache, (Object)trinoNamespace, () -> this.findRemoteNamespace(session, trinoNamespace));
        }
        return trinoNamespace;
    }

    private Namespace findRemoteNamespace(ConnectorSession session, Namespace trinoNamespace) {
        List matchingRemoteNamespaces = (List)this.listNamespaces(session, Namespace.empty()).stream().filter(ns -> TrinoRestCatalog.toTrinoNamespace(ns).equals((Object)trinoNamespace)).collect(ImmutableList.toImmutableList());
        if (matchingRemoteNamespaces.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Duplicate namespace names are not supported with Iceberg REST catalog: " + String.valueOf(matchingRemoteNamespaces));
        }
        return matchingRemoteNamespaces.isEmpty() ? trinoNamespace : (Namespace)matchingRemoteNamespaces.getFirst();
    }

    private List<Namespace> listNamespaces(ConnectorSession session, Namespace parentNamespace) {
        List childNamespaces;
        try {
            childNamespaces = this.restSessionCatalog.listNamespaces(this.convert(session), parentNamespace);
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to list namespaces", (Throwable)e);
        }
        return childNamespaces.stream().flatMap(childNamespace -> Stream.concat(Stream.of(childNamespace), this.listNamespaces(session, (Namespace)childNamespace).stream())).toList();
    }

    private static Namespace toTrinoNamespace(Namespace namespace) {
        return Namespace.of((String[])((String[])Arrays.stream(namespace.levels()).map(level -> level.toLowerCase(Locale.ENGLISH)).toArray(String[]::new)));
    }
}

