/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergPageSourceProvider;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.delete.DeleteFilter;
import io.trino.plugin.iceberg.delete.EqualityDeleteFilter;
import io.trino.plugin.iceberg.delete.PositionDeleteFilter;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class DeleteManager {
    private final TypeManager typeManager;
    private final Map<List<Integer>, EqualityDeleteFilter.EqualityDeleteFilterBuilder> equalityDeleteFiltersBySchema = new ConcurrentHashMap<List<Integer>, EqualityDeleteFilter.EqualityDeleteFilterBuilder>();

    public DeleteManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public Optional<RowPredicate> getDeletePredicate(String dataFilePath, long dataSequenceNumber, List<DeleteFile> deleteFiles, List<IcebergColumnHandle> readColumns, Schema tableSchema, IcebergPageSourceProvider.ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions, DeletePageSourceProvider deletePageSourceProvider) {
        if (deleteFiles.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<DeleteFile> positionDeleteFiles = new ArrayList<DeleteFile>();
        ArrayList<DeleteFile> equalityDeleteFiles = new ArrayList<DeleteFile>();
        for (DeleteFile deleteFile : deleteFiles) {
            switch (deleteFile.content()) {
                case POSITION_DELETES: {
                    positionDeleteFiles.add(deleteFile);
                    break;
                }
                case EQUALITY_DELETES: {
                    equalityDeleteFiles.add(deleteFile);
                    break;
                }
                case DATA: {
                    throw new VerifyException("DATA is not delete file type");
                }
            }
        }
        Optional<RowPredicate> positionDeletes = this.createPositionDeleteFilter(dataFilePath, positionDeleteFiles, readerPageSourceWithRowPositions, deletePageSourceProvider).map(filter -> filter.createPredicate(readColumns, dataSequenceNumber));
        Optional<RowPredicate> equalityDeletes = this.createEqualityDeleteFilter(equalityDeleteFiles, tableSchema, deletePageSourceProvider).stream().map(filter -> filter.createPredicate(readColumns, dataSequenceNumber)).reduce(RowPredicate::and);
        if (positionDeletes.isEmpty()) {
            return equalityDeletes;
        }
        return equalityDeletes.map(rowPredicate -> ((RowPredicate)positionDeletes.get()).and((RowPredicate)rowPredicate)).or(() -> positionDeletes);
    }

    private Optional<DeleteFilter> createPositionDeleteFilter(String dataFilePath, List<DeleteFile> positionDeleteFiles, IcebergPageSourceProvider.ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions, DeletePageSourceProvider deletePageSourceProvider) {
        if (positionDeleteFiles.isEmpty()) {
            return Optional.empty();
        }
        Slice targetPath = Slices.utf8Slice((String)dataFilePath);
        Optional<Long> startRowPosition = readerPageSourceWithRowPositions.startRowPosition();
        Optional<Long> endRowPosition = readerPageSourceWithRowPositions.endRowPosition();
        Verify.verify((startRowPosition.isPresent() == endRowPosition.isPresent() ? 1 : 0) != 0, (String)"startRowPosition and endRowPosition must be specified together", (Object[])new Object[0]);
        IcebergColumnHandle deleteFilePath = IcebergUtil.getColumnHandle(MetadataColumns.DELETE_FILE_PATH, this.typeManager);
        IcebergColumnHandle deleteFilePos = IcebergUtil.getColumnHandle(MetadataColumns.DELETE_FILE_POS, this.typeManager);
        ImmutableList deleteColumns = ImmutableList.of((Object)deleteFilePath, (Object)deleteFilePos);
        TupleDomain deleteDomain = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)deleteFilePath, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)targetPath)));
        if (startRowPosition.isPresent()) {
            Range positionRange = Range.range((Type)deleteFilePos.getType(), (Object)startRowPosition.get(), (boolean)true, (Object)endRowPosition.get(), (boolean)true);
            TupleDomain positionDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)deleteFilePos, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)positionRange, (Range[])new Range[0]), (boolean)false)));
            deleteDomain = deleteDomain.intersect(positionDomain);
        }
        Roaring64Bitmap deletedRows = new Roaring64Bitmap();
        for (DeleteFile deleteFile : positionDeleteFiles) {
            if (!DeleteManager.shouldLoadPositionDeleteFile(deleteFile, startRowPosition, endRowPosition)) continue;
            try {
                ConnectorPageSource pageSource = deletePageSourceProvider.openDeletes(deleteFile, (List<IcebergColumnHandle>)deleteColumns, (TupleDomain<IcebergColumnHandle>)deleteDomain);
                try {
                    PositionDeleteFilter.readPositionDeletes(pageSource, targetPath, (LongBitmapDataProvider)deletedRows);
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (deletedRows.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PositionDeleteFilter((ImmutableLongBitmapDataProvider)deletedRows));
    }

    private static boolean shouldLoadPositionDeleteFile(DeleteFile deleteFile, Optional<Long> startRowPosition, Optional<Long> endRowPosition) {
        if (startRowPosition.isEmpty()) {
            return true;
        }
        Optional<Long> positionLowerBound = deleteFile.rowPositionLowerBound();
        Optional<Long> positionUpperBound = deleteFile.rowPositionUpperBound();
        return !(!positionLowerBound.isEmpty() && positionLowerBound.get() > endRowPosition.orElseThrow() || !positionUpperBound.isEmpty() && positionUpperBound.get() < startRowPosition.get());
    }

    private List<EqualityDeleteFilter> createEqualityDeleteFilter(List<DeleteFile> equalityDeleteFiles, Schema schema, DeletePageSourceProvider deletePageSourceProvider) {
        if (equalityDeleteFiles.isEmpty()) {
            return List.of();
        }
        ArrayList pendingLoads = new ArrayList();
        HashSet<EqualityDeleteFilter.EqualityDeleteFilterBuilder> deleteFilters = new HashSet<EqualityDeleteFilter.EqualityDeleteFilterBuilder>();
        for (DeleteFile deleteFile : equalityDeleteFiles) {
            List<Integer> fieldIds = deleteFile.equalityFieldIds();
            Verify.verify((!fieldIds.isEmpty() ? 1 : 0) != 0, (String)"equality field IDs are missing", (Object[])new Object[0]);
            List deleteColumns = (List)fieldIds.stream().map(id -> IcebergUtil.getColumnHandle(schema.findField(id.intValue()), this.typeManager)).collect(ImmutableList.toImmutableList());
            EqualityDeleteFilter.EqualityDeleteFilterBuilder builder = this.equalityDeleteFiltersBySchema.computeIfAbsent(fieldIds, list -> EqualityDeleteFilter.builder(IcebergUtil.schemaFromHandles(deleteColumns)));
            deleteFilters.add(builder);
            ListenableFuture<?> loadFuture = builder.readEqualityDeletes(deleteFile, deleteColumns, deletePageSourceProvider);
            if (loadFuture.state() == Future.State.SUCCESS) continue;
            pendingLoads.add(loadFuture);
        }
        try {
            Futures.allAsList(pendingLoads).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Failed to load equality deletes", (Throwable)e);
        }
        return deleteFilters.stream().map(EqualityDeleteFilter.EqualityDeleteFilterBuilder::build).toList();
    }

    public static interface DeletePageSourceProvider {
        public ConnectorPageSource openDeletes(DeleteFile var1, List<IcebergColumnHandle> var2, TupleDomain<IcebergColumnHandle> var3);
    }
}

