/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.base.Preconditions;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.iceberg.StructLike;

final class LazyTrinoRow
implements StructLike {
    private final Type[] types;
    private final SourcePage page;
    private final int position;
    private final Object[] values;

    public LazyTrinoRow(Type[] types, SourcePage page, int position) {
        Preconditions.checkArgument((types.length == page.getChannelCount() ? 1 : 0) != 0, (Object)"mismatched types for page");
        this.types = Objects.requireNonNull(types, "types is null");
        this.page = Objects.requireNonNull(page, "page is null");
        Preconditions.checkElementIndex((int)position, (int)page.getPositionCount(), (String)"page position");
        this.position = position;
        this.values = new Object[types.length];
    }

    public int size() {
        return this.page.getChannelCount();
    }

    public <T> T get(int i, Class<T> clazz) {
        return clazz.cast(this.get(i));
    }

    public <T> void set(int i, T t) {
        throw new UnsupportedOperationException();
    }

    private Object get(int i) {
        Object value = this.values[i];
        if (value != null) {
            return value;
        }
        this.values[i] = value = IcebergPageSink.getIcebergValue(this.page.getBlock(i), this.position, this.types[i]);
        return value;
    }
}

