/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.errorprone.annotations.ThreadSafe;
import io.trino.spi.connector.SourcePage;
import java.util.Objects;

@ThreadSafe
public interface RowPredicate {
    public boolean test(SourcePage var1, int var2);

    default public RowPredicate and(RowPredicate other) {
        Objects.requireNonNull(other, "other is null");
        return (page, position) -> this.test(page, position) && other.test(page, position);
    }

    default public void applyFilter(SourcePage page) {
        int positionCount = page.getPositionCount();
        int[] retained = new int[positionCount];
        int retainedCount = 0;
        for (int position = 0; position < positionCount; ++position) {
            if (!this.test(page, position)) continue;
            retained[retainedCount] = position;
            ++retainedCount;
        }
        if (retainedCount != positionCount) {
            page.selectPositions(retained, 0, retainedCount);
        }
    }
}

