/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.base.Preconditions;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import java.util.Arrays;
import org.apache.iceberg.StructLike;

final class TrinoRow
implements StructLike {
    private final Object[] values;

    public TrinoRow(Type[] types, SourcePage page, int position) {
        Preconditions.checkArgument((types.length == page.getChannelCount() ? 1 : 0) != 0, (Object)"mismatched types for page");
        this.values = new Object[types.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = IcebergPageSink.getIcebergValue(page.getBlock(i), position, types[i]);
        }
    }

    public int size() {
        return this.values.length;
    }

    public <T> T get(int i, Class<T> clazz) {
        return clazz.cast(this.values[i]);
    }

    public <T> void set(int i, T t) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "TrinoRow" + Arrays.toString(this.values);
    }
}

