/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.fileio;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.plugin.iceberg.fileio.ForwardingOutputFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;

public class ForwardingFileIo
implements SupportsBulkOperations {
    private static final int DELETE_BATCH_SIZE = 1000;
    private static final int BATCH_DELETE_PATHS_MESSAGE_LIMIT = 5;
    private final TrinoFileSystem fileSystem;
    private final Map<String, String> properties;
    private final boolean useFileSizeFromMetadata;

    public ForwardingFileIo(TrinoFileSystem fileSystem) {
        this(fileSystem, (Map<String, String>)ImmutableMap.of(), true);
    }

    public ForwardingFileIo(TrinoFileSystem fileSystem, boolean useFileSizeFromMetadata) {
        this(fileSystem, (Map<String, String>)ImmutableMap.of(), useFileSizeFromMetadata);
    }

    public ForwardingFileIo(TrinoFileSystem fileSystem, Map<String, String> properties, boolean useFileSizeFromMetadata) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.useFileSizeFromMetadata = useFileSizeFromMetadata;
    }

    public InputFile newInputFile(String path) {
        return new ForwardingInputFile(this.fileSystem.newInputFile(Location.of((String)path)));
    }

    public InputFile newInputFile(String path, long length) {
        if (!this.useFileSizeFromMetadata) {
            return new ForwardingInputFile(this.fileSystem.newInputFile(Location.of((String)path)));
        }
        return new ForwardingInputFile(this.fileSystem.newInputFile(Location.of((String)path), length));
    }

    public OutputFile newOutputFile(String path) {
        return new ForwardingOutputFile(this.fileSystem, Location.of((String)path));
    }

    public void deleteFile(String path) {
        try {
            this.fileSystem.deleteFile(Location.of((String)path));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + path, e);
        }
    }

    public void deleteFile(InputFile file) {
        super.deleteFile(file);
    }

    public void deleteFile(OutputFile file) {
        super.deleteFile(file);
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        Iterable partitions = Iterables.partition(pathsToDelete, (int)1000);
        partitions.forEach(this::deleteBatch);
    }

    public InputFile newInputFile(ManifestFile manifest) {
        return super.newInputFile(manifest);
    }

    public InputFile newInputFile(DataFile file) {
        return super.newInputFile(file);
    }

    public InputFile newInputFile(DeleteFile file) {
        return super.newInputFile(file);
    }

    private void deleteBatch(List<String> filesToDelete) {
        try {
            this.fileSystem.deleteFiles(filesToDelete.stream().map(Location::of).toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete some or all of files: " + Stream.concat(filesToDelete.stream().limit(5L), filesToDelete.size() > 5 ? Stream.of("...") : Stream.of(new String[0])).collect(Collectors.joining(", ", "[", "]")), e);
        }
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public void initialize(Map<String, String> properties) {
        throw new UnsupportedOperationException("ForwardingFileIO does not support initialization by properties");
    }

    public void close() {
    }
}

