/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionProcessorProviderFactory;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionProcessorProviderFactory;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionAdapter;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.Signature;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProviderFactory;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergFunctionProvider
implements FunctionProvider {
    public static final List<FunctionMetadata> FUNCTIONS = ImmutableList.builder().add((Object)FunctionMetadata.scalarBuilder((String)"bucket").functionId(new FunctionId("bucket")).nondeterministic().description("Perform Iceberg bucket transform").signature(Signature.builder().typeVariable("T").returnType(IntegerType.INTEGER.getTypeSignature()).argumentTypes((List)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)IntegerType.INTEGER.getTypeSignature())).build()).nullable().build()).build();
    private static final MethodHandle BUCKET_INTEGER;
    private static final MethodHandle BUCKET_SHORT_DECIMAL;
    private static final MethodHandle BUCKET_LONG_DECIMAL;
    private static final MethodHandle BUCKET_VARCHAR;
    private static final MethodHandle BUCKET_VARBINARY;
    private static final MethodHandle BUCKET_DATE;
    private static final MethodHandle BUCKET_SHORT_TIMESTAMP;
    private static final MethodHandle BUCKET_LONG_TIMESTAMP;
    private static final MethodHandle BUCKET_SHORT_TIMESTAMP_WITH_TIME_ZONE;
    private static final MethodHandle BUCKET_LONG_TIMESTAMP_WITH_TIME_ZONE;
    private final TableChangesFunctionProcessorProviderFactory tableChangesFunctionProcessorProviderFactory;

    @Inject
    public IcebergFunctionProvider(TableChangesFunctionProcessorProviderFactory tableChangesFunctionProcessorProviderFactory) {
        this.tableChangesFunctionProcessorProviderFactory = Objects.requireNonNull(tableChangesFunctionProcessorProviderFactory, "tableChangesFunctionProcessorProviderFactory is null");
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        MethodHandle methodHandle;
        io.trino.spi.type.Type type;
        List argumentTypes = boundSignature.getArgumentTypes();
        Preconditions.checkArgument((argumentTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected two arguments, but got %s", (int)argumentTypes.size());
        Preconditions.checkArgument((argumentTypes.getLast() == IntegerType.INTEGER ? 1 : 0) != 0, (String)"The 2nd argument must be integer type, but got %s", argumentTypes.getLast());
        io.trino.spi.type.Type type2 = type = (io.trino.spi.type.Type)argumentTypes.getFirst();
        Objects.requireNonNull(type2);
        io.trino.spi.type.Type type3 = type2;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TinyintType.class, SmallintType.class, IntegerType.class, BigintType.class, DecimalType.class, VarcharType.class, VarbinaryType.class, DateType.class, TimestampType.class, TimestampWithTimeZoneType.class}, (io.trino.spi.type.Type)type3, n)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (!(type3 instanceof TinyintType || type3 instanceof SmallintType || type3 instanceof IntegerType || type3 instanceof BigintType)) {
                        n = 4;
                        continue block9;
                    }
                    methodHandle = BUCKET_INTEGER;
                    break block9;
                }
                case 4: {
                    DecimalType decimalType = (DecimalType)type3;
                    if (decimalType.isShort()) {
                        methodHandle = BUCKET_SHORT_DECIMAL;
                        break block9;
                    }
                    methodHandle = BUCKET_LONG_DECIMAL;
                    break block9;
                }
                case 5: {
                    methodHandle = BUCKET_VARCHAR;
                    break block9;
                }
                case 6: {
                    methodHandle = BUCKET_VARBINARY;
                    break block9;
                }
                case 7: {
                    methodHandle = BUCKET_DATE;
                    break block9;
                }
                case 8: {
                    TimestampType timestampType = (TimestampType)type3;
                    if (timestampType.isShort()) {
                        methodHandle = BUCKET_SHORT_TIMESTAMP;
                        break block9;
                    }
                    methodHandle = BUCKET_LONG_TIMESTAMP;
                    break block9;
                }
                case 9: {
                    TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type3;
                    if (timestampWithTimeZoneType.isShort()) {
                        methodHandle = BUCKET_SHORT_TIMESTAMP_WITH_TIME_ZONE;
                        break block9;
                    }
                    methodHandle = BUCKET_LONG_TIMESTAMP_WITH_TIME_ZONE;
                    break block9;
                }
                default: {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Unsupported type: " + String.valueOf(type));
                }
            }
            break;
        }
        MethodHandle handle = methodHandle;
        handle = handle.bindTo(this);
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            handle = handle.bindTo(decimalType);
        }
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, false);
        handle = ScalarFunctionAdapter.adapt((MethodHandle)handle, (io.trino.spi.type.Type)boundSignature.getReturnType(), (List)boundSignature.getArgumentTypes(), (InvocationConvention)actualConvention, (InvocationConvention)invocationConvention);
        return ScalarFunctionImplementation.builder().methodHandle(handle).build();
    }

    public long bucketInteger(long value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.LongType.get()).apply((Object)value)).intValue();
    }

    public long bucketShortDecimal(DecimalType decimalType, long value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale())).apply((Object)BigDecimal.valueOf(value))).intValue();
    }

    public long bucketLongDecimal(DecimalType decimalType, Int128 value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale())).apply((Object)new BigDecimal(value.toBigInteger()))).intValue();
    }

    public long bucketVarchar(Slice value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.StringType.get()).apply((Object)value.toStringUtf8())).intValue();
    }

    public long bucketVarbinary(Slice value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.BinaryType.get()).apply((Object)value.toByteBuffer())).intValue();
    }

    public long bucketDate(long value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.DateType.get()).apply((Object)((int)value))).intValue();
    }

    public long bucketShortTimestamp(long value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.TimestampType.withoutZone()).apply((Object)value)).intValue();
    }

    public long bucketLongTimestamp(LongTimestamp value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.TimestampType.withoutZone()).apply((Object)value.getEpochMicros())).intValue();
    }

    public long bucketShortTimestampWithTimeZone(long value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.TimestampType.withZone()).apply((Object)(DateTimeEncoding.unpackMillisUtc((long)value) * 1000L))).intValue();
    }

    public long bucketLongTimestampWithTimeZone(LongTimestampWithTimeZone value, long numberOfBuckets) {
        return ((Integer)Transforms.bucket((int)((int)numberOfBuckets)).bind((Type)Types.TimestampType.withZone()).apply((Object)Timestamps.timestampTzToMicros(value))).intValue();
    }

    public TableFunctionProcessorProviderFactory getTableFunctionProcessorProviderFactory(ConnectorTableFunctionHandle functionHandle) {
        if (functionHandle instanceof TableChangesFunctionHandle) {
            return new ClassLoaderSafeTableFunctionProcessorProviderFactory((TableFunctionProcessorProviderFactory)this.tableChangesFunctionProcessorProviderFactory, this.getClass().getClassLoader());
        }
        throw new UnsupportedOperationException("Unsupported function: " + String.valueOf(functionHandle));
    }

    static {
        try {
            BUCKET_INTEGER = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketInteger", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
            BUCKET_SHORT_DECIMAL = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketShortDecimal", MethodType.methodType(Long.TYPE, DecimalType.class, Long.TYPE, Long.TYPE));
            BUCKET_LONG_DECIMAL = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketLongDecimal", MethodType.methodType(Long.TYPE, DecimalType.class, Int128.class, Long.TYPE));
            BUCKET_VARCHAR = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketVarchar", MethodType.methodType(Long.TYPE, Slice.class, Long.TYPE));
            BUCKET_VARBINARY = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketVarbinary", MethodType.methodType(Long.TYPE, Slice.class, Long.TYPE));
            BUCKET_DATE = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketDate", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
            BUCKET_SHORT_TIMESTAMP = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketShortTimestamp", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
            BUCKET_LONG_TIMESTAMP = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketLongTimestamp", MethodType.methodType(Long.TYPE, LongTimestamp.class, Long.TYPE));
            BUCKET_SHORT_TIMESTAMP_WITH_TIME_ZONE = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketShortTimestampWithTimeZone", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
            BUCKET_LONG_TIMESTAMP_WITH_TIME_ZONE = MethodHandles.lookup().findVirtual(IcebergFunctionProvider.class, "bucketLongTimestampWithTimeZone", MethodType.methodType(Long.TYPE, LongTimestampWithTimeZone.class, Long.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

