/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;

public class TableChangesFunction
extends AbstractConnectorTableFunction {
    private static final String FUNCTION_NAME = "table_changes";
    private static final String SCHEMA_NAME_VAR_NAME = "SCHEMA_NAME";
    private static final String TABLE_NAME_VAR_NAME = "TABLE_NAME";
    private static final String START_SNAPSHOT_VAR_NAME = "START_SNAPSHOT_ID";
    private static final String END_SNAPSHOT_VAR_NAME = "END_SNAPSHOT_ID";
    private final TrinoCatalogFactory trinoCatalogFactory;
    private final TypeManager typeManager;

    @Inject
    public TableChangesFunction(TrinoCatalogFactory trinoCatalogFactory, TypeManager typeManager) {
        super("system", FUNCTION_NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name(SCHEMA_NAME_VAR_NAME).type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name(TABLE_NAME_VAR_NAME).type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name(START_SNAPSHOT_VAR_NAME).type((Type)BigintType.BIGINT).build(), (Object)ScalarArgumentSpecification.builder().name(END_SNAPSHOT_VAR_NAME).type((Type)BigintType.BIGINT).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        this.trinoCatalogFactory = Objects.requireNonNull(trinoCatalogFactory, "trinoCatalogFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        String schema = TableChangesFunction.getSchemaName(arguments);
        String table = TableChangesFunction.getTableName(arguments);
        long startSnapshotId = (Long)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(START_SNAPSHOT_VAR_NAME)).getValue());
        long endSnapshotId = (Long)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(END_SNAPSHOT_VAR_NAME)).getValue());
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        BaseTable icebergTable = this.trinoCatalogFactory.create(session.getIdentity()).loadTable(session, schemaTableName);
        TableChangesFunction.checkSnapshotExists((Table)icebergTable, startSnapshotId);
        TableChangesFunction.checkSnapshotExists((Table)icebergTable, endSnapshotId);
        if (!SnapshotUtil.isParentAncestorOf((Table)icebergTable, (long)endSnapshotId, (long)startSnapshotId)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Starting snapshot (exclusive) %s is not a parent ancestor of end snapshot %s".formatted(startSnapshotId, endSnapshotId));
        }
        ImmutableList.Builder columns = ImmutableList.builder();
        Schema tableSchema = (Schema)icebergTable.schemas().get(icebergTable.snapshot(endSnapshotId).schemaId());
        tableSchema.columns().stream().map(column -> new Descriptor.Field(column.name(), Optional.of(TypeConverter.toTrinoType(column.type(), this.typeManager)))).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)new Descriptor.Field("_change_type", Optional.of(VarcharType.VARCHAR)));
        columns.add((Object)new Descriptor.Field("_change_version_id", Optional.of(BigintType.BIGINT)));
        columns.add((Object)new Descriptor.Field("_change_timestamp", Optional.of(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)));
        columns.add((Object)new Descriptor.Field("_change_ordinal", Optional.of(IntegerType.INTEGER)));
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        IcebergUtil.getTopLevelColumns(tableSchema, this.typeManager).forEach(arg_0 -> ((ImmutableList.Builder)columnHandlesBuilder).add(arg_0));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483645, "_change_type", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)VarcharType.VARCHAR, (List<Integer>)ImmutableList.of(), (Type)VarcharType.VARCHAR, false, Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483644, "_change_version_id", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)BigintType.BIGINT, (List<Integer>)ImmutableList.of(), (Type)BigintType.BIGINT, false, Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483643, "_change_timestamp", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (List<Integer>)ImmutableList.of(), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, false, Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483642, "_change_ordinal", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)IntegerType.INTEGER, (List<Integer>)ImmutableList.of(), (Type)IntegerType.INTEGER, false, Optional.empty()));
        ImmutableList columnHandles = columnHandlesBuilder.build();
        accessControl.checkCanSelectFromColumns(null, schemaTableName, (Set)columnHandles.stream().map(IcebergColumnHandle::getName).collect(ImmutableSet.toImmutableSet()));
        return TableFunctionAnalysis.builder().returnedType(new Descriptor((List)columns.build())).handle((ConnectorTableFunctionHandle)new TableChangesFunctionHandle(schemaTableName, SchemaParser.toJson((Schema)tableSchema), (List<IcebergColumnHandle>)columnHandles, Optional.ofNullable((String)icebergTable.properties().get("schema.name-mapping.default")), startSnapshotId, endSnapshotId)).build();
    }

    private static String getSchemaName(Map<String, Argument> arguments) {
        if (TableChangesFunction.argumentExists(arguments, SCHEMA_NAME_VAR_NAME)) {
            return ((Slice)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(SCHEMA_NAME_VAR_NAME)).getValue())).toStringUtf8();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SCHEMA_NAME argument not found");
    }

    private static String getTableName(Map<String, Argument> arguments) {
        if (TableChangesFunction.argumentExists(arguments, TABLE_NAME_VAR_NAME)) {
            return ((Slice)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(TABLE_NAME_VAR_NAME)).getValue())).toStringUtf8();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "TABLE_NAME argument not found");
    }

    private static boolean argumentExists(Map<String, Argument> arguments, String key) {
        Argument argument = arguments.get(key);
        if (argument instanceof ScalarArgument) {
            ScalarArgument scalarArgument = (ScalarArgument)argument;
            return !scalarArgument.getNullableValue().isNull();
        }
        throw new IllegalArgumentException("Unsupported argument type: " + String.valueOf(argument));
    }

    private static Object checkNonNull(Object argumentValue) {
        if (argumentValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "table_changes arguments may not be null");
        }
        return argumentValue;
    }

    private static void checkSnapshotExists(Table icebergTable, long snapshotId) {
        if (icebergTable.snapshot(snapshotId) == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Snapshot not found in Iceberg table history: " + snapshotId);
        }
    }
}

