/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergPageSourceProvider;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesSplit;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.types.Type;

public class TableChangesFunctionProcessor
implements TableFunctionSplitProcessor {
    private static final Page EMPTY_PAGE = new Page(0);
    private final ConnectorPageSource pageSource;
    private final int[] delegateColumnMap;
    private final Optional<Integer> changeTypeIndex;
    private final Block changeTypeValue;
    private final Optional<Integer> changeVersionIndex;
    private final Block changeVersionValue;
    private final Optional<Integer> changeTimestampIndex;
    private final Block changeTimestampValue;
    private final Optional<Integer> changeOrdinalIndex;
    private final Block changeOrdinalValue;

    public TableChangesFunctionProcessor(ConnectorSession session, TableChangesFunctionHandle functionHandle, TableChangesSplit split, IcebergPageSourceProvider icebergPageSourceProvider) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(functionHandle, "functionHandle is null");
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(icebergPageSourceProvider, "icebergPageSourceProvider is null");
        Schema tableSchema = SchemaParser.fromJson((String)functionHandle.tableSchemaJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)tableSchema, (String)split.partitionSpecJson());
        Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(tableSchema.findType(field.sourceId()))).toArray(Type[]::new);
        int delegateColumnIndex = 0;
        int[] delegateColumnMap = new int[functionHandle.columns().size()];
        Optional<Object> changeTypeIndex = Optional.empty();
        Optional<Object> changeVersionIndex = Optional.empty();
        Optional<Object> changeTimestampIndex = Optional.empty();
        Optional<Object> changeOrdinalIndex = Optional.empty();
        for (int columnIndex = 0; columnIndex < functionHandle.columns().size(); ++columnIndex) {
            IcebergColumnHandle column = functionHandle.columns().get(columnIndex);
            if (column.getId() == -2147483645) {
                changeTypeIndex = Optional.of(columnIndex);
                delegateColumnMap[columnIndex] = -1;
                continue;
            }
            if (column.getId() == -2147483644) {
                changeVersionIndex = Optional.of(columnIndex);
                delegateColumnMap[columnIndex] = -1;
                continue;
            }
            if (column.getId() == -2147483643) {
                changeTimestampIndex = Optional.of(columnIndex);
                delegateColumnMap[columnIndex] = -1;
                continue;
            }
            if (column.getId() == -2147483642) {
                changeOrdinalIndex = Optional.of(columnIndex);
                delegateColumnMap[columnIndex] = -1;
                continue;
            }
            delegateColumnMap[columnIndex] = delegateColumnIndex++;
        }
        this.pageSource = icebergPageSourceProvider.createPageSource(session, functionHandle.columns(), tableSchema, partitionSpec, PartitionData.fromJson(split.partitionDataJson(), partitionColumnTypes), (List<DeleteFile>)ImmutableList.of(), DynamicFilter.EMPTY, (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), split.path(), split.start(), split.length(), split.fileSize(), split.fileRecordCount(), split.partitionDataJson(), split.fileFormat(), split.fileIoProperties(), 0L, functionHandle.nameMappingJson().map(NameMappingParser::fromJson));
        this.delegateColumnMap = delegateColumnMap;
        this.changeTypeIndex = changeTypeIndex;
        this.changeTypeValue = Utils.nativeValueToBlock((io.trino.spi.type.Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)split.changeType().getTableValue()));
        this.changeVersionIndex = changeVersionIndex;
        this.changeVersionValue = Utils.nativeValueToBlock((io.trino.spi.type.Type)BigintType.BIGINT, (Object)split.snapshotId());
        this.changeTimestampIndex = changeTimestampIndex;
        this.changeTimestampValue = Utils.nativeValueToBlock((io.trino.spi.type.Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Object)split.snapshotTimestamp());
        this.changeOrdinalIndex = changeOrdinalIndex;
        this.changeOrdinalValue = Utils.nativeValueToBlock((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)split.changeOrdinal());
    }

    public TableFunctionProcessorState process() {
        if (this.pageSource.isFinished()) {
            return TableFunctionProcessorState.Finished.FINISHED;
        }
        SourcePage dataPage = this.pageSource.getNextSourcePage();
        if (dataPage == null) {
            return TableFunctionProcessorState.Processed.produced((Page)EMPTY_PAGE);
        }
        Block[] blocks = new Block[this.delegateColumnMap.length];
        for (int targetChannel = 0; targetChannel < this.delegateColumnMap.length; ++targetChannel) {
            int delegateIndex = this.delegateColumnMap[targetChannel];
            if (delegateIndex == -1) continue;
            blocks[targetChannel] = dataPage.getBlock(delegateIndex);
        }
        this.changeTypeIndex.ifPresent(columnChannel -> {
            blocks[columnChannel.intValue()] = RunLengthEncodedBlock.create((Block)this.changeTypeValue, (int)dataPage.getPositionCount());
        });
        this.changeVersionIndex.ifPresent(columnChannel -> {
            blocks[columnChannel.intValue()] = RunLengthEncodedBlock.create((Block)this.changeVersionValue, (int)dataPage.getPositionCount());
        });
        this.changeTimestampIndex.ifPresent(columnChannel -> {
            blocks[columnChannel.intValue()] = RunLengthEncodedBlock.create((Block)this.changeTimestampValue, (int)dataPage.getPositionCount());
        });
        this.changeOrdinalIndex.ifPresent(columnChannel -> {
            blocks[columnChannel.intValue()] = RunLengthEncodedBlock.create((Block)this.changeOrdinalValue, (int)dataPage.getPositionCount());
        });
        return TableFunctionProcessorState.Processed.produced((Page)new Page(dataPage.getPositionCount(), blocks));
    }
}

