/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionSplitProcessor;
import io.trino.plugin.iceberg.IcebergPageSourceProvider;
import io.trino.plugin.iceberg.IcebergPageSourceProviderFactory;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionProcessor;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesSplit;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorProviderFactory;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import java.util.Objects;

public class TableChangesFunctionProcessorProviderFactory
implements TableFunctionProcessorProviderFactory {
    private final IcebergPageSourceProviderFactory icebergPageSourceProviderFactory;

    @Inject
    public TableChangesFunctionProcessorProviderFactory(IcebergPageSourceProviderFactory icebergPageSourceProviderFactory) {
        this.icebergPageSourceProviderFactory = Objects.requireNonNull(icebergPageSourceProviderFactory, "icebergPageSourceProviderFactory is null");
    }

    public TableFunctionProcessorProvider createTableFunctionProcessorProvider() {
        IcebergPageSourceProvider pageSourceProvider = (IcebergPageSourceProvider)this.icebergPageSourceProviderFactory.createPageSourceProvider();
        return new TableChangesFunctionProcessorProvider(pageSourceProvider);
    }

    private record TableChangesFunctionProcessorProvider(IcebergPageSourceProvider icebergPageSourceProvider) implements TableFunctionProcessorProvider
    {
        public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
            return new ClassLoaderSafeTableFunctionSplitProcessor((TableFunctionSplitProcessor)new TableChangesFunctionProcessor(session, (TableChangesFunctionHandle)handle, (TableChangesSplit)split, this.icebergPageSourceProvider), this.getClass().getClassLoader());
        }
    }
}

