/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.BaseTable;

@Deprecated
public class RollbackToSnapshotProcedure
implements Provider<Procedure> {
    private static final MethodHandle ROLLBACK_TO_SNAPSHOT;
    private final TrinoCatalogFactory catalogFactory;

    @Inject
    public RollbackToSnapshotProcedure(TrinoCatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "rollback_to_snapshot", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("SNAPSHOT_ID", (Type)BigintType.BIGINT)), ROLLBACK_TO_SNAPSHOT.bindTo(this));
    }

    public void rollbackToSnapshot(ConnectorSession clientSession, String schema, String table, Long snapshotId) {
        Procedures.checkProcedureArgument((schema != null ? 1 : 0) != 0, (String)"schema cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((table != null ? 1 : 0) != 0, (String)"table cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((snapshotId != null ? 1 : 0) != 0, (String)"snapshot_id cannot be null", (Object[])new Object[0]);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            SchemaTableName schemaTableName = new SchemaTableName(schema, table);
            BaseTable icebergTable = this.catalogFactory.create(clientSession.getIdentity()).loadTable(clientSession, schemaTableName);
            icebergTable.manageSnapshots().setCurrentSnapshot(snapshotId.longValue()).commit();
        }
    }

    static {
        try {
            ROLLBACK_TO_SNAPSHOT = MethodHandles.lookup().unreflect(RollbackToSnapshotProcedure.class.getMethod("rollbackToSnapshot", ConnectorSession.class, String.class, String.class, Long.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

