/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.system;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IcebergTablesSystemTable
implements SystemTable {
    private static final SchemaTableName NAME = new SchemaTableName("system", "iceberg_tables");
    private static final ConnectorTableMetadata METADATA = new ConnectorTableMetadata(NAME, (List)ImmutableList.builder().add((Object)new ColumnMetadata("table_schema", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("table_name", (Type)VarcharType.VARCHAR)).build());
    private final TrinoCatalogFactory catalogFactory;

    @Inject
    public IcebergTablesSystemTable(TrinoCatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint, Set<Integer> requiredColumns, ConnectorSplit split, ConnectorAccessControl accessControl) {
        InMemoryRecordSet.Builder result = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        Domain schemaDomain = constraint.getDomain((Object)0, (Type)VarcharType.VARCHAR);
        Optional<String> schemaFilter = IcebergTablesSystemTable.tryGetSingleVarcharValue(schemaDomain);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            TrinoCatalog catalog = this.catalogFactory.create(connectorSession.getIdentity());
            List<SchemaTableName> icebergTables = catalog.listIcebergTables(connectorSession, schemaFilter);
            Set accessibleIcebergTables = accessControl.filterTables(null, (Set)ImmutableSet.copyOf(icebergTables));
            for (SchemaTableName table : accessibleIcebergTables) {
                result.addRow(new Object[]{table.getSchemaName(), table.getTableName()});
            }
            RecordCursor recordCursor = result.build().cursor();
            return recordCursor;
        }
    }

    private static <T> Optional<String> tryGetSingleVarcharValue(Domain domain) {
        if (!domain.isSingleValue()) {
            return Optional.empty();
        }
        Object value = domain.getSingleValue();
        return Optional.of(((Slice)value).toStringUtf8());
    }
}

