/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class OrcTypeConverter {
    public static final String ORC_ICEBERG_ID_KEY = "iceberg.id";
    public static final String ORC_ICEBERG_REQUIRED_KEY = "iceberg.required";
    public static final String ICEBERG_LONG_TYPE = "iceberg.long-type";
    public static final String ICEBERG_BINARY_TYPE = "iceberg.binary-type";

    private OrcTypeConverter() {
    }

    public static ColumnMetadata<OrcType> toOrcType(Schema schema) {
        return new ColumnMetadata(OrcTypeConverter.toOrcStructType(0, schema.asStruct(), (Map<String, String>)ImmutableMap.of()));
    }

    private static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type, Map<String, String> attributes) {
        return switch (type.typeId()) {
            default -> throw new MatchException(null, null);
            case Type.TypeID.BOOLEAN -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BOOLEAN, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.INTEGER -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.LONG -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.FLOAT -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.FLOAT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.DOUBLE -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DOUBLE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.DATE -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DATE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.TIME -> {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)ICEBERG_LONG_TYPE, (Object)"TIME").buildOrThrow();
                yield ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case Type.TypeID.TIMESTAMP -> {
                OrcType.OrcTypeKind timestampKind = ((Types.TimestampType)type).shouldAdjustToUTC() ? OrcType.OrcTypeKind.TIMESTAMP_INSTANT : OrcType.OrcTypeKind.TIMESTAMP;
                yield ImmutableList.of((Object)new OrcType(timestampKind, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case Type.TypeID.TIMESTAMP_NANO -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Iceberg type: TIMESTAMP_NANO");
            case Type.TypeID.STRING -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.STRING, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.FIXED, Type.TypeID.BINARY -> ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            case Type.TypeID.DECIMAL -> {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                yield ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DECIMAL, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.of(decimalType.precision()), Optional.of(decimalType.scale()), (Map)attributes));
            }
            case Type.TypeID.UUID -> {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)ICEBERG_BINARY_TYPE, (Object)"UUID").buildOrThrow();
                yield ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case Type.TypeID.VARIANT, Type.TypeID.GEOMETRY, Type.TypeID.GEOGRAPHY, Type.TypeID.UNKNOWN -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Iceberg type: " + String.valueOf(type));
            case Type.TypeID.STRUCT -> OrcTypeConverter.toOrcStructType(nextFieldTypeIndex, (Types.StructType)type, attributes);
            case Type.TypeID.LIST -> OrcTypeConverter.toOrcListType(nextFieldTypeIndex, (Types.ListType)type, attributes);
            case Type.TypeID.MAP -> OrcTypeConverter.toOrcMapType(nextFieldTypeIndex, (Types.MapType)type, attributes);
        };
    }

    private static List<OrcType> toOrcStructType(int nextFieldTypeIndex, Types.StructType structType, Map<String, String> attributes) {
        ++nextFieldTypeIndex;
        ArrayList<OrcColumnId> fieldTypeIndexes = new ArrayList<OrcColumnId>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Types.NestedField field : structType.fields()) {
            fieldTypeIndexes.add(new OrcColumnId(nextFieldTypeIndex));
            fieldNames.add(field.name());
            ImmutableMap fieldAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(field.fieldId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(field.isRequired())).buildOrThrow();
            List<OrcType> fieldOrcTypes = OrcTypeConverter.toOrcType(nextFieldTypeIndex, field.type(), (Map<String, String>)fieldAttributes);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        return ImmutableList.builder().add((Object)new OrcType(OrcType.OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty(), attributes)).addAll(fieldTypesList.stream().flatMap(Collection::stream).iterator()).build();
    }

    private static List<OrcType> toOrcListType(int nextFieldTypeIndex, Types.ListType listType, Map<String, String> attributes) {
        ImmutableMap elementAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(listType.elementId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(listType.isElementRequired())).buildOrThrow();
        List<OrcType> itemTypes = OrcTypeConverter.toOrcType(++nextFieldTypeIndex, listType.elementType(), (Map<String, String>)elementAttributes);
        return ImmutableList.builder().add((Object)new OrcType(OrcType.OrcTypeKind.LIST, (List)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex)), (List)ImmutableList.of((Object)"item"), Optional.empty(), Optional.empty(), Optional.empty(), attributes)).addAll(itemTypes).build();
    }

    private static List<OrcType> toOrcMapType(int nextFieldTypeIndex, Types.MapType mapType, Map<String, String> attributes) {
        List<OrcType> keyTypes = OrcTypeConverter.toOrcType(++nextFieldTypeIndex, mapType.keyType(), (Map<String, String>)ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.keyId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(true)).buildOrThrow());
        ImmutableMap valueAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.valueId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(mapType.isValueRequired())).buildOrThrow();
        List<OrcType> valueTypes = OrcTypeConverter.toOrcType(nextFieldTypeIndex + keyTypes.size(), mapType.valueType(), (Map<String, String>)valueAttributes);
        return ImmutableList.builder().add((Object)new OrcType(OrcType.OrcTypeKind.MAP, (List)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex), (Object)new OrcColumnId(nextFieldTypeIndex + keyTypes.size())), (List)ImmutableList.of((Object)"key", (Object)"value"), Optional.empty(), Optional.empty(), Optional.empty(), attributes)).addAll(keyTypes).addAll(valueTypes).build();
    }
}

