/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetUtil {
    private ParquetUtil() {
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig) throws ParquetCorruptionException {
        return ParquetUtil.footerMetrics(metadata, fieldMetrics, metricsConfig, null);
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig, NameMapping nameMapping) throws ParquetCorruptionException {
        Objects.requireNonNull(fieldMetrics, "fieldMetrics should not be null");
        long rowCount = 0L;
        HashMap<Integer, Long> columnSizes = new HashMap<Integer, Long>();
        HashMap<Integer, Long> valueCounts = new HashMap<Integer, Long>();
        HashMap<Integer, Long> nullValueCounts = new HashMap<Integer, Long>();
        HashMap lowerBounds = new HashMap();
        HashMap upperBounds = new HashMap();
        HashSet<Integer> missingStats = new HashSet<Integer>();
        MessageType parquetTypeWithIds = ParquetUtil.getParquetTypeWithIds(metadata, nameMapping);
        Schema fileSchema = ParquetSchemaUtil.convertAndPrune((MessageType)parquetTypeWithIds);
        Map<Integer, FieldMetrics<?>> fieldMetricsMap = fieldMetrics.collect(Collectors.toMap(FieldMetrics::id, Function.identity()));
        List blocks = metadata.getBlocks();
        for (BlockMetadata block : blocks) {
            rowCount += block.rowCount();
            for (ColumnChunkMetadata column : block.columns()) {
                Integer fieldId = fileSchema.aliasToId(column.getPath().toDotString());
                if (fieldId == null) continue;
                ParquetUtil.increment(columnSizes, fieldId, column.getTotalSize());
                MetricsModes.MetricsMode metricsMode = MetricsUtil.metricsMode((Schema)fileSchema, (MetricsConfig)metricsConfig, (int)fieldId);
                if (metricsMode == MetricsModes.None.get()) continue;
                ParquetUtil.increment(valueCounts, fieldId, column.getValueCount());
                Statistics stats = column.getStatistics();
                if (stats != null && !stats.isEmpty()) {
                    Types.NestedField field;
                    ParquetUtil.increment(nullValueCounts, fieldId, stats.getNumNulls());
                    if (metricsMode == MetricsModes.Counts.get() || fieldMetricsMap.containsKey(fieldId) || (field = fileSchema.findField(fieldId.intValue())) == null || !stats.hasNonNullValue() || !ParquetUtil.shouldStoreBounds(column, fileSchema)) continue;
                    Literal min = ParquetUtil.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMin());
                    ParquetUtil.updateMin(lowerBounds, fieldId, field.type(), min, metricsMode);
                    Literal max = ParquetUtil.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMax());
                    ParquetUtil.updateMax(upperBounds, fieldId, field.type(), max, metricsMode);
                    continue;
                }
                missingStats.add(fieldId);
            }
        }
        for (Integer fieldId : missingStats) {
            nullValueCounts.remove(fieldId);
            lowerBounds.remove(fieldId);
            upperBounds.remove(fieldId);
        }
        ParquetUtil.updateFromFieldMetrics(fieldMetricsMap, metricsConfig, fileSchema, lowerBounds, upperBounds);
        return new Metrics(Long.valueOf(rowCount), columnSizes, valueCounts, nullValueCounts, MetricsUtil.createNanValueCounts(fieldMetricsMap.values().stream(), (MetricsConfig)metricsConfig, (Schema)fileSchema), ParquetUtil.toBufferMap(fileSchema, lowerBounds), ParquetUtil.toBufferMap(fileSchema, upperBounds));
    }

    public static List<Long> getSplitOffsets(ParquetMetadata metadata) throws ParquetCorruptionException {
        List blocks = metadata.getBlocks();
        ArrayList<Long> splitOffsets = new ArrayList<Long>(blocks.size());
        for (BlockMetadata blockMetaData : blocks) {
            splitOffsets.add(blockMetaData.getStartingPos());
        }
        Collections.sort(splitOffsets);
        return ImmutableList.copyOf(splitOffsets);
    }

    private static void updateFromFieldMetrics(Map<Integer, FieldMetrics<?>> idToFieldMetricsMap, MetricsConfig metricsConfig, Schema schema, Map<Integer, Literal<?>> lowerBounds, Map<Integer, Literal<?>> upperBounds) {
        idToFieldMetricsMap.entrySet().forEach(entry -> {
            int fieldId = (Integer)entry.getKey();
            FieldMetrics metrics = (FieldMetrics)entry.getValue();
            MetricsModes.MetricsMode metricsMode = MetricsUtil.metricsMode((Schema)schema, (MetricsConfig)metricsConfig, (int)fieldId);
            if (metricsMode != MetricsModes.None.get()) {
                if (!metrics.hasBounds()) {
                    lowerBounds.remove(fieldId);
                    upperBounds.remove(fieldId);
                } else if (metrics.upperBound() instanceof Float) {
                    lowerBounds.put(fieldId, Literal.of((float)((Float)metrics.lowerBound()).floatValue()));
                    upperBounds.put(fieldId, Literal.of((float)((Float)metrics.upperBound()).floatValue()));
                } else if (metrics.upperBound() instanceof Double) {
                    lowerBounds.put(fieldId, Literal.of((double)((Double)metrics.lowerBound())));
                    upperBounds.put(fieldId, Literal.of((double)((Double)metrics.upperBound())));
                } else {
                    throw new UnsupportedOperationException("Expected only float or double column metrics");
                }
            }
        });
    }

    private static MessageType getParquetTypeWithIds(ParquetMetadata metadata, NameMapping nameMapping) {
        MessageType type = metadata.getFileMetaData().getSchema();
        if (ParquetSchemaUtil.hasIds((MessageType)type)) {
            return type;
        }
        if (nameMapping != null) {
            return ParquetSchemaUtil.applyNameMapping((MessageType)type, (NameMapping)nameMapping);
        }
        return ParquetSchemaUtil.addFallbackIds((MessageType)type);
    }

    private static boolean shouldStoreBounds(ColumnChunkMetadata column, Schema schema) {
        if (column.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return false;
        }
        ColumnPath columnPath = column.getPath();
        Iterator pathIterator = columnPath.iterator();
        Types.StructType currentType = schema.asStruct();
        while (pathIterator.hasNext()) {
            if (currentType == null || !currentType.isStructType()) {
                return false;
            }
            String fieldName = (String)pathIterator.next();
            currentType = currentType.asStructType().fieldType(fieldName);
        }
        return currentType != null && currentType.isPrimitiveType();
    }

    private static void increment(Map<Integer, Long> columns, int fieldId, long amount) {
        if (columns != null) {
            if (columns.containsKey(fieldId)) {
                columns.put(fieldId, columns.get(fieldId) + amount);
            } else {
                columns.put(fieldId, amount);
            }
        }
    }

    private static <T> void updateMin(Map<Integer, Literal<?>> lowerBounds, int id, Type type, Literal<T> min, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMin = lowerBounds.get(id);
        if (currentMin == null || min.comparator().compare(min.value(), currentMin.value()) < 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                lowerBounds.put(id, min);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        lowerBounds.put(id, UnicodeUtil.truncateStringMin(min, (int)truncateLength));
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        lowerBounds.put(id, BinaryUtil.truncateBinaryMin(min, (int)truncateLength));
                        break;
                    }
                    default: {
                        lowerBounds.put(id, min);
                    }
                }
            }
        }
    }

    private static <T> void updateMax(Map<Integer, Literal<?>> upperBounds, int id, Type type, Literal<T> max, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMax = upperBounds.get(id);
        if (currentMax == null || max.comparator().compare(max.value(), currentMax.value()) > 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                upperBounds.put(id, max);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        Literal truncatedMaxString = UnicodeUtil.truncateStringMax(max, (int)truncateLength);
                        if (truncatedMaxString == null) break;
                        upperBounds.put(id, truncatedMaxString);
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        Literal truncatedMaxBinary = BinaryUtil.truncateBinaryMax(max, (int)truncateLength);
                        if (truncatedMaxBinary == null) break;
                        upperBounds.put(id, truncatedMaxBinary);
                        break;
                    }
                    default: {
                        upperBounds.put(id, max);
                    }
                }
            }
        }
    }

    private static Map<Integer, ByteBuffer> toBufferMap(Schema schema, Map<Integer, Literal<?>> map) {
        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
        for (Map.Entry<Integer, Literal<?>> entry : map.entrySet()) {
            bufferMap.put(entry.getKey(), Conversions.toByteBuffer((Type)schema.findType(entry.getKey().intValue()), (Object)entry.getValue().value()));
        }
        return bufferMap;
    }

    public static <T> Literal<T> fromParquetPrimitive(Type type, PrimitiveType parquetType, Object value) {
        return switch (type.typeId()) {
            case Type.TypeID.BOOLEAN -> Literal.of((boolean)((Boolean)value));
            case Type.TypeID.INTEGER, Type.TypeID.DATE -> Literal.of((int)((Integer)value));
            case Type.TypeID.LONG, Type.TypeID.TIME, Type.TypeID.TIMESTAMP -> Literal.of((long)((Long)value));
            case Type.TypeID.FLOAT -> Literal.of((float)((Float)value).floatValue());
            case Type.TypeID.DOUBLE -> Literal.of((double)((Double)value));
            case Type.TypeID.STRING -> {
                Function<Object, Object> stringConversion = ParquetUtil.converterFromParquet(parquetType);
                yield Literal.of((CharSequence)((CharSequence)stringConversion.apply(value)));
            }
            case Type.TypeID.UUID -> {
                Function<Object, Object> uuidConversion = ParquetUtil.converterFromParquet(parquetType);
                yield Literal.of((UUID)((UUID)uuidConversion.apply(value)));
            }
            case Type.TypeID.FIXED, Type.TypeID.BINARY -> {
                Function<Object, Object> binaryConversion = ParquetUtil.converterFromParquet(parquetType);
                yield Literal.of((ByteBuffer)((ByteBuffer)binaryConversion.apply(value)));
            }
            case Type.TypeID.DECIMAL -> {
                Function<Object, Object> decimalConversion = ParquetUtil.converterFromParquet(parquetType);
                yield Literal.of((BigDecimal)((BigDecimal)decimalConversion.apply(value)));
            }
            default -> throw new IllegalArgumentException("Unsupported primitive type: " + String.valueOf(type));
        };
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
                    int scale = decimal.getScale();
                    return switch (type.getPrimitiveTypeName()) {
                        case PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64 -> number -> BigDecimal.valueOf(((Number)number).longValue(), scale);
                        case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.BINARY -> binary -> new BigDecimal(new BigInteger(((Binary)binary).getBytes()), scale);
                        default -> throw new IllegalArgumentException("Unsupported primitive type for decimal: " + String.valueOf(type.getPrimitiveTypeName()));
                    };
                }
            }
        }
        return switch (type.getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.BINARY -> binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            case PrimitiveType.PrimitiveTypeName.INT96 -> binary -> org.apache.iceberg.parquet.ParquetUtil.extractTimestampInt96((ByteBuffer)ByteBuffer.wrap(((Binary)binary).getBytes()).order(ByteOrder.LITTLE_ENDIAN));
            default -> obj -> obj;
        };
    }
}

