/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import com.google.common.base.Preconditions;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.snowflake.TrinoSnowflakeCatalog;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.snowflake.SnowflakeTableOperations;

public class SnowflakeIcebergTableOperations
extends AbstractIcebergTableOperations {
    private final SnowflakeTableOperations icebergSnowflakeTableOperations;

    public SnowflakeIcebergTableOperations(TrinoSnowflakeCatalog trinoSnowflakeCatalog, FileIO fileIo, ConnectorSession session, String snowflakeDatabase, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{snowflakeDatabase, database}), (String)table);
        this.icebergSnowflakeTableOperations = Objects.requireNonNull((SnowflakeTableOperations)trinoSnowflakeCatalog.getSnowflakeCatalog().newTableOps(tableIdentifier), "snowflakeTableOperations is null");
    }

    @Override
    public void initializeFromMetadata(TableMetadata tableMetadata) {
        Preconditions.checkState((this.currentMetadata == null ? 1 : 0) != 0, (Object)"already initialized");
        this.currentMetadata = tableMetadata;
        this.currentMetadataLocation = tableMetadata.metadataFileLocation();
        this.shouldRefresh = false;
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        if (invalidateCaches) {
            this.icebergSnowflakeTableOperations.refresh();
            return this.icebergSnowflakeTableOperations.currentMetadataLocation();
        }
        String location = this.icebergSnowflakeTableOperations.currentMetadataLocation();
        if (Objects.isNull(location)) {
            this.icebergSnowflakeTableOperations.refresh();
            return this.icebergSnowflakeTableOperations.currentMetadataLocation();
        }
        return location;
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    protected void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }
}

