/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.ignite.IgniteOutputTableHandle;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IgniteMetadata
extends DefaultJdbcMetadata {
    private static final String IGNITE_DUMMY_ID = "dummy_id";
    private final JdbcClient igniteClient;

    @Inject
    public IgniteMetadata(JdbcClient igniteClient, Set<JdbcQueryEventListener> jdbcQueryEventListeners) {
        super(igniteClient, false, jdbcQueryEventListeners);
        this.igniteClient = Objects.requireNonNull(igniteClient, "igniteClient is null");
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.igniteClient.getTableHandle(session, schemaTableName).map(JdbcTableHandle::asPlainTable).map(JdbcNamedRelationHandle::getRemoteTableName).map(remoteTableName -> new JdbcTableHandle(schemaTableName, new RemoteTableName(remoteTableName.getCatalogName(), Optional.of(remoteTableName.getSchemaName().orElse("public")), remoteTableName.getTableName()), Optional.empty())).orElse(null);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Optional<String> dummyIdColumn = this.igniteClient.getColumns(session, handle).stream().map(JdbcColumnHandle::getColumnName).filter(IGNITE_DUMMY_ID::equalsIgnoreCase).findFirst();
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder columnJdbcTypeHandles = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
            columnNames.add((Object)columnHandle.getColumnName());
            columnTypes.add((Object)columnHandle.getColumnType());
            columnJdbcTypeHandles.add((Object)columnHandle.getJdbcTypeHandle());
        }
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        return new IgniteOutputTableHandle(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName(), (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(columnJdbcTypeHandles.build()), dummyIdColumn);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableMetadata(handle.getRequiredNamedRelation().getSchemaTableName(), this.getColumnMetadata(session, handle), this.igniteClient.getTableProperties(session, handle));
    }

    private List<ColumnMetadata> getColumnMetadata(ConnectorSession session, JdbcTableHandle handle) {
        return (List)this.igniteClient.getColumns(session, handle).stream().filter(column -> !IGNITE_DUMMY_ID.equalsIgnoreCase(column.getColumnName())).map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableSchema(handle.getRequiredNamedRelation().getSchemaTableName(), (List)this.getColumnMetadata(session, handle).stream().map(ColumnMetadata::getColumnSchema).collect(ImmutableList.toImmutableList()));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.igniteClient.beginCreateTable(session, tableMetadata);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        return this.igniteClient.beginCreateTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata) {
        if (!columnMetadata.isNullable()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding not null columns");
        }
        JdbcTableHandle handle = (JdbcTableHandle)table;
        this.igniteClient.addColumn(session, handle, columnMetadata);
    }
}

