/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DecimalType;
import java.util.Optional;

public class ImplementAvgDecimal
implements AggregateFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"avg")).with(AggregateFunctionPatterns.singleArgument().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(DecimalType.class::isInstance)).capturedAs(ARGUMENT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(argument.getName());
        DecimalType type = (DecimalType)columnHandle.getColumnType();
        Verify.verify((boolean)aggregateFunction.getOutputType().equals((Object)type));
        ParameterizedExpression rewrittenArgument = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument).orElseThrow();
        return Optional.of(new JdbcExpression(String.format("CAST(sum(%s) / count(%1$s) AS decimal(%s, %s))", rewrittenArgument.expression(), type.getPrecision() + 1, type.getScale()), rewrittenArgument.parameters(), columnHandle.getJdbcTypeHandle()));
    }
}

