/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.dump;

import java.io.File;
import java.time.Duration;
import org.apache.ignite.dump.DumpConsumer;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.spi.encryption.EncryptionSpi;

@IgniteExperimental
public class DumpReaderConfiguration {
    public static final Duration DFLT_TIMEOUT = Duration.ofDays(7L);
    public static final int DFLT_THREAD_CNT = 1;
    private final File dir;
    private final DumpConsumer cnsmr;
    private final int thCnt;
    private final Duration timeout;
    private final boolean failFast;
    private final boolean keepBinary;
    private String[] cacheGroupNames;
    private final boolean skipCopies;
    private final EncryptionSpi encSpi;

    public DumpReaderConfiguration(File dir, DumpConsumer cnsmr) {
        this(dir, cnsmr, 1, DFLT_TIMEOUT, true, true, null, false, null);
    }

    public DumpReaderConfiguration(File dir, DumpConsumer cnsmr, int thCnt, Duration timeout, boolean failFast, boolean keepBinary, String[] cacheGroupNames, boolean skipCopies, EncryptionSpi encSpi) {
        this.dir = dir;
        this.cnsmr = cnsmr;
        this.thCnt = thCnt;
        this.timeout = timeout;
        this.failFast = failFast;
        this.keepBinary = keepBinary;
        this.cacheGroupNames = cacheGroupNames;
        this.skipCopies = skipCopies;
        this.encSpi = encSpi;
    }

    public File dumpRoot() {
        return this.dir;
    }

    public DumpConsumer consumer() {
        return this.cnsmr;
    }

    public int threadCount() {
        return this.thCnt;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public boolean failFast() {
        return this.failFast;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public String[] cacheGroupNames() {
        return this.cacheGroupNames;
    }

    public boolean skipCopies() {
        return this.skipCopies;
    }

    public EncryptionSpi encryptionSpi() {
        return this.encSpi;
    }
}

