/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.IORowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;

public abstract class AbstractLeafIO
extends BPlusLeafIO<IndexRow>
implements InlineIO {
    AbstractLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, IndexRow row) {
        assert (row.link() != 0L);
        this.assertPageType(pageAddr);
        IORowHandler.store(pageAddr, off, row, this.storeMvccInfo());
    }

    @Override
    public IndexRow getLookupRow(BPlusTree<IndexRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = PageUtils.getLong(pageAddr, this.offset(idx));
        assert (link != 0L);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.mvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.mvccCounter(pageAddr, idx);
            int mvccOpCntr = this.mvccOperationCounter(pageAddr, idx);
            return ((InlineIndexTree)tree).createMvccIndexRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((InlineIndexTree)tree).createIndexRow(link);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<IndexRow> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        IORowHandler.store(dstPageAddr, this.offset(dstIdx), (InlineIO)((Object)srcIo), srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    @Override
    public long link(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public int inlineSize() {
        return 0;
    }
}

