/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cdc.CdcCacheEvent;
import org.apache.ignite.cdc.CdcConfiguration;
import org.apache.ignite.cdc.TypeMapping;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cdc.CdcConsumerState;
import org.apache.ignite.internal.cdc.CdcFileLockHolder;
import org.apache.ignite.internal.cdc.CdcMode;
import org.apache.ignite.internal.cdc.TypeMappingImpl;
import org.apache.ignite.internal.cdc.WalRecordsConsumer;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.CdcManagerRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderResolver;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.platform.PlatformType;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.jmx.JmxMetricExporterSpi;
import org.apache.ignite.spi.metric.noop.NoopMetricExporterSpi;

public class CdcMain
implements Runnable {
    public static final String ERR_MSG = "Persistence and CDC disabled. Capture Data Change can't run!";
    public static final String STATE_DIR = "state";
    public static final String CUR_SEG_IDX = "CurrentSegmentIndex";
    public static final String COMMITTED_SEG_IDX = "CommittedSegmentIndex";
    public static final String COMMITTED_SEG_OFFSET = "CommittedSegmentOffset";
    public static final String LAST_SEG_CONSUMPTION_TIME = "LastSegmentConsumptionTime";
    public static final String META_UPDATE = "MetadataUpdateTime";
    public static final String BINARY_META_DIR = "BinaryMetaDir";
    public static final String MARSHALLER_DIR = "MarshallerDir";
    public static final String CDC_DIR = "CdcDir";
    public static final String CDC_MODE = "CdcMode";
    private static final IgniteBiPredicate<WALRecord.RecordType, WALPointer> PASSIVE_RECS = (type, ptr) -> type == WALRecord.RecordType.CDC_MANAGER_STOP_RECORD || type == WALRecord.RecordType.CDC_MANAGER_RECORD;
    private static final IgniteBiPredicate<WALRecord.RecordType, WALPointer> ACTIVE_RECS = (type, ptr) -> type == WALRecord.RecordType.DATA_RECORD_V2 || type == WALRecord.RecordType.CDC_DATA_RECORD;
    private final IgniteConfiguration igniteCfg;
    private final GridSpringResourceContext ctx;
    private MetricRegistry mreg;
    private AtomicLongMetric curSegmentIdx;
    private AtomicLongMetric committedSegmentIdx;
    private AtomicLongMetric committedSegmentOffset;
    private AtomicLongMetric lastSegmentConsumptionTs;
    private HistogramMetricImpl metaUpdate;
    protected final CdcConfiguration cdcCfg;
    private final WalRecordsConsumer<?, ?> consumer;
    private final IgniteLogger log;
    private Path cdcDir;
    private File dbDir;
    private File binaryMeta;
    private File marshaller;
    private StandaloneGridKernalContext kctx;
    private CdcConsumerState state;
    private T2<WALPointer, Integer> walState;
    private Map<Integer, Long> typesState;
    private Set<T2<Integer, Byte>> mappingsState;
    private Map<Integer, Long> cachesState;
    private volatile CdcMode cdcModeState;
    private volatile boolean started;
    private volatile boolean stopped;
    private final Set<Path> processedSegments = new HashSet<Path>();

    public CdcMain(IgniteConfiguration cfg, GridSpringResourceContext ctx, CdcConfiguration cdcCfg) {
        this.igniteCfg = new IgniteConfiguration(cfg);
        this.ctx = ctx;
        this.cdcCfg = cdcCfg;
        try {
            U.initWorkDir(this.igniteCfg);
            this.log = U.initLogger(this.igniteCfg, "ignite-cdc");
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        this.consumer = new WalRecordsConsumer(cdcCfg.getConsumer(), this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CdcMain cdcMain = this;
        synchronized (cdcMain) {
            if (this.stopped) {
                return;
            }
        }
        try {
            this.runX();
        }
        catch (Throwable e) {
            this.log.error("Cdc error", e);
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runX() throws Exception {
        this.ackAsciiLogo();
        if (!CU.isCdcEnabled(this.igniteCfg)) {
            this.log.error(ERR_MSG);
            throw new IllegalArgumentException(ERR_MSG);
        }
        try (CdcFileLockHolder lock = this.lockPds();){
            String consIdDir = this.cdcDir.getName(this.cdcDir.getNameCount() - 1).toString();
            Files.createDirectories(this.cdcDir.resolve(STATE_DIR), new FileAttribute[0]);
            this.binaryMeta = CacheObjectBinaryProcessorImpl.binaryWorkDir(this.igniteCfg.getWorkDirectory(), consIdDir);
            this.marshaller = MarshallerContextImpl.mappingFileStoreWorkDir(this.igniteCfg.getWorkDirectory());
            if (this.log.isInfoEnabled()) {
                this.log.info("Change Data Capture [dir=" + this.cdcDir + ']');
                this.log.info("Ignite node Binary meta [dir=" + this.binaryMeta + ']');
                this.log.info("Ignite node Marshaller [dir=" + this.marshaller + ']');
            }
            this.kctx = this.startStandaloneKernal();
            this.initMetrics();
            try {
                this.kctx.resource().injectGeneric(this.consumer.consumer());
                this.state = this.createState(this.cdcDir.resolve(STATE_DIR));
                this.walState = this.state.loadWalState();
                this.typesState = this.state.loadTypesState();
                this.mappingsState = this.state.loadMappingsState();
                this.cachesState = this.state.loadCaches();
                this.cdcModeState = this.state.loadCdcMode();
                if (this.walState != null) {
                    this.committedSegmentIdx.value(((WALPointer)this.walState.get1()).index());
                    this.committedSegmentOffset.value(((WALPointer)this.walState.get1()).fileOffset());
                }
                this.consumer.start(this.mreg, this.kctx.metric().registry(MetricUtils.metricName("cdc", "consumer")));
                this.started = true;
                try {
                    this.consumeWalSegmentsUntilStopped();
                }
                finally {
                    this.stop();
                }
            }
            finally {
                StandaloneGridKernalContext.closeAllComponents(this.kctx);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Ignite Change Data Capture Application stopped.");
                }
            }
        }
    }

    protected CdcConsumerState createState(Path stateDir) {
        return new CdcConsumerState(this.log, stateDir);
    }

    private StandaloneGridKernalContext startStandaloneKernal() throws IgniteCheckedException {
        StandaloneGridKernalContext kctx = new StandaloneGridKernalContext(this.log, this.binaryMeta, this.marshaller){

            @Override
            protected IgniteConfiguration prepareIgniteConfiguration() {
                IgniteConfiguration cfg = super.prepareIgniteConfiguration();
                cfg.setIgniteInstanceName(CdcMain.cdcInstanceName(CdcMain.this.igniteCfg.getIgniteInstanceName()));
                cfg.setWorkDirectory(CdcMain.this.igniteCfg.getWorkDirectory());
                if (!F.isEmpty(CdcMain.this.cdcCfg.getMetricExporterSpi())) {
                    cfg.setMetricExporterSpi(CdcMain.this.cdcCfg.getMetricExporterSpi());
                } else {
                    cfg.setMetricExporterSpi(new MetricExporterSpi[]{U.IGNITE_MBEANS_DISABLED ? new NoopMetricExporterSpi() : new JmxMetricExporterSpi()});
                }
                IgnitionEx.initializeDefaultMBeanServer(cfg);
                return cfg;
            }

            @Override
            public String igniteInstanceName() {
                return this.config().getIgniteInstanceName();
            }
        };
        kctx.resource().setSpringContext(this.ctx);
        StandaloneGridKernalContext.startAllComponents(kctx);
        this.mreg = kctx.metric().registry("cdc");
        return kctx;
    }

    private void initMetrics() {
        this.mreg.objectMetric(BINARY_META_DIR, String.class, "Binary meta directory").value(this.binaryMeta.getAbsolutePath());
        this.mreg.objectMetric(MARSHALLER_DIR, String.class, "Marshaller directory").value(this.marshaller.getAbsolutePath());
        this.mreg.objectMetric(CDC_DIR, String.class, "CDC directory").value(this.cdcDir.toFile().getAbsolutePath());
        this.curSegmentIdx = this.mreg.longMetric(CUR_SEG_IDX, "Current segment index");
        this.committedSegmentIdx = this.mreg.longMetric(COMMITTED_SEG_IDX, "Committed segment index");
        this.committedSegmentOffset = this.mreg.longMetric(COMMITTED_SEG_OFFSET, "Committed segment offset");
        this.lastSegmentConsumptionTs = this.mreg.longMetric(LAST_SEG_CONSUMPTION_TIME, "Last time of consumption of WAL segment");
        this.metaUpdate = this.mreg.histogram(META_UPDATE, new long[]{100L, 500L, 1000L}, "Metadata update time");
        this.mreg.register(CDC_MODE, () -> this.cdcModeState.name(), String.class, "CDC mode");
    }

    private CdcFileLockHolder lockPds() throws IgniteCheckedException {
        File consIdDir;
        PdsFolderSettings<CdcFileLockHolder> settings = new PdsFolderResolver<CdcFileLockHolder>(this.igniteCfg, this.log, this.igniteCfg.getConsistentId(), this::tryLock).resolve();
        if (settings == null) {
            throw new IgniteException("Can't find the folder to read WAL segments from! [workDir=" + this.igniteCfg.getWorkDirectory() + ", consistentId=" + this.igniteCfg.getConsistentId() + ']');
        }
        CdcFileLockHolder lock = settings.getLockedFileLockHolder();
        if (lock == null && (lock = this.tryLock(consIdDir = settings.persistentStoreNodePath())) == null) {
            throw new IgniteException("Can't acquire lock for Change Data Capture folder [dir=" + consIdDir.getAbsolutePath() + ']');
        }
        return lock;
    }

    public void consumeWalSegmentsUntilStopped() {
        try {
            HashSet<Path> seen = new HashSet<Path>();
            AtomicLong lastSgmnt = new AtomicLong(-1L);
            while (!this.stopped) {
                if (!this.consumer.alive()) {
                    this.log.warning("Consumer is not alive. Ignite Change Data Capture Application will be stopped.");
                    return;
                }
                try (Stream<Path> cdcFiles = Files.list(this.cdcDir);){
                    HashSet exists = new HashSet();
                    Iterator segments = cdcFiles.peek(exists::add).filter(p -> FileWriteAheadLogManager.WAL_SEGMENT_FILE_FILTER.accept(p.toFile()) && !seen.contains(p)).peek(seen::add).sorted(Comparator.comparingLong(FileWriteAheadLogManager::segmentIndex)).peek(p -> {
                        long nextSgmnt = FileWriteAheadLogManager.segmentIndex(p);
                        if (lastSgmnt.get() != -1L && nextSgmnt - lastSgmnt.get() != 1L) {
                            throw new IgniteException("Found missed segments. Some events are missed. Exiting! [lastSegment=" + lastSgmnt.get() + ", nextSegment=" + nextSgmnt + ']');
                        }
                        lastSgmnt.set(nextSgmnt);
                    }).iterator();
                    while (segments.hasNext()) {
                        Path segment = (Path)segments.next();
                        if (this.walState != null && this.removeProcessedOnFailover(segment)) continue;
                        if (this.consumeSegment(segment)) {
                            seen.clear();
                            lastSgmnt.set(-1L);
                            this.walState = this.state.loadWalState();
                            break;
                        }
                        this.walState = null;
                    }
                    seen.removeIf(p -> !exists.contains(p));
                    if (lastSgmnt.get() == -1L) {
                        this.updateMetadata();
                    }
                }
                if (this.stopped) continue;
                U.sleep(this.cdcCfg.getCheckFrequency());
            }
        }
        catch (IOException | IgniteInterruptedCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private boolean consumeSegment(Path segment) {
        this.updateMetadata();
        if (this.log.isInfoEnabled()) {
            this.log.info("Processing WAL segment [segment=" + segment + ']');
        }
        IgniteWalIteratorFactory.IteratorParametersBuilder builder = new IgniteWalIteratorFactory.IteratorParametersBuilder().log(this.log).binaryMetadataFileStoreDir(this.binaryMeta).marshallerMappingFileStoreDir(this.marshaller).igniteConfigurationModifier(cfg -> cfg.setPluginProviders(this.igniteCfg.getPluginProviders())).keepBinary(this.cdcCfg.isKeepBinary()).filesOrDirs(segment.toFile());
        if (this.igniteCfg.getDataStorageConfiguration().getPageSize() != 0) {
            builder.pageSize(this.igniteCfg.getDataStorageConfiguration().getPageSize());
        }
        if (this.walState != null) {
            builder.from((WALPointer)this.walState.get1());
        }
        long segmentIdx = FileWriteAheadLogManager.segmentIndex(segment);
        this.lastSegmentConsumptionTs.value(System.currentTimeMillis());
        this.curSegmentIdx.value(segmentIdx);
        if (this.cdcModeState == CdcMode.IGNITE_NODE_ACTIVE) {
            if (this.consumeSegmentPassively(builder)) {
                return true;
            }
        } else {
            this.consumeSegmentActively(builder);
        }
        this.processedSegments.add(segment);
        return false;
    }

    private void consumeSegmentActively(IgniteWalIteratorFactory.IteratorParametersBuilder builder) {
        try (WalRecordsConsumer.DataEntryIterator iter = new WalRecordsConsumer.DataEntryIterator(new IgniteWalIteratorFactory(this.log).iterator(builder.addFilter(ACTIVE_RECS)));){
            boolean interrupted;
            if (this.walState != null) {
                iter.init((Integer)this.walState.get2());
            }
            do {
                boolean commit;
                if (commit = this.consumer.onRecords(iter)) {
                    this.saveStateAndRemoveProcessed(iter.state());
                }
                interrupted = Thread.interrupted();
            } while (iter.hasNext() && !interrupted);
            if (interrupted) {
                throw new IgniteException("Change Data Capture Application interrupted");
            }
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean consumeSegmentPassively(IgniteWalIteratorFactory.IteratorParametersBuilder builder) {
        try (WALIterator iter = new IgniteWalIteratorFactory(this.log).iterator(builder.addFilter(PASSIVE_RECS));){
            boolean interrupted = false;
            while (iter.hasNext() && !interrupted) {
                IgniteBiTuple next = (IgniteBiTuple)iter.next();
                WALRecord walRecord = (WALRecord)next.get2();
                switch (walRecord.type()) {
                    case CDC_MANAGER_RECORD: {
                        this.saveStateAndRemoveProcessed(((CdcManagerRecord)walRecord).walState());
                        break;
                    }
                    case CDC_MANAGER_STOP_RECORD: {
                        this.cdcModeState = CdcMode.CDC_UTILITY_ACTIVE;
                        this.state.saveCdcMode(this.cdcModeState);
                        boolean bl = true;
                        return bl;
                    }
                    default: {
                        throw new IgniteException("Unexpected record [type=" + (Object)((Object)walRecord.type()) + ']');
                    }
                }
                interrupted = Thread.interrupted();
            }
            if (interrupted) {
                throw new IgniteException("Change Data Capture Application interrupted");
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private void updateMetadata() {
        long start = System.currentTimeMillis();
        this.updateMappings();
        this.updateTypes();
        this.updateCaches();
        this.metaUpdate.value(System.currentTimeMillis() - start);
    }

    private void updateTypes() {
        try {
            File[] files = this.binaryMeta.listFiles();
            if (files == null) {
                return;
            }
            Iterator<BinaryType> changedTypes = Arrays.stream(files).filter(p -> p.toString().endsWith(".bin")).map(f -> {
                int typeId = BinaryUtils.typeId(f.getName());
                long lastModified = f.lastModified();
                if (this.typesState.containsKey(typeId) && lastModified == this.typesState.get(typeId)) {
                    return null;
                }
                this.typesState.put(typeId, lastModified);
                try {
                    this.kctx.cacheObjects().cacheMetadataLocally(this.binaryMeta, typeId);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                return this.kctx.cacheObjects().metadata(typeId);
            }).filter(Objects::nonNull).iterator();
            if (!changedTypes.hasNext()) {
                return;
            }
            this.consumer.onTypes(changedTypes);
            if (changedTypes.hasNext()) {
                throw new IllegalStateException("Consumer should handle all changed types");
            }
            this.state.saveTypes(this.typesState);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private void updateMappings() {
        try {
            File[] files = this.marshaller.listFiles(BinaryUtils::notTmpFile);
            if (files == null) {
                return;
            }
            Iterator<TypeMapping> changedMappings = CdcMain.typeMappingIterator(files, tm -> this.mappingsState.add(new T2<Integer, Byte>(tm.typeId(), (byte)tm.platformType().ordinal())));
            if (!changedMappings.hasNext()) {
                return;
            }
            this.consumer.onMappings(changedMappings);
            if (changedMappings.hasNext()) {
                throw new IllegalStateException("Consumer should handle all changed mappings");
            }
            this.state.saveMappings(this.mappingsState);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private void updateCaches() {
        try {
            if (!this.dbDir.exists()) {
                return;
            }
            HashSet<Integer> destroyed = new HashSet<Integer>(this.cachesState.keySet());
            Iterator<CdcCacheEvent> cacheEvts = GridLocalConfigManager.readCachesData(this.dbDir, MarshallerUtils.jdkMarshaller(this.kctx.igniteInstanceName()), this.igniteCfg).entrySet().stream().map(data -> {
                int cacheId = ((StoredCacheData)data.getValue()).cacheId();
                long lastModified = ((File)data.getKey()).lastModified();
                destroyed.remove(cacheId);
                Long lastModified0 = this.cachesState.get(cacheId);
                if (lastModified0 != null && lastModified0 == lastModified) {
                    return null;
                }
                this.cachesState.put(cacheId, lastModified);
                return (CdcCacheEvent)data.getValue();
            }).filter(Objects::nonNull).iterator();
            this.consumer.onCacheEvents(cacheEvts);
            if (cacheEvts.hasNext()) {
                throw new IllegalStateException("Consumer should handle all cache change events");
            }
            if (!destroyed.isEmpty()) {
                Iterator<Integer> destroyedIter = destroyed.iterator();
                this.consumer.onCacheDestroyEvents(destroyedIter);
                if (destroyedIter.hasNext()) {
                    throw new IllegalStateException("Consumer should handle all cache destroy events");
                }
            }
            this.state.saveCaches(this.cachesState);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private boolean removeProcessedOnFailover(Path segment) {
        long segmentIdx = FileWriteAheadLogManager.segmentIndex(segment);
        if (segmentIdx > ((WALPointer)this.walState.get1()).index()) {
            throw new IgniteException("Found segment greater then saved state. Some events are missed. Exiting! [state=" + this.walState + ", segment=" + segmentIdx + ']');
        }
        if (segmentIdx < ((WALPointer)this.walState.get1()).index()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Already processed segment found. Skipping and deleting the file [segment=" + segmentIdx + ", state=" + ((WALPointer)this.walState.get1()).index() + ']');
            }
            try {
                Files.delete(segment);
                return true;
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }
        return false;
    }

    private void saveStateAndRemoveProcessed(T2<WALPointer, Integer> curState) throws IOException {
        if (curState == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Saving state [curState=" + curState + ']');
        }
        this.state.saveWal(curState);
        this.committedSegmentIdx.value(((WALPointer)curState.get1()).index());
        this.committedSegmentOffset.value(((WALPointer)curState.get1()).fileOffset());
        Iterator<Path> rmvIter = this.processedSegments.iterator();
        while (rmvIter.hasNext()) {
            Path processedSegment = rmvIter.next();
            if (FileWriteAheadLogManager.segmentIndex(processedSegment) >= ((WALPointer)curState.get1()).index()) continue;
            Files.delete(processedSegment);
            rmvIter.remove();
        }
    }

    private CdcFileLockHolder tryLock(File dbStoreDirWithSubdirectory) {
        if (!dbStoreDirWithSubdirectory.exists()) {
            this.log.warning("DB store directory not exists. Should be created by Ignite Node  [dir=" + dbStoreDirWithSubdirectory + ']');
            return null;
        }
        File cdcRoot = new File(this.igniteCfg.getDataStorageConfiguration().getCdcWalPath());
        if (!cdcRoot.isAbsolute()) {
            cdcRoot = new File(this.igniteCfg.getWorkDirectory(), this.igniteCfg.getDataStorageConfiguration().getCdcWalPath());
        }
        if (!cdcRoot.exists()) {
            this.log.warning("CDC root directory not exists. Should be created by Ignite Node. Is Change Data Capture enabled in IgniteConfiguration? [dir=" + cdcRoot + ']');
            return null;
        }
        Path cdcDir = Paths.get(cdcRoot.getAbsolutePath(), dbStoreDirWithSubdirectory.getName());
        if (!Files.exists(cdcDir, new LinkOption[0])) {
            this.log.warning("CDC directory not exists. Should be created by Ignite Node. Is Change Data Capture enabled in IgniteConfiguration? [dir=" + cdcDir + ']');
            return null;
        }
        this.cdcDir = cdcDir;
        this.dbDir = dbStoreDirWithSubdirectory;
        CdcFileLockHolder lock = new CdcFileLockHolder(cdcDir.toString(), "cdc.lock", this.log);
        try {
            lock.tryLock(this.cdcCfg.getLockTimeout());
            return lock;
        }
        catch (IgniteCheckedException e) {
            U.closeQuiet(lock);
            if (this.log.isInfoEnabled()) {
                this.log.info("Unable to acquire lock to lock CDC folder [dir=" + cdcRoot + "]" + IgniteKernal.NL + "Reason: " + e.getMessage());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CdcMain cdcMain = this;
        synchronized (cdcMain) {
            if (this.stopped || !this.started) {
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Stopping Change Data Capture service instance");
            }
            this.stopped = true;
            this.consumer.stop();
        }
    }

    private void ackAsciiLogo() {
        String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
        if (this.log.isInfoEnabled()) {
            this.log.info(IgniteKernal.NL + IgniteKernal.NL + ">>>    __________  ________________    ________  _____" + IgniteKernal.NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/   / ___/ _ \\/ ___/" + IgniteKernal.NL + ">>>  _/ // (7 7    // /  / / / _/    / /__/ // / /__  " + IgniteKernal.NL + ">>> /___/\\___/_/|_/___/ /_/ /___/    \\___/____/\\___/  " + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> " + ver + IgniteKernal.NL + ">>> " + IgniteVersionUtils.COPYRIGHT + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> Ignite documentation: http://" + "ignite.apache.org" + IgniteKernal.NL + ">>> Consumer: " + U.toStringSafe(this.consumer.consumer()) + IgniteKernal.NL + ">>> ConsistentId: " + this.igniteCfg.getConsistentId() + IgniteKernal.NL);
        }
        if (this.log.isQuiet()) {
            U.quiet(false, "   __________  ________________    ________  _____", "  /  _/ ___/ |/ /  _/_  __/ __/   / ___/ _ \\/ ___/", " _/ // (7 7    // /  / / / _/    / /__/ // / /__  ", "/___/\\___/_/|_/___/ /_/ /___/    \\___/____/\\___/  ", "", ver, IgniteVersionUtils.COPYRIGHT, "", "Ignite documentation: http://ignite.apache.org", "Consumer: " + U.toStringSafe(this.consumer.consumer()), "ConsistentId: " + this.igniteCfg.getConsistentId(), "", "Quiet mode.");
            String fileName = this.log.fileName();
            if (fileName != null) {
                U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
            }
            if (this.log instanceof GridLoggerProxy) {
                U.quiet(false, "  ^-- Logging by '" + ((GridLoggerProxy)this.log).getLoggerInfo() + '\'');
            }
            U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite-cdc.{sh|bat}", "");
        }
    }

    public static String cdcInstanceName(String igniteInstanceName) {
        return "cdc-" + igniteInstanceName;
    }

    public static Iterator<TypeMapping> typeMappingIterator(File[] files, Predicate<TypeMapping> filter) {
        return Arrays.stream(files).map(f -> {
            String fileName = f.getName();
            int typeId = BinaryUtils.mappedTypeId(fileName);
            byte platformId = BinaryUtils.mappedFilePlatformId(fileName);
            return new TypeMappingImpl(typeId, BinaryUtils.readMapping(f), platformId == 0 ? PlatformType.JAVA : PlatformType.DOTNET);
        }).filter(filter).filter(Objects::nonNull).iterator();
    }
}

