/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.management.ChangeTagCommandArg;
import org.apache.ignite.internal.management.ClusterChangeTagTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
@GridVisorManagementTask
public class ClusterChangeTagTask
extends VisorOneNodeTask<ChangeTagCommandArg, ClusterChangeTagTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<ChangeTagCommandArg, ClusterChangeTagTaskResult> job(ChangeTagCommandArg arg) {
        return new ClusterChangeTagJob(arg, this.debug);
    }

    private static class ClusterChangeTagJob
    extends VisorJob<ChangeTagCommandArg, ClusterChangeTagTaskResult> {
        private static final long serialVersionUID = 0L;

        ClusterChangeTagJob(ChangeTagCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ClusterChangeTagTaskResult run(ChangeTagCommandArg arg) throws IgniteException {
            return this.update(arg.newTagValue());
        }

        private ClusterChangeTagTaskResult update(String newTag) {
            IgniteClusterEx cl = this.ignite.cluster();
            boolean success = false;
            String errMsg = null;
            String oldTag = cl.tag();
            try {
                cl.tag(newTag);
                success = true;
            }
            catch (IgniteCheckedException e) {
                errMsg = e.getMessage();
            }
            return new ClusterChangeTagTaskResult(oldTag, success, errMsg);
        }
    }
}

