/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.performancestatistics;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.performancestatistics.PerformanceStatisticsCommand;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
@GridVisorManagementTask
public class PerformanceStatisticsTask
extends VisorOneNodeTask<IgniteDataTransferObject, String> {
    public static final String STATUS_ENABLED = "Enabled.";
    public static final String STATUS_DISABLED = "Disabled.";
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<IgniteDataTransferObject, String> job(IgniteDataTransferObject arg) {
        return new PerformanceStatisticsJob(arg, false);
    }

    private static class PerformanceStatisticsJob
    extends VisorJob<IgniteDataTransferObject, String> {
        private static final long serialVersionUID = 0L;

        protected PerformanceStatisticsJob(IgniteDataTransferObject arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(IgniteDataTransferObject arg) throws IgniteException {
            try {
                if (arg instanceof PerformanceStatisticsCommand.PerformanceStatisticsStartCommandArg) {
                    this.ignite.context().performanceStatistics().startCollectStatistics();
                    return "Started.";
                }
                if (arg instanceof PerformanceStatisticsCommand.PerformanceStatisticsStopCommandArg) {
                    this.ignite.context().performanceStatistics().stopCollectStatistics();
                    return "Stopped.";
                }
                if (arg instanceof PerformanceStatisticsCommand.PerformanceStatisticsRotateCommandArg) {
                    this.ignite.context().performanceStatistics().rotateCollectStatistics();
                    return "Rotated.";
                }
                if (arg instanceof PerformanceStatisticsCommand.PerformanceStatisticsStatusCommandArg) {
                    return this.ignite.context().performanceStatistics().enabled() ? PerformanceStatisticsTask.STATUS_ENABLED : PerformanceStatisticsTask.STATUS_DISABLED;
                }
                throw new IllegalArgumentException("Unknown operation: " + arg.getClass().getSimpleName());
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }
}

