/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.indexing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IndexesRebuildTask {
    private final Map<Integer, SchemaIndexCacheFuture> idxRebuildFuts = new ConcurrentHashMap<Integer, SchemaIndexCacheFuture>();

    @Nullable
    public IgniteInternalFuture<?> rebuild(GridCacheContext<?, ?> cctx, boolean force, IndexRebuildCancelToken cancelTok) {
        SchemaIndexCacheVisitorClosure clo;
        boolean recreate;
        assert (cctx != null);
        if (!CU.affinityNode(cctx.localNode(), cctx.config().getNodeFilter())) {
            return null;
        }
        IgnitePageStoreManager pageStore = cctx.shared().pageStore();
        String cacheName = cctx.name();
        boolean bl = recreate = pageStore == null || !pageStore.hasIndexStore(cctx.groupId());
        if (recreate) {
            clo = row -> cctx.queries().store(row, null, false);
        } else {
            List<InlineIndex> toRebuild = cctx.kernalContext().indexProcessor().treeIndexes(cctx.name(), !force);
            if (F.isEmpty(toRebuild)) {
                return null;
            }
            clo = row -> cctx.kernalContext().indexProcessor().store(toRebuild, row, null, false);
        }
        cctx.kernalContext().query().markAsRebuildNeeded(cctx, true);
        IgniteLogger log = cctx.kernalContext().grid().log();
        if (recreate) {
            cctx.kernalContext().query().markIndexRecreate(cctx);
            cctx.group().indexWalEnabled(false);
            if (log.isInfoEnabled()) {
                log.info("WAL disabled for index partition [name=" + cctx.group().cacheOrGroupName() + ", id=" + cctx.groupId() + ']');
            }
        }
        GridFutureAdapter<Void> rebuildCacheIdxFut = new GridFutureAdapter<Void>();
        GridFutureAdapter outRebuildCacheIdxFut = new GridFutureAdapter();
        SchemaIndexCacheFuture intRebFut = new SchemaIndexCacheFuture(cancelTok);
        SchemaIndexCacheFuture prevIntRebFut = this.idxRebuildFuts.put(cctx.cacheId(), intRebFut);
        assert (prevIntRebFut == null);
        cctx.kernalContext().query().onStartRebuildIndexes(cctx, recreate);
        rebuildCacheIdxFut.listen(() -> {
            Throwable err = rebuildCacheIdxFut.error();
            if (err == null) {
                try {
                    cctx.kernalContext().query().markAsRebuildNeeded(cctx, false);
                }
                catch (Throwable t) {
                    err = t;
                }
            }
            if (err != null) {
                U.error(log, "Failed to rebuild indexes for cache: " + cacheName, err);
            } else {
                cctx.kernalContext().query().onFinishRebuildIndexes(cctx);
            }
            this.idxRebuildFuts.remove(cctx.cacheId(), intRebFut);
            if (recreate) {
                boolean recreateContinues = false;
                for (GridCacheContext cctx0 : cctx.group().caches()) {
                    if (!this.idxRebuildFuts.containsKey(cctx0.cacheId())) continue;
                    recreateContinues = true;
                    break;
                }
                if (!recreateContinues) {
                    cctx.group().indexWalEnabled(true);
                    if (log.isInfoEnabled()) {
                        log.info("WAL enabled for index partition [name=" + cctx.group().cacheOrGroupName() + ", id=" + cctx.group().groupId() + ']');
                    }
                }
            }
            intRebFut.onDone(err);
            outRebuildCacheIdxFut.onDone(err);
        });
        this.startRebuild(cctx, rebuildCacheIdxFut, clo, intRebFut.cancelToken());
        return outRebuildCacheIdxFut;
    }

    protected void startRebuild(GridCacheContext cctx, GridFutureAdapter<Void> fut, SchemaIndexCacheVisitorClosure clo, IndexRebuildCancelToken cancelTok) {
        new SchemaIndexCacheVisitorImpl(cctx, cancelTok, fut).visit(clo);
    }

    public void stopRebuild(GridCacheContextInfo cacheInfo, IgniteLogger log) {
        this.cancelIndexRebuildFuture(this.idxRebuildFuts.remove(cacheInfo.cacheId()), log);
    }

    private void cancelIndexRebuildFuture(@Nullable SchemaIndexCacheFuture rebFut, IgniteLogger log) {
        block3: {
            if (rebFut != null && !rebFut.isDone() && rebFut.cancelToken().cancel(new SchemaIndexOperationCancellationException("Index rebuild was cancelled."))) {
                try {
                    rebFut.get();
                }
                catch (IgniteCheckedException e) {
                    if (e instanceof SchemaIndexOperationCancellationException) break block3;
                    log.warning("Error after canceling index rebuild.", e);
                }
            }
        }
    }
}

