/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;

public class LazyMvccDataEntry
extends MvccDataEntry
implements MarshalledDataEntry {
    private GridCacheSharedContext cctx;
    private byte keyType;
    private byte[] keyBytes;
    private byte valType;
    private byte[] valBytes;

    public LazyMvccDataEntry(GridCacheSharedContext cctx, int cacheId, byte keyType, byte[] keyBytes, byte valType, byte[] valBytes, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt, MvccVersion mvccVer) {
        super(cacheId, null, null, op, nearXidVer, writeVer, expireTime, partId, partCnt, mvccVer);
        this.cctx = cctx;
        this.keyType = keyType;
        this.keyBytes = keyBytes;
        this.valType = valType;
        this.valBytes = valBytes;
    }

    @Override
    public KeyCacheObject key() {
        try {
            if (this.key == null) {
                GridCacheContext cacheCtx = this.cctx.cacheContext(this.cacheId);
                if (cacheCtx == null) {
                    throw new IgniteException("Failed to find cache context for the given cache ID: " + this.cacheId);
                }
                IgniteCacheObjectProcessor co = this.cctx.kernalContext().cacheObjects();
                this.key = co.toKeyCacheObject(cacheCtx.cacheObjectContext(), this.keyType, this.keyBytes);
                if (this.key.partition() == -1) {
                    this.key.partition(this.partId);
                }
            }
            return this.key;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public CacheObject value() {
        if (this.val == null && this.valBytes != null) {
            GridCacheContext cacheCtx = this.cctx.cacheContext(this.cacheId);
            if (cacheCtx == null) {
                throw new IgniteException("Failed to find cache context for the given cache ID: " + this.cacheId);
            }
            IgniteCacheObjectProcessor co = this.cctx.kernalContext().cacheObjects();
            this.val = co.toCacheObject(cacheCtx.cacheObjectContext(), this.valType, this.valBytes);
        }
        return this.val;
    }

    @Override
    public byte getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    @Override
    public byte getValType() {
        return this.valType;
    }

    @Override
    public byte[] getValBytes() {
        return this.valBytes;
    }
}

