/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.cache.CacheClearCommandArg;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ClearCachesTask
extends VisorOneNodeTask<CacheClearCommandArg, ClearCachesTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CacheClearCommandArg, ClearCachesTaskResult> job(CacheClearCommandArg arg) {
        return new ClearCacheJob(arg, this.debug);
    }

    private static class ClearCacheJob
    extends VisorJob<CacheClearCommandArg, ClearCachesTaskResult> {
        private static final long serialVersionUID = 0L;
        private Ignite ignite;

        private ClearCacheJob(CacheClearCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ClearCachesTaskResult run(@Nullable CacheClearCommandArg arg) throws IgniteException {
            ArrayList<String> clearedCaches = new ArrayList<String>();
            ArrayList<String> nonExistentCaches = new ArrayList<String>();
            for (String cache : arg.caches()) {
                IgniteCache ignCache = this.ignite.cache(cache);
                if (ignCache == null) {
                    nonExistentCaches.add(cache);
                    continue;
                }
                ignCache.clear();
                clearedCaches.add(cache);
            }
            return new ClearCachesTaskResult(clearedCaches, nonExistentCaches);
        }

        @IgniteInstanceResource
        public void setIgnite(Ignite ignite) {
            this.ignite = ignite;
        }
    }
}

