/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLongList;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateCounterVolatileImpl
implements PartitionUpdateCounter {
    private final AtomicLong cntr = new AtomicLong();
    private volatile long initCntr;
    private final CacheGroupContext grp;

    public PartitionUpdateCounterVolatileImpl(CacheGroupContext grp) {
        this.grp = grp;
    }

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.cntr.set(initUpdCntr);
        this.initCntr = initUpdCntr;
    }

    @Override
    public long initial() {
        return this.initCntr;
    }

    @Override
    public long get() {
        return this.cntr.get();
    }

    @Override
    public long next() {
        return this.cntr.incrementAndGet();
    }

    @Override
    public void update(long val) {
        long cur;
        while (val > (cur = this.cntr.get()) && !this.cntr.compareAndSet(cur, val)) {
        }
    }

    @Override
    public boolean update(long start, long delta) {
        this.update(start + delta);
        return false;
    }

    @Override
    public synchronized void updateInitial(long start, long delta) {
        this.update(start + delta);
        this.initCntr = this.get();
    }

    @Override
    public GridLongList finalizeUpdateCounters() {
        return new GridLongList();
    }

    @Override
    public long reserve(long delta) {
        return this.next(delta);
    }

    @Override
    public long next(long delta) {
        return this.cntr.getAndAdd(delta);
    }

    @Override
    public boolean sequential() {
        return true;
    }

    @Override
    @Nullable
    public byte[] getBytes() {
        return null;
    }

    @Override
    public synchronized void reset() {
        this.initCntr = 0L;
        this.cntr.set(0L);
    }

    @Override
    public void resetInitialCounter() {
        this.initCntr = 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionUpdateCounterVolatileImpl cntr = (PartitionUpdateCounterVolatileImpl)o;
        return this.cntr.get() == cntr.cntr.get();
    }

    @Override
    public long reserved() {
        return this.get();
    }

    @Override
    public long highestAppliedCounter() {
        return this.get();
    }

    @Override
    public boolean empty() {
        return this.get() == 0L;
    }

    @Override
    public Iterator<long[]> iterator() {
        return new GridEmptyIterator<long[]>();
    }

    public String toString() {
        return "Counter [init=" + this.initCntr + ", val=" + this.get() + ']';
    }

    @Override
    public CacheGroupContext context() {
        return this.grp;
    }

    @Override
    public PartitionUpdateCounter copy() {
        PartitionUpdateCounterVolatileImpl copy = new PartitionUpdateCounterVolatileImpl(this.grp);
        copy.cntr.set(this.cntr.get());
        copy.initCntr = this.initCntr;
        return copy;
    }

    @Override
    public Object comparableState() {
        return this.get();
    }
}

